/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.Difference;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Percentage;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.Generated;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.Fraction;

public final class Coverage
extends Value {
    private static final long serialVersionUID = -3802318446471137305L;
    private static final String FRACTION_SEPARATOR = "/";
    private static final String N_A = "n/a";
    private final int missed;

    public static Coverage valueOf(Metric metric, String stringRepresentation) {
        String errorMessage = "Cannot convert %s to a valid Coverage instance.".formatted(stringRepresentation);
        try {
            String cleanedFormat = StringUtils.deleteWhitespace((String)stringRepresentation);
            if (N_A.equals(cleanedFormat)) {
                return Coverage.nullObject(metric);
            }
            if (Strings.CS.contains((CharSequence)cleanedFormat, (CharSequence)FRACTION_SEPARATOR)) {
                String extractedCovered = StringUtils.substringBefore((String)cleanedFormat, (String)FRACTION_SEPARATOR);
                String extractedTotal = StringUtils.substringAfter((String)cleanedFormat, (String)FRACTION_SEPARATOR);
                int covered = Integer.parseInt(extractedCovered);
                int total = Integer.parseInt(extractedTotal);
                if (total >= covered) {
                    return new CoverageBuilder().withMetric(metric).withCovered(covered).withMissed(total - covered).build();
                }
            }
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException(errorMessage, exception);
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public static Coverage nullObject(Metric metric) {
        return new CoverageBuilder().withMetric(metric).withCovered(0).withMissed(0).build();
    }

    private Coverage(Metric metric, int covered, int missed) {
        super(metric, Fraction.getFraction((double)covered));
        this.missed = missed;
    }

    public int getCovered() {
        return this.getFraction().getNumerator();
    }

    public Percentage getCoveredPercentage() {
        if (this.getTotal() == 0) {
            return Percentage.HUNDRED;
        }
        return Percentage.valueOf(this.getCovered(), this.getTotal());
    }

    public int getMissed() {
        return this.missed;
    }

    @Override
    public Coverage add(Value other) {
        Coverage otherCoverage = this.castValue(other);
        return new CoverageBuilder().withMetric(this.getMetric()).withCovered(this.getCovered() + otherCoverage.getCovered()).withMissed(this.getMissed() + otherCoverage.getMissed()).build();
    }

    @Override
    public Difference subtract(Value other) {
        this.ensureSameMetricAndType(other);
        return new Difference(this.getMetric(), this.asDouble() - other.asDouble());
    }

    @Override
    public Coverage max(Value other) {
        Coverage otherCoverage = this.castValue(other);
        Ensure.that((this.getTotal() == otherCoverage.getTotal() ? 1 : 0) != 0).isTrue("Cannot compute maximum of coverages %s and %s since total differs", new Object[]{this, other});
        if (this.getCovered() >= otherCoverage.getCovered()) {
            return this;
        }
        return otherCoverage;
    }

    private Coverage castValue(Value other) {
        this.ensureSameMetricAndType(other);
        return (Coverage)other;
    }

    @Override
    public boolean isOutOfValidRange(double threshold) {
        return this.getCoveredPercentage().toDouble() < threshold;
    }

    public int getTotal() {
        return this.getCovered() + this.getMissed();
    }

    public boolean isSet() {
        return this.getTotal() > 0;
    }

    @Override
    public String asText(Locale locale) {
        if (this.isSet()) {
            return String.format(locale, "%.2f%%", this.asRounded());
        }
        return N_A;
    }

    @Override
    public String asInformativeText(Locale locale) {
        if (this.isSet()) {
            return String.format(locale, "%.2f%% (%d/%d)", this.asRounded(), this.getCovered(), this.getTotal());
        }
        return N_A;
    }

    @Override
    public int asInteger() {
        return this.getCoveredPercentage().toInt();
    }

    @Override
    public double asDouble() {
        return this.getCoveredPercentage().toDouble();
    }

    @Override
    protected String serializeValue() {
        if (this.isSet()) {
            return String.format(Locale.ENGLISH, "%d/%d", this.getCovered(), this.getTotal());
        }
        return N_A;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Coverage coverage = (Coverage)o;
        return this.missed == coverage.missed;
    }

    @Override
    @Generated
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.missed);
    }

    @Override
    public String toString() {
        if (this.isSet()) {
            return String.format(Locale.ENGLISH, "%s: %s (%d/%d)", new Object[]{this.getMetric(), this.getCoveredPercentage(), this.getCovered(), this.getTotal()});
        }
        return String.format(Locale.ENGLISH, "%s: n/a", new Object[]{this.getMetric()});
    }

    @Override
    public double asRounded() {
        return this.getCoveredPercentage().toRounded();
    }

    public static final class CoverageBuilder {
        @VisibleForTesting
        static final int CACHE_SIZE = 16;
        private static final Coverage[] LINE_CACHE = new Coverage[256];
        private static final Coverage[] BRANCH_CACHE = new Coverage[256];
        private static final Coverage[] INSTRUCTION_CACHE = new Coverage[256];
        private static final Coverage[] MUTATION_CACHE = new Coverage[256];
        private static final Coverage[] MCDC_PAIR_CACHE = new Coverage[256];
        private static final Coverage[] FUNCTION_CALL_CACHE = new Coverage[256];
        @CheckForNull
        private Metric metric;
        private int covered;
        private boolean isCoveredSet;
        private int missed;
        private boolean isMissedSet;
        private int total;
        private boolean isTotalSet;

        private static int getCacheIndex(int covered, int missed) {
            return covered * 16 + missed;
        }

        public CoverageBuilder() {
        }

        public CoverageBuilder(@CheckForNull Metric metric) {
            this.metric = metric;
        }

        public CoverageBuilder(Coverage existing) {
            this.withMetric(existing.getMetric());
            this.withCovered(existing.getCovered());
            this.withMissed(existing.getMissed());
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withMetric(Metric metric) {
            this.metric = metric;
            return this;
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withMetric(String metric) {
            return this.withMetric(Metric.valueOf(metric));
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withTotal(int total) {
            this.total = total;
            this.isTotalSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withTotal(String total) {
            return this.withTotal(CoverageParser.parseInteger(total));
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withCovered(int covered) {
            Ensure.that((covered >= 0 ? 1 : 0) != 0).isTrue("No negative values allowed for covered items: %s", new Object[]{covered});
            this.covered = covered;
            this.isCoveredSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withCovered(String covered) {
            return this.withCovered(CoverageParser.parseInteger(covered));
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withMissed(int missed) {
            Ensure.that((missed >= 0 ? 1 : 0) != 0).isTrue("No negative values allowed for missed items: %s", new Object[]{missed});
            this.missed = missed;
            this.isMissedSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public CoverageBuilder withMissed(String missed) {
            return this.withMissed(CoverageParser.parseInteger(missed));
        }

        public Coverage build() {
            if (this.isCoveredSet && this.isMissedSet && this.isTotalSet) {
                throw new IllegalArgumentException("Setting all three values covered, missed, and total is not allowed, just select two of them.");
            }
            if (this.isTotalSet) {
                if (this.isCoveredSet) {
                    return this.createOrGetCoverage(this.covered, this.total - this.covered);
                }
                if (this.isMissedSet) {
                    return this.createOrGetCoverage(this.total - this.missed, this.missed);
                }
            } else if (this.isCoveredSet && this.isMissedSet) {
                return this.createOrGetCoverage(this.covered, this.missed);
            }
            throw new IllegalArgumentException("Exactly two properties have to be set.");
        }

        private Coverage createOrGetCoverage(int covered, int missed) {
            if (this.metric == null) {
                throw new IllegalArgumentException("No metric defined.");
            }
            if (covered < 16 && missed < 16) {
                switch (this.metric) {
                    case LINE: {
                        return LINE_CACHE[CoverageBuilder.getCacheIndex(covered, missed)];
                    }
                    case BRANCH: {
                        return BRANCH_CACHE[CoverageBuilder.getCacheIndex(covered, missed)];
                    }
                    case INSTRUCTION: {
                        return INSTRUCTION_CACHE[CoverageBuilder.getCacheIndex(covered, missed)];
                    }
                    case MUTATION: {
                        return MUTATION_CACHE[CoverageBuilder.getCacheIndex(covered, missed)];
                    }
                    case MCDC_PAIR: {
                        return MCDC_PAIR_CACHE[CoverageBuilder.getCacheIndex(covered, missed)];
                    }
                    case FUNCTION_CALL: {
                        return FUNCTION_CALL_CACHE[CoverageBuilder.getCacheIndex(covered, missed)];
                    }
                }
            }
            return new Coverage(this.metric, covered, missed);
        }

        public void incrementCovered() {
            this.incrementCovered(1);
        }

        public void incrementCovered(int amount) {
            this.withCovered(this.covered + amount);
        }

        public void incrementMissed() {
            this.incrementMissed(1);
        }

        public void incrementMissed(int amount) {
            this.withMissed(this.missed + amount);
        }

        static {
            for (int covered = 0; covered < 16; ++covered) {
                for (int missed = 0; missed < 16; ++missed) {
                    CoverageBuilder.LINE_CACHE[CoverageBuilder.getCacheIndex((int)covered, (int)missed)] = new Coverage(Metric.LINE, covered, missed);
                    CoverageBuilder.BRANCH_CACHE[CoverageBuilder.getCacheIndex((int)covered, (int)missed)] = new Coverage(Metric.BRANCH, covered, missed);
                    CoverageBuilder.INSTRUCTION_CACHE[CoverageBuilder.getCacheIndex((int)covered, (int)missed)] = new Coverage(Metric.INSTRUCTION, covered, missed);
                    CoverageBuilder.MUTATION_CACHE[CoverageBuilder.getCacheIndex((int)covered, (int)missed)] = new Coverage(Metric.MUTATION, covered, missed);
                    CoverageBuilder.MCDC_PAIR_CACHE[CoverageBuilder.getCacheIndex((int)covered, (int)missed)] = new Coverage(Metric.MCDC_PAIR, covered, missed);
                    CoverageBuilder.FUNCTION_CALL_CACHE[CoverageBuilder.getCacheIndex((int)covered, (int)missed)] = new Coverage(Metric.FUNCTION_CALL, covered, missed);
                }
            }
        }
    }
}

