/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.ContainerNode;
import edu.hm.hafner.coverage.Difference;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Mutation;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.TestCase;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.TreeString;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -6608885640271135273L;
    static final String EMPTY_NAME = "-";
    static final String ROOT = "^";
    private final Metric metric;
    private String name;
    private final List<Node> children = new ArrayList<Node>();
    private final List<Value> values = new ArrayList<Value>();
    @CheckForNull
    private Node parent;

    protected Node(Metric metric, String name) {
        Ensure.that((boolean)metric.isContainer()).isTrue("Cannot create a container node with a value metric", new Object[0]);
        this.metric = metric;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.getName();
    }

    void setName(String name) {
        this.name = name;
    }

    public String getParentName() {
        if (this.parent == null) {
            return ROOT;
        }
        Metric type = this.parent.getMetric();
        ArrayList<String> parentsOfSameType = new ArrayList<String>();
        Node node = this.parent;
        while (node != null && node.getMetric() == type) {
            parentsOfSameType.add(0, node.getName());
            node = node.parent;
        }
        return String.join((CharSequence)".", parentsOfSameType);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public NavigableSet<Metric> getMetrics() {
        NavigableSet elements = this.children.stream().map(Node::getMetrics).flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new));
        this.getMetricsOfValues().forEach(elements::add);
        if (elements.stream().anyMatch(Metric::isCoverage)) {
            elements.add(this.getMetric());
        }
        if (elements.contains((Object)Metric.LINE)) {
            elements.add(Metric.LOC);
        }
        return elements;
    }

    public boolean containsMetric(Metric searchMetric) {
        return this.getMetrics().contains((Object)searchMetric);
    }

    public Set<String> getSourceFolders() {
        return this.children.stream().map(Node::getSourceFolders).flatMap(Collection::parallelStream).collect(Collectors.toSet());
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<Node> getChildren() {
        return new ArrayList<Node>(this.children);
    }

    public void addChild(Node child) {
        if (this.hasChild(child.getId())) {
            throw new IllegalArgumentException("There is already the same child %s with the name %s in %s".formatted(child, child.getName(), this));
        }
        this.children.add(child);
        child.setParent(this);
    }

    protected void removeChild(Node child) {
        Ensure.that((boolean)this.children.contains(child)).isTrue("The node %s is not a child of this node %s", new Object[]{child, this});
        this.children.remove(child);
        child.parent = null;
    }

    public boolean hasChild(String childName) {
        return this.children.stream().map(Node::getId).anyMatch(childName::equals);
    }

    public void addAllChildren(Collection<? extends Node> nodes) {
        nodes.forEach(this::addChild);
    }

    public void addAllChildren(Node ... nodes) {
        this.addAllChildren(List.of(nodes));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This class is about walking through a tree of nodes.")
    public Node getParent() {
        if (this.parent == null) {
            throw new NoSuchElementException("Parent is not set");
        }
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasParent() {
        return !this.isRoot();
    }

    private void setParent(Node parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public List<Value> getValues() {
        return List.copyOf(this.values);
    }

    public void addValue(Value value) {
        if (this.getMetricsOfValues().anyMatch(value.getMetric()::equals)) {
            throw new IllegalArgumentException("There is already a leaf %s with the metric %s".formatted(new Object[]{value, value.getMetric()}));
        }
        this.replaceValue(value);
    }

    public void replaceValue(Value value) {
        this.values.stream().filter(v -> v.getMetric() == value.getMetric()).findAny().ifPresent(this.values::remove);
        this.values.add(value);
    }

    protected void addAllValues(Collection<? extends Value> additionalValues) {
        additionalValues.forEach(this::addValue);
    }

    public NavigableSet<Metric> getValueMetrics() {
        NavigableSet elements = this.children.stream().map(Node::getValueMetrics).flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new));
        this.getMetricsOfValues().forEach(elements::add);
        return elements;
    }

    private Stream<Metric> getMetricsOfValues() {
        return this.values.stream().map(Value::getMetric);
    }

    NavigableMap<Metric, Value> getMetricsDistribution() {
        return new TreeMap<Metric, Value>(this.aggregateValues().stream().collect(Collectors.toMap(Value::getMetric, Function.identity())));
    }

    public Optional<Value> getValue(Metric searchMetric) {
        return searchMetric.getValueFor(this);
    }

    public <T extends Value> T getTypedValue(Metric searchMetric, T defaultValue) {
        Optional<Value> possiblyValue = searchMetric.getValueFor(this);
        return (T)possiblyValue.map(value -> (Value)defaultValue.getClass().cast(value)).orElse(defaultValue);
    }

    public List<Value> aggregateValues() {
        return this.getMetrics().stream().sorted().map(this::getValue).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public List<Difference> computeDelta(Node reference) {
        ArrayList<Difference> deltaPercentages = new ArrayList<Difference>();
        NavigableMap<Metric, Value> metricPercentages = this.getMetricsDistribution();
        NavigableMap<Metric, Value> referencePercentages = reference.getMetricsDistribution();
        for (Map.Entry entry : metricPercentages.entrySet()) {
            Metric key = (Metric)((Object)entry.getKey());
            if (!referencePercentages.containsKey((Object)key)) continue;
            deltaPercentages.add(((Value)entry.getValue()).subtract((Value)referencePercentages.get((Object)key)));
        }
        return deltaPercentages;
    }

    public List<Node> getAll(Metric searchMetric) {
        List<Node> childNodes = this.children.stream().map(child -> child.getAll(searchMetric)).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.metric == searchMetric) {
            childNodes.add(this);
        }
        return childNodes;
    }

    private <T extends Node> List<T> getAll(Metric searchMetric, Function<Node, T> cast) {
        return this.getAll(searchMetric).stream().map(cast).collect(Collectors.toList());
    }

    public List<FileNode> getAllFileNodes() {
        return this.getAll(Metric.FILE, FileNode.class::cast);
    }

    public List<ClassNode> getAllClassNodes() {
        return this.getAll(Metric.CLASS, ClassNode.class::cast);
    }

    public List<MethodNode> getAllMethodNodes() {
        return this.getAll(Metric.METHOD, MethodNode.class::cast);
    }

    public Optional<Node> find(Metric searchMetric, String searchName) {
        if (this.matches(searchMetric, searchName)) {
            return Optional.of(this);
        }
        return this.children.stream().map(child -> child.find(searchMetric, searchName)).flatMap(Optional::stream).findAny();
    }

    public Optional<PackageNode> findPackage(String searchName) {
        return this.find(Metric.PACKAGE, searchName).map(PackageNode.class::cast);
    }

    public Optional<FileNode> findFile(String searchPath) {
        return this.find(Metric.FILE, searchPath).map(FileNode.class::cast);
    }

    private Optional<FileNode> findFile(String fileName, String relativePath) {
        return this.getAllFileNodes().stream().filter(fileNode -> (fileNode.getName().equals(fileName) || fileNode.getFileName().equals(fileName)) && fileNode.getRelativePath().equals(relativePath)).findAny();
    }

    public Optional<ClassNode> findClass(String searchName) {
        return this.find(Metric.CLASS, searchName).map(ClassNode.class::cast);
    }

    public Optional<MethodNode> findMethod(String searchName, String searchSignature) {
        return this.getAll(Metric.METHOD).stream().map(MethodNode.class::cast).filter(node -> node.getMethodName().equals(searchName) && node.getSignature().equals(searchSignature)).findAny();
    }

    public List<Mutation> getMutations() {
        return this.getChildren().stream().map(Node::getMutations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<TestCase> getTestCases() {
        return this.getChildren().stream().map(Node::getTestCases).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Set<String> getFiles() {
        return this.children.stream().map(Node::getFiles).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Optional<Node> findByHashCode(Metric searchMetric, int searchNameHashCode) {
        if (this.matches(searchMetric, searchNameHashCode)) {
            return Optional.of(this);
        }
        return this.children.stream().map(child -> child.findByHashCode(searchMetric, searchNameHashCode)).flatMap(Optional::stream).findAny();
    }

    public boolean matches(Metric searchMetric, String searchName) {
        return this.metric == searchMetric && this.getId().equals(searchName);
    }

    public boolean matches(Metric searchMetric, int searchNameHashCode) {
        return this.metric == searchMetric && this.getId().hashCode() == searchNameHashCode;
    }

    public Node copyTree() {
        return this.copyTree(null);
    }

    public Node copyTree(@CheckForNull Node copiedParent) {
        return this.copyTree(copiedParent, f -> true);
    }

    public Node copyTree(@CheckForNull Node copiedParent, Function<Node, Boolean> filter) {
        Node copy = this.copyNode();
        if (copiedParent != null) {
            copy.setParent(copiedParent);
        }
        this.getChildren().stream().filter(filter::apply).map(node -> node.copyTree(this, filter)).forEach(copy::addChild);
        return copy;
    }

    public Node filterByFileNames(Collection<String> fileNames) {
        return this.copyTree(null, node -> node.filterByRelativePath(fileNames));
    }

    protected boolean filterByRelativePath(Collection<String> fileNames) {
        return true;
    }

    public final Node copyNode() {
        Node copy = this.copy();
        this.getValues().forEach(copy::addValue);
        return copy;
    }

    public abstract Node copy();

    public Set<ClassNode> mergeTests(Collection<ClassNode> testClassNodes) {
        Integer totalTests = testClassNodes.stream().map(testClass -> testClass.getValue(Metric.TESTS)).flatMap(Optional::stream).reduce(Value::add).map(Value::asInteger).orElse(0);
        this.addValue(new Value(Metric.TESTS, totalTests));
        return testClassNodes.stream().map(this::mapTestClass).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    private Optional<ClassNode> mapTestClass(ClassNode testClassNode) {
        Optional<ClassNode> targetClass = this.findPackage(testClassNode.getPackageName()).map(Node::getAllClassNodes).stream().flatMap(Collection::stream).filter(classNode -> classNode.getName().endsWith(this.createTargetClassName(testClassNode))).findFirst();
        if (targetClass.isPresent()) {
            targetClass.get().addTestCases(testClassNode.getTestCases());
            return Optional.empty();
        }
        return Optional.of(testClassNode);
    }

    private String createTargetClassName(ClassNode testClassNode) {
        return RegExUtils.removeAll((String)testClassNode.getName(), (String)"I?Tests?$");
    }

    public static Node merge(List<? extends Node> nodes) {
        ContainerNode container = new ContainerNode("Container");
        if (nodes.isEmpty()) {
            return container;
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        Map<ImmutablePair, List<Node>> grouped = nodes.stream().collect(Collectors.groupingBy(n -> new ImmutablePair((Object)n.getName(), (Object)n.getMetric())));
        if (grouped.size() == 1) {
            return nodes.stream().map(Node.class::cast).reduce(Node::merge).orElseThrow(() -> new NoSuchElementException("No node found"));
        }
        for (List<Node> matching : grouped.values()) {
            container.addChild(Node.merge(matching));
        }
        return container;
    }

    public Node merge(Node other) {
        if (other == this) {
            return this;
        }
        this.ensureSameMetric(other);
        if (this.getName().equals(other.getName())) {
            Node combinedReport = this.copyTree();
            combinedReport.mergeNode(other);
            return combinedReport;
        }
        throw new IllegalArgumentException("Cannot merge nodes with different names: %s - %s".formatted(this, other));
    }

    private void ensureSameMetric(Node other) {
        if (this.getMetric() != other.getMetric()) {
            throw new IllegalArgumentException("Cannot merge nodes of different metrics: %s - %s".formatted(this, other));
        }
    }

    protected void mergeNode(Node other) {
        this.ensureSameMetric(other);
        this.removeValues();
        other.getChildren().forEach(otherChild -> {
            Optional<Node> existingChild = this.getChildren().stream().filter(c -> c.getId().equals(otherChild.getId())).findFirst();
            if (existingChild.isPresent()) {
                existingChild.get().mergeNode((Node)otherChild);
            } else {
                this.addChild(otherChild.copyTree());
            }
        });
    }

    void removeValues() {
        this.values.clear();
    }

    void removeChildren() {
        this.children.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals((Object)this.metric, (Object)node.metric) && Objects.equals(this.name, node.name) && Objects.equals(this.children, node.children) && Objects.equals(this.values, node.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metric, this.name, this.children, this.values});
    }

    public String toString() {
        return this.getValue(Metric.LINE).map(lineCoverage -> String.format(Locale.ENGLISH, "[%s] %s <%d, %s>", new Object[]{this.getMetric(), this.getName(), this.getChildren().size(), lineCoverage})).orElse(String.format(Locale.ENGLISH, "[%s] %s <%d>", new Object[]{this.getMetric(), this.getName(), this.children.size()}));
    }

    public boolean isEmpty() {
        return this.getChildren().isEmpty() && this.getValues().isEmpty();
    }

    public boolean hasModifiedLines() {
        return this.getChildren().stream().anyMatch(Node::hasModifiedLines);
    }

    public Node filterByModifiedLines() {
        return this.filterTreeByModifiedLines().orElse(this.copy());
    }

    protected Optional<Node> filterTreeByModifiedLines() {
        return this.filterTreeByMapping(Node::filterTreeByModifiedLines);
    }

    public Node filterByModifiedFiles() {
        return this.filterTreeByModifiedFiles().orElse(this.copy());
    }

    protected Optional<Node> filterTreeByModifiedFiles() {
        return this.filterTreeByMapping(Node::filterTreeByModifiedFiles);
    }

    public Node filterByIndirectChanges() {
        return this.filterTreeByIndirectChanges().orElse(this.copy());
    }

    protected Optional<Node> filterTreeByIndirectChanges() {
        return this.filterTreeByMapping(Node::filterTreeByIndirectChanges);
    }

    private Optional<Node> filterTreeByMapping(Function<Node, Optional<Node>> mappingFunction) {
        List prunedChildren = this.getChildren().stream().map(mappingFunction).flatMap(Optional::stream).collect(Collectors.toList());
        if (prunedChildren.isEmpty()) {
            return Optional.empty();
        }
        Node copy = this.copy();
        copy.addAllChildren(prunedChildren);
        return Optional.of(copy);
    }

    public MethodNode createMethodNode(String methodName, String signature) {
        return this.addChildNode(new MethodNode(methodName, signature));
    }

    public ClassNode createClassNode(String className) {
        return this.addChildNode(new ClassNode(className));
    }

    public FileNode createFileNode(String fileName, TreeString relativePath) {
        return this.addChildNode(new FileNode(FilenameUtils.getName((String)fileName), relativePath));
    }

    public PackageNode createPackageNode(String packageName) {
        return this.addChildNode(new PackageNode(packageName));
    }

    @CanIgnoreReturnValue
    private <T extends Node> T addChildNode(T child) {
        this.addChild(child);
        return child;
    }

    public ClassNode findOrCreateClassNode(String className) {
        return this.findClass(className).orElseGet(() -> this.createClassNode(className));
    }

    public FileNode findOrCreateFileNode(String fileName, TreeString relativePath) {
        return this.findFile(fileName, relativePath.toString()).orElseGet(() -> this.createFileNode(fileName, relativePath));
    }

    public PackageNode findOrCreatePackageNode(String packageName) {
        String normalizedPackageName = PackageNode.normalizePackageName(packageName);
        return this.findPackage(normalizedPackageName).orElseGet(() -> this.createPackageNode(normalizedPackageName));
    }

    public abstract boolean isAggregation();
}

