/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.TestCase;
import edu.hm.hafner.coverage.parser.AbstractTestParser;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class JunitParser
extends AbstractTestParser {
    private static final long serialVersionUID = -5468593789018138107L;
    private static final QName TEST_SUITE = new QName("testsuite");
    private static final QName TEST_CASE = new QName("testcase");
    private static final QName FAILURE_TYPE = new QName("type");
    private static final QName ERROR = new QName("error");
    private static final QName SKIPPED = new QName("skipped");

    public JunitParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public JunitParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode, TEST_SUITE, TEST_CASE);
    }

    @Override
    TestCase readTestCase(XMLEventReader reader, StartElement testCaseElement, String suiteName, ModuleNode root, String fileName) throws XMLStreamException {
        TestCase.TestCaseBuilder builder = new TestCase.TestCaseBuilder();
        builder.withTestName(JunitParser.getOptionalValueOf(testCaseElement, NAME).orElse(this.createId()));
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && this.isFailure(event)) {
                this.readFailure(reader, event.asStartElement(), builder);
                continue;
            }
            if (event.isStartElement() && SKIPPED.equals(event.asStartElement().getName())) {
                builder.withStatus(TestCase.TestResult.SKIPPED);
                continue;
            }
            if (!event.isEndElement() || !TEST_CASE.equals(event.asEndElement().getName())) continue;
            String className = JunitParser.getOptionalValueOf(testCaseElement, CLASS_NAME).orElse(suiteName);
            builder.withClassName(className);
            String packageName = this.createPackageForClass(className);
            PackageNode packageNode = root.findOrCreatePackageNode(packageName);
            ClassNode classNode = packageNode.findOrCreateClassNode(className);
            classNode.addTestCase(builder.build());
            return builder.build();
        }
        throw JunitParser.createEofException(fileName);
    }

    private boolean isFailure(XMLEvent event) {
        QName name = this.getElementName(event);
        return FAILURE.equals(name) || ERROR.equals(name);
    }

    private String createPackageForClass(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            return className.substring(0, lastDot);
        }
        return "-";
    }

    private void readFailure(XMLEventReader reader, StartElement startElement, TestCase.TestCaseBuilder builder) throws XMLStreamException {
        builder.withFailure();
        JunitParser.getOptionalValueOf(startElement, FAILURE_TYPE).ifPresent(builder::withType);
        JunitParser.getOptionalValueOf(startElement, MESSAGE).ifPresent(builder::withMessage);
        StringBuilder aggregatedContent = new StringBuilder();
        while (true) {
            XMLEvent event;
            if ((event = reader.nextEvent()).isCharacters()) {
                aggregatedContent.append(event.asCharacters().getData());
                continue;
            }
            if (event.isEndElement() && this.isFailure(event)) break;
        }
        builder.withDescription(aggregatedContent.toString());
    }
}

