/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Mutation;
import edu.hm.hafner.coverage.MutationStatus;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.SecureXmlParserFactory;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;

public class PitestParser
extends CoverageParser {
    private static final long serialVersionUID = 3449160972709724274L;
    private static final QName MUTATION = new QName("mutation");
    private static final QName SOURCE_FILE = new QName("sourceFile");
    private static final QName MUTATED_CLASS = new QName("mutatedClass");
    private static final QName KILLING_TEST = new QName("killingTest");
    private static final QName MUTATED_METHOD = new QName("mutatedMethod");
    private static final QName MUTATED_METHOD_SIGNATURE = new QName("methodDescription");
    private static final QName MUTATOR = new QName("mutator");
    private static final QName DESCRIPTION = new QName("description");
    private static final QName LINE_NUMBER = new QName("lineNumber");
    private static final QName DETECTED = new QName("detected");
    private static final QName STATUS = new QName("status");

    public PitestParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public PitestParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            SecureXmlParserFactory factory = new SecureXmlParserFactory();
            XMLEventReader eventReader = factory.createXmlEventReader(reader);
            ModuleNode root = new ModuleNode("-");
            boolean isEmpty = true;
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !MUTATION.equals(event.asStartElement().getName())) continue;
                this.readMutation(eventReader, root, event.asStartElement());
                isEmpty = false;
            }
            this.handleEmptyResults(fileName, log, isEmpty);
            root.getAllFileNodes().forEach(this::collectLineCoverage);
            return root;
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    private void collectLineCoverage(FileNode fileNode) {
        Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder(Metric.LINE);
        Coverage coveredLine = builder.withCovered(1).withMissed(0).build();
        Coverage uncoveredLine = builder.withCovered(0).withMissed(1).build();
        Map<Integer, Coverage> lineMapping = PitestParser.collectLines(fileNode, Mutation::isCovered).stream().collect(Collectors.toMap(k -> k, v -> coveredLine));
        int covered = lineMapping.size();
        PitestParser.collectLines(fileNode, Mutation::isMissed).forEach(line -> lineMapping.put((Integer)line, uncoveredLine));
        int missed = lineMapping.size() - covered;
        lineMapping.forEach((line, coverage) -> fileNode.addCounters((int)line, coverage.getCovered(), coverage.getMissed()));
        fileNode.addValue(builder.withCovered(covered).withMissed(missed).build());
    }

    private static Set<Integer> collectLines(FileNode fileNode, Predicate<Mutation> filterPredicate) {
        return fileNode.getMutations().stream().filter(filterPredicate).map(Mutation::getLine).collect(Collectors.toSet());
    }

    private void readMutation(XMLEventReader reader, ModuleNode root, StartElement mutationElement) throws XMLStreamException {
        Mutation.MutationBuilder builder = new Mutation.MutationBuilder();
        builder.withStatus(MutationStatus.valueOf(PitestParser.getValueOf(mutationElement, STATUS)));
        builder.withIsDetected(Boolean.parseBoolean(PitestParser.getValueOf(mutationElement, DETECTED)));
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                this.readProperty(reader, builder);
                continue;
            }
            if (!event.isEndElement()) continue;
            builder.buildAndAddToModule(root, this.getTreeStringBuilder());
            return;
        }
    }

    private void readProperty(XMLEventReader reader, Mutation.MutationBuilder builder) throws XMLStreamException {
        XMLEvent event;
        StringBuilder aggregatedContent = new StringBuilder();
        while (true) {
            if ((event = reader.nextEvent()).isCharacters()) {
                aggregatedContent.append(event.asCharacters().getData());
                continue;
            }
            if (event.isStartElement()) {
                this.readProperty(reader, builder);
                continue;
            }
            if (event.isEndElement()) break;
        }
        String content = StringUtils.defaultString((String)StringUtils.strip((String)aggregatedContent.toString()));
        QName name = event.asEndElement().getName();
        if (name.equals(MUTATOR)) {
            builder.withMutator(content);
        } else if (name.equals(KILLING_TEST)) {
            builder.withKillingTest(content);
        } else if (name.equals(DESCRIPTION)) {
            builder.withDescription(content);
        } else if (name.equals(SOURCE_FILE)) {
            builder.withSourceFile(content);
        } else if (name.equals(MUTATED_CLASS)) {
            builder.withMutatedClass(content);
        } else if (name.equals(MUTATED_METHOD)) {
            builder.withMutatedMethod(content);
        } else if (name.equals(MUTATED_METHOD_SIGNATURE)) {
            builder.withMutatedMethodSignature(content);
        } else if (name.equals(LINE_NUMBER)) {
            builder.withLine(content);
        }
    }
}

