/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.hm.hafner.util.TreeString;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CloverParser
extends CoverageParser {
    private static final long serialVersionUID = -1903059983931698657L;
    private static final QName COVERAGE = new QName("coverage");
    private static final QName PROJECT = new QName("project");
    private static final QName PACKAGE = new QName("package");
    private static final QName METRICS = new QName("metrics");
    private static final QName FILE = new QName("file");
    private static final QName CLASS = new QName("class");
    private static final QName NAME = new QName("name");
    private static final QName PATH = new QName("path");
    private static final QName STATEMENTS = new QName("statements");
    private static final QName COVERED_STATEMENTS = new QName("coveredstatements");
    private static final QName CONDITIONALS = new QName("conditionals");
    private static final QName COVERED_CONDITIONALS = new QName("coveredconditionals");
    private static final QName METHODS = new QName("methods");
    private static final QName COVERED_METHODS = new QName("coveredmethods");
    private static final QName LINE = new QName("line");
    private static final QName NUM = new QName("num");
    private static final QName COUNT = new QName("count");
    private static final QName TURE_COUNT = new QName("truecount");
    private static final QName FALSE_COUNT = new QName("falsecount");
    private static final QName TYPE = new QName("type");
    private static final String COND = "cond";
    private static final String STMT = "stmt";
    private static final PathUtil PATH_UTIL = new PathUtil();

    public CloverParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            SecureXmlParserFactory factory = new SecureXmlParserFactory();
            XMLEventReader eventReader = factory.createXmlEventReader(reader);
            while (eventReader.hasNext()) {
                StartElement startElement;
                QName tagName;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !COVERAGE.equals(tagName = (startElement = event.asStartElement()).getName())) continue;
                ModuleNode root = this.readCoverage(fileName, eventReader, log);
                if (root.hasChildren()) {
                    return root;
                }
                this.handleEmptyResults(fileName, log);
            }
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    @CanIgnoreReturnValue
    private ModuleNode readCoverage(String fileName, XMLEventReader reader, FilteredLog log) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement startElement;
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !PROJECT.equals((startElement = event.asStartElement()).getName())) continue;
            String projectName = CloverParser.getOptionalValueOf(startElement, NAME).orElse("-");
            ModuleNode root = new ModuleNode(projectName);
            this.readProject(fileName, reader, root);
            return root;
        }
        this.handleEmptyResults(fileName, log);
        return new ModuleNode("empty");
    }

    @CanIgnoreReturnValue
    private ModuleNode readProject(String fileName, XMLEventReader reader, ModuleNode root) throws XMLStreamException {
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                if (METRICS.equals(startElement.getName())) {
                    this.readCoverageMetrics(root, startElement);
                    continue;
                }
                if (PACKAGE.equals(startElement.getName())) {
                    this.readPackage(fileName, reader, root, startElement);
                    continue;
                }
                if (!FILE.equals(startElement.getName())) continue;
                this.readFile(fileName, reader, root.findOrCreatePackageNode(""), startElement);
                continue;
            }
            if (!event.isEndElement() || !PROJECT.equals((endElement = event.asEndElement()).getName())) continue;
            return root;
        }
        throw CloverParser.createEofException(fileName);
    }

    @CanIgnoreReturnValue
    private PackageNode readPackage(String fileName, XMLEventReader reader, ModuleNode root, StartElement packageElement) throws XMLStreamException {
        String packageName = CloverParser.getValueOf(packageElement, NAME);
        PackageNode packageNode = root.findOrCreatePackageNode(packageName);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                if (METRICS.equals(startElement.getName())) {
                    this.readCoverageMetrics(packageNode, startElement);
                    continue;
                }
                if (!FILE.equals(startElement.getName())) continue;
                this.readFile(fileName, reader, packageNode, startElement);
                continue;
            }
            if (!event.isEndElement() || !PACKAGE.equals((endElement = event.asEndElement()).getName())) continue;
            return packageNode;
        }
        throw CloverParser.createEofException(fileName);
    }

    @CanIgnoreReturnValue
    private FileNode readFile(String parserFileName, XMLEventReader reader, PackageNode packageNode, StartElement fileElement) throws XMLStreamException {
        String fileName = CloverParser.getValueOf(fileElement, NAME);
        FileNode fileNode = packageNode.findOrCreateFileNode(fileName, this.constructPathForFile(fileElement, packageNode.getName(), fileName));
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement e = event.asStartElement();
                if (CLASS.equals(e.getName())) {
                    this.readClass(parserFileName, reader, e, fileNode);
                    continue;
                }
                if (METRICS.equals(e.getName())) {
                    this.readCoverageMetrics(fileNode, e);
                    continue;
                }
                if (!LINE.equals(e.getName())) continue;
                this.addLineCoverage(e, fileNode);
                continue;
            }
            if (!event.isEndElement() || !FILE.equals((endElement = event.asEndElement()).getName())) continue;
            this.resolveLines(fileNode);
            return fileNode;
        }
        throw CloverParser.createEofException(parserFileName);
    }

    private void addLineCoverage(StartElement e, FileNode fileNode) {
        String type = CloverParser.getValueOf(e, TYPE);
        int line = CloverParser.getIntegerValueOf(e, NUM);
        if (STMT.equals(type)) {
            int count = CloverParser.getIntegerValueOf(e, COUNT);
            this.addCountersToFile(count, fileNode, line);
        } else if (COND.equals(type)) {
            Optional<String> countVal = CloverParser.getOptionalValueOf(e, COUNT);
            if (countVal.isPresent()) {
                int count = CloverParser.parseInteger(countVal.get());
                this.addCountersToFile(count, fileNode, line);
            } else {
                this.addCountersUsingConditional(fileNode, line, e);
            }
        }
    }

    private void addCountersToFile(int count, FileNode fileNode, int line) {
        if (count > 0) {
            fileNode.addCounters(line, 1, 0);
        } else {
            fileNode.addCounters(line, 0, 1);
        }
    }

    private void addCountersUsingConditional(FileNode fileNode, int line, StartElement e) {
        int trueCount = CloverParser.getIntegerValueOf(e, TURE_COUNT);
        int falseCount = CloverParser.getIntegerValueOf(e, FALSE_COUNT);
        if (trueCount > 0 || falseCount > 0) {
            fileNode.addCounters(line, 1, 0);
        } else {
            fileNode.addCounters(line, 0, 1);
        }
    }

    private TreeString constructPathForFile(StartElement fileElement, String packageName, String fileName) {
        return CloverParser.getOptionalValueOf(fileElement, PATH).map(TreeString::valueOf).orElseGet(() -> this.getTreeStringBuilder().intern(this.getPath(packageName, fileName)));
    }

    private String getPath(String packageName, String fileName) {
        if (PATH_UTIL.isAbsolute(fileName)) {
            return fileName;
        }
        Path relativePath = Path.of(packageName.replace(".", "/"), fileName);
        return PATH_UTIL.getRelativePath(relativePath);
    }

    private void readClass(String parserFileName, XMLEventReader reader, StartElement fileElement, Node fileNode) throws XMLStreamException {
        String className = CloverParser.getValueOf(fileElement, NAME);
        ClassNode classNode = fileNode.findOrCreateClassNode(className);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement e = event.asStartElement();
                if (!METRICS.equals(e.getName())) continue;
                this.readCoverageMetrics(classNode, e);
                continue;
            }
            if (!event.isEndElement() || !CLASS.equals((endElement = event.asEndElement()).getName())) continue;
            return;
        }
        throw CloverParser.createEofException(parserFileName);
    }

    private void resolveLines(FileNode fileNode) {
        Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder();
        Coverage lineCoverage = builder.withMetric(Metric.LINE).withCovered(fileNode.getCoveredLines().size()).withMissed(fileNode.getMissedLines().size()).build();
        fileNode.addValue(lineCoverage);
        for (ClassNode c : fileNode.getAllClassNodes()) {
            c.addValue(lineCoverage);
        }
    }

    private void readCoverageMetrics(Node node, StartElement e) {
        this.addCoverage(node, Metric.BRANCH, CONDITIONALS, COVERED_CONDITIONALS, e);
        this.addCoverage(node, Metric.INSTRUCTION, STATEMENTS, COVERED_STATEMENTS, e);
        this.addCoverage(node, Metric.METHOD, METHODS, COVERED_METHODS, e);
    }

    private void addCoverage(Node node, Metric metric, QName coveredElement, QName totalElement, StartElement e) {
        int condTotal = CloverParser.getIntegerValueOf(e, coveredElement);
        int condCovered = CloverParser.getIntegerValueOf(e, totalElement);
        Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder();
        node.addValue(builder.withMetric(metric).withCovered(condCovered).withMissed(condTotal - condCovered).build());
    }
}

