/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.Difference;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.SafeFraction;
import edu.hm.hafner.util.Generated;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.Fraction;

public class Value
implements Serializable,
Comparable<Value> {
    private static final long serialVersionUID = -1062406664372222691L;
    private static final String METRIC_SEPARATOR = ":";
    private final Metric metric;
    private final Fraction fraction;

    public static Value getValue(Metric metric, Collection<? extends Value> values) {
        return Value.findValue(metric, values).orElseThrow(() -> new NoSuchElementException("No value for metric " + String.valueOf((Object)metric) + " in " + String.valueOf(values)));
    }

    public static Optional<Value> findValue(Metric metric, Collection<? extends Value> values) {
        return values.stream().filter(v -> metric == v.getMetric()).findAny().map(Value.class::cast);
    }

    public static Value valueOf(String stringRepresentation) {
        String errorMessage = "Cannot convert '%s' to a valid Value instance.".formatted(stringRepresentation);
        try {
            String cleanedFormat = StringUtils.deleteWhitespace((String)stringRepresentation);
            if (Strings.CS.contains((CharSequence)cleanedFormat, (CharSequence)METRIC_SEPARATOR)) {
                Metric metric = Metric.fromName(StringUtils.substringBefore((String)cleanedFormat, (String)METRIC_SEPARATOR));
                String value = StringUtils.substringAfter((String)cleanedFormat, (String)METRIC_SEPARATOR);
                if (value.contains("/")) {
                    return Coverage.valueOf(metric, value);
                }
                if (value.startsWith("\u0394")) {
                    return new Difference(metric, Value.readFraction(value, 1));
                }
                return new Value(metric, Value.readFraction(value, 0));
            }
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException(errorMessage, exception);
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private static Fraction readFraction(String value, int beginIndex) {
        return Fraction.getFraction((String)value.substring(beginIndex).replace(':', '/'));
    }

    public static Value nullObject(Metric metric) {
        return new Value(metric, 0);
    }

    public Value(Metric metric, Fraction value) {
        this.metric = metric;
        this.fraction = value;
    }

    public Value(Metric metric, double value) {
        this(metric, Fraction.getFraction((double)value));
    }

    public Value(Metric metric, int numerator, int denominator) {
        this(metric, Fraction.getFraction((int)numerator, (int)denominator));
    }

    public Value(Metric metric, int value) {
        this(metric, Fraction.getFraction((int)value, (int)1));
    }

    public final Metric getMetric() {
        return this.metric;
    }

    public Fraction getFraction() {
        return this.fraction;
    }

    protected void ensureSameMetricAndType(Value other) {
        if (!this.hasSameMetric(other)) {
            throw new IllegalArgumentException("Cannot calculate with different metrics: %s and %s".formatted(this, other));
        }
        if (!other.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Cannot calculate with different types: %s and %s".formatted(this, other));
        }
    }

    @CheckReturnValue
    public Value add(Value other) {
        this.ensureSameMetricAndType(other);
        return new Value(this.getMetric(), this.asSafeFraction().add(other.fraction));
    }

    @CheckReturnValue
    public Difference subtract(Value other) {
        this.ensureSameMetricAndType(other);
        return new Difference(this.getMetric(), this.asSafeFraction().subtract(other.fraction));
    }

    @CheckReturnValue
    public Value max(Value other) {
        this.ensureSameMetricAndType(other);
        if (this.fraction.doubleValue() < other.fraction.doubleValue()) {
            return other;
        }
        return this;
    }

    public boolean isOutOfValidRange(double threshold) {
        if (this.getMetric().getTendency() == Metric.MetricTendency.LARGER_IS_BETTER) {
            return this.fraction.doubleValue() < threshold;
        }
        return this.fraction.doubleValue() > threshold;
    }

    private SafeFraction asSafeFraction() {
        return new SafeFraction(this.fraction);
    }

    public final String serialize() {
        return String.format(Locale.ENGLISH, "%s: %s", new Object[]{this.getMetric(), this.serializeValue()});
    }

    protected String serializeValue() {
        if (this.fraction.getDenominator() == 1) {
            return String.valueOf(this.fraction.getNumerator());
        }
        return String.format(Locale.ENGLISH, "%d:%d", this.fraction.getNumerator(), this.fraction.getDenominator());
    }

    public String asText(Locale locale) {
        return this.getMetric().format(locale, this.asDouble());
    }

    public String asInformativeText(Locale locale) {
        return this.getMetric().format(locale, this.asDouble());
    }

    public String getSummary(Locale locale) {
        return String.format(locale, "%s: %s", this.getMetric().getDisplayName(), this.asText(locale));
    }

    public String getDetails(Locale locale) {
        return String.format(locale, "%s: %s", this.getMetric().getDisplayName(), this.asInformativeText(locale));
    }

    public int asInteger() {
        return (int)this.round(this.fraction.doubleValue(), 0);
    }

    public double asDouble() {
        return this.fraction.doubleValue();
    }

    public double asRounded() {
        return this.round(this.fraction.doubleValue(), 2);
    }

    private double round(double value, int scale) {
        return BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    protected boolean hasSameMetric(Value other) {
        return other.getMetric() == this.getMetric();
    }

    public String toString() {
        return this.serialize();
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Value value = (Value)o;
        return this.metric == value.metric && Objects.equals(this.fraction, value.fraction);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(new Object[]{this.metric, this.fraction});
    }

    @Override
    public int compareTo(Value o) {
        int metricComparison = this.getMetric().compareTo(o.getMetric());
        if (metricComparison != 0) {
            return metricComparison;
        }
        return this.getFraction().compareTo(o.getFraction());
    }
}

