/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import java.util.Locale;
import org.apache.commons.lang3.math.Fraction;

public class Rate
extends Value {
    private static final long serialVersionUID = 7814954290956727708L;
    public static final String PERCENTAGE = "%";

    public static Rate nullObject(Metric metric) {
        return new Rate(metric, 0);
    }

    public static Rate valueOf(String stringRepresentation) {
        Value value = Value.valueOf(stringRepresentation);
        if (value instanceof Rate) {
            Rate delta = (Rate)value;
            return delta;
        }
        throw new IllegalArgumentException("Cannot convert '%s' to a valid Rate instance.".formatted(stringRepresentation));
    }

    public Rate(Metric metric, Fraction value) {
        super(metric, value);
    }

    public Rate(Metric metric, double value) {
        super(metric, value);
    }

    public Rate(Metric metric, int numerator, int denominator) {
        super(metric, numerator, denominator);
    }

    public Rate(Metric metric, long numerator, long denominator) {
        super(metric, numerator, denominator);
    }

    public Rate(Metric metric, int value) {
        super(metric, value);
    }

    @Override
    public double asDouble() {
        return this.rawValue() * 100.0;
    }

    @Override
    public String asText(Locale locale) {
        return this.getMetric().format(locale, this.rawValue());
    }

    @Override
    public String asInformativeText(Locale locale) {
        return this.getMetric().format(locale, this.rawValue());
    }

    private double rawValue() {
        return super.asDouble();
    }

    @Override
    protected String serializeValue() {
        return PERCENTAGE + super.serializeValue();
    }
}

