/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.TreeStringBuilder;
import java.io.Reader;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class CoverageParser
implements Serializable {
    private static final long serialVersionUID = 3941742254762282096L;
    protected static final String VALUE_COMPLEXITY = "COMPLEXITY";
    protected static final String EMPTY = "-";
    private transient TreeStringBuilder treeStringBuilder = new TreeStringBuilder();
    private final ProcessingMode processingMode;

    protected CoverageParser(ProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    protected boolean ignoreErrors() {
        return this.processingMode == ProcessingMode.IGNORE_ERRORS;
    }

    public ModuleNode parse(Reader reader, String fileName, FilteredLog log) {
        ModuleNode moduleNode = this.parseReport(reader, fileName, log);
        this.getTreeStringBuilder().dedup();
        return moduleNode;
    }

    protected QName getElementName(XMLEvent event) {
        if (event.isStartElement()) {
            return event.asStartElement().getName();
        }
        return event.asEndElement().getName();
    }

    protected void handleEmptyResults(String fileName, FilteredLog log, boolean isEmpty) {
        if (isEmpty) {
            String emptyMessage = "[%s] The processed file '%s' does not contain data.".formatted(this.getClass().getSimpleName(), fileName);
            if (this.ignoreErrors()) {
                log.logError(emptyMessage);
            } else {
                throw new NoSuchElementException(emptyMessage);
            }
        }
    }

    protected void handleEmptyResults(String fileName, FilteredLog log) {
        this.handleEmptyResults(fileName, log, true);
    }

    protected Object readResolve() {
        this.treeStringBuilder = new TreeStringBuilder();
        return this;
    }

    protected final TreeStringBuilder getTreeStringBuilder() {
        return this.treeStringBuilder;
    }

    protected abstract ModuleNode parseReport(Reader var1, String var2, FilteredLog var3);

    protected static Optional<String> getOptionalValueOf(StartElement element, QName attribute) {
        Attribute value = element.getAttributeByName(attribute);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value.getValue());
    }

    protected static int getIntegerValueOf(StartElement element, QName attributeName) {
        try {
            return CoverageParser.parseInteger(CoverageParser.getValueOf(element, attributeName));
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    protected static String getValueOf(StartElement element, QName attribute) {
        return CoverageParser.getOptionalValueOf(element, attribute).orElseThrow(() -> new NoSuchElementException("Could not obtain attribute '%s' from element '%s'".formatted(attribute, element)));
    }

    protected static int parseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    protected static ParsingException createEofException(String fileName) {
        return new ParsingException("Unexpected end of file '%s'", fileName);
    }

    public static enum ProcessingMode {
        IGNORE_ERRORS,
        FAIL_FAST;

    }

    public static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = -9016364685084958944L;

        public ParsingException(Throwable cause) {
            super(ParsingException.createMessage(cause, "Exception occurred during parsing"), cause);
        }

        @FormatMethod
        public ParsingException(Throwable cause, String messageFormat, Object ... args) {
            super(ParsingException.createMessage(cause, messageFormat.formatted(args)), cause);
        }

        @FormatMethod
        public ParsingException(String messageFormat, Object ... args) {
            super(messageFormat.formatted(args));
        }

        private static String createMessage(Throwable cause, String message) {
            return "%s%n%s%n%s".formatted(message, ExceptionUtils.getMessage((Throwable)cause), ExceptionUtils.getStackTrace((Throwable)cause));
        }
    }
}

