/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.LookaheadStream;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.MutablePair;

public class LcovParser
extends CoverageParser {
    private static final long serialVersionUID = 1L;
    private static final PathUtil PATH_UTIL = new PathUtil();

    public LcovParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public LcovParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        ModuleNode root = new ModuleNode("-");
        LinkedHashMap<String, Map<Integer, MutablePair<Integer, Integer>>> files = new LinkedHashMap<String, Map<Integer, MutablePair<Integer, Integer>>>();
        String currentFile = "-";
        try (BufferedReader br = new BufferedReader(reader);
             Stream<String> lines = br.lines();
             LookaheadStream stream = new LookaheadStream(lines, fileName);){
            while (stream.hasNext()) {
                MutablePair pair;
                int ln;
                String[] parts;
                String raw = stream.next();
                String line = raw.trim();
                if (line.isEmpty()) continue;
                if (line.startsWith("SF:")) {
                    currentFile = line.substring(3);
                    files.putIfAbsent(currentFile, new TreeMap());
                    continue;
                }
                if (line.startsWith("DA:")) {
                    parts = line.substring(3).split(",", 3);
                    ln = Integer.parseInt(parts[0]);
                    int exec = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                    pair = ((Map)files.getOrDefault(currentFile, new TreeMap())).getOrDefault(ln, MutablePair.of((Object)0, (Object)0));
                    pair.setLeft((Object)(exec > 0 ? 1 : 0));
                    ((Map)files.get(currentFile)).put(ln, pair);
                    continue;
                }
                if (!line.startsWith("BRDA:")) continue;
                parts = line.substring(5).split(",", 4);
                ln = Integer.parseInt(parts[0]);
                String taken = parts.length > 3 ? parts[3] : "-";
                pair = ((Map)files.getOrDefault(currentFile, new TreeMap())).getOrDefault(ln, MutablePair.of((Object)0, (Object)0));
                if (!"-".equals(taken) && !"0".equals(taken)) {
                    pair.setRight((Object)((Integer)pair.getRight() + 1));
                }
                ((Map)files.get(currentFile)).put(ln, pair);
            }
        }
        catch (IOException | NumberFormatException e) {
            throw new CoverageParser.ParsingException(e);
        }
        if (files.isEmpty()) {
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        this.createCoverages(root, files);
        return root;
    }

    private void createCoverages(ModuleNode root, Map<String, Map<Integer, MutablePair<Integer, Integer>>> files) {
        PackageNode packageNode = new PackageNode("-");
        ModuleNode moduleNode = new ModuleNode("-");
        moduleNode.addChild(packageNode);
        root.addChild(moduleNode);
        TreeStringBuilder builder = this.getTreeStringBuilder();
        Coverage.CoverageBuilder lineBuilder = new Coverage.CoverageBuilder().withMetric(Metric.LINE);
        Coverage.CoverageBuilder instructionBuilder = new Coverage.CoverageBuilder().withMetric(Metric.INSTRUCTION);
        for (Map.Entry<String, Map<Integer, MutablePair<Integer, Integer>>> entry : files.entrySet()) {
            String path = entry.getKey();
            String normalized = LcovParser.normalizePath(path);
            String filename = LcovParser.baseName(normalized);
            TreeString id = builder.intern(PATH_UTIL.getRelativePath(Path.of(normalized, new String[0])));
            FileNode fileNode = packageNode.findOrCreateFileNode(filename, id);
            int totalLines = entry.getValue().size();
            int coveredInstructions = 0;
            int coveredLines = 0;
            for (Map.Entry<Integer, MutablePair<Integer, Integer>> lineEntry : entry.getValue().entrySet()) {
                int instrCovered = (Integer)lineEntry.getValue().getLeft();
                int branchesCovered = (Integer)lineEntry.getValue().getRight();
                if (instrCovered > 0) {
                    coveredInstructions += instrCovered;
                }
                if (instrCovered <= 0 && branchesCovered <= 0) continue;
                ++coveredLines;
            }
            int missedInstructions = Math.max(0, totalLines - coveredInstructions);
            int missedLines = Math.max(0, totalLines - coveredLines);
            fileNode.addValue(instructionBuilder.withCovered(coveredInstructions).withMissed(missedInstructions).build());
            fileNode.addValue(lineBuilder.withCovered(coveredLines).withMissed(missedLines).build());
            fileNode.addValue(new Value(Metric.LOC, totalLines));
            for (Map.Entry<Integer, MutablePair<Integer, Integer>> lineEntry : entry.getValue().entrySet()) {
                int lineNumber = lineEntry.getKey();
                int instrCovered = (Integer)lineEntry.getValue().getLeft();
                int branchesCovered = (Integer)lineEntry.getValue().getRight();
                this.addCounters(fileNode, lineNumber, instrCovered, branchesCovered);
            }
        }
    }

    private void addCounters(FileNode fileNode, int lineNumber, int coveredInstructions, int coveredBranches) {
        int missed;
        int covered;
        if (coveredBranches == 0) {
            covered = coveredInstructions > 0 ? 1 : 0;
            missed = covered > 0 ? 0 : 1;
        } else {
            covered = coveredBranches;
            missed = coveredBranches - coveredInstructions;
        }
        fileNode.addCounters(lineNumber, covered, missed);
    }

    private static String normalizePath(String path) {
        return path.trim().replace('\\', '/');
    }

    private static String baseName(String normalizedPath) {
        if (normalizedPath.isEmpty()) {
            return "";
        }
        int idx = normalizedPath.lastIndexOf(47);
        return idx >= 0 ? normalizedPath.substring(idx + 1) : normalizedPath;
    }
}

