/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;

public final class MethodNode
extends Node {
    private static final long serialVersionUID = -5765205034179396434L;
    private final String signature;
    private String methodName;
    private final int lineNumber;

    public MethodNode(String name, String signature) {
        this(name, signature, 0);
    }

    public MethodNode(String name, String signature, int lineNumber) {
        super(Metric.METHOD, name + signature);
        this.signature = signature;
        this.methodName = name;
        this.lineNumber = lineNumber;
    }

    @SuppressFBWarnings(value={"RCN"}, justification="Value might be null in old serializations")
    private Object readResolve() {
        if (this.methodName == null) {
            this.methodName = this.getName();
            this.setName(this.methodName + this.signature);
        }
        return this;
    }

    @Override
    public Node copy() {
        return new MethodNode(this.getMethodName(), this.getSignature(), this.getLineNumber());
    }

    public boolean hasValidLineNumber() {
        return this.lineNumber > 0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodNode that = (MethodNode)o;
        return this.lineNumber == that.lineNumber && Objects.equals(this.signature, that.signature) && Objects.equals(this.methodName, that.methodName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.signature, this.methodName, this.lineNumber);
    }

    @Override
    public String toString() {
        return "[%s] %s <%s>".formatted(new Object[]{this.getMetric(), this.getName(), this.getLineNumber()});
    }
}

