/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.registry;

import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.parser.CloverParser;
import edu.hm.hafner.coverage.parser.CoberturaParser;
import edu.hm.hafner.coverage.parser.GoCovParser;
import edu.hm.hafner.coverage.parser.JacocoParser;
import edu.hm.hafner.coverage.parser.JunitParser;
import edu.hm.hafner.coverage.parser.MetricsParser;
import edu.hm.hafner.coverage.parser.NunitParser;
import edu.hm.hafner.coverage.parser.OpenCoverParser;
import edu.hm.hafner.coverage.parser.PitestParser;
import edu.hm.hafner.coverage.parser.VectorCastParser;
import edu.hm.hafner.coverage.parser.XunitParser;
import org.apache.commons.lang3.StringUtils;

public class ParserRegistry {
    public CoverageParser get(String parserName, CoverageParser.ProcessingMode processingMode) {
        try {
            return this.get(CoverageParserType.valueOf(StringUtils.upperCase((String)parserName)), processingMode);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Unknown parser name: " + parserName, exception);
        }
    }

    public CoverageParser get(CoverageParserType parser, CoverageParser.ProcessingMode processingMode) {
        return switch (parser) {
            default -> throw new IncompatibleClassChangeError();
            case CoverageParserType.CLOVER -> new CloverParser(processingMode);
            case CoverageParserType.COBERTURA -> new CoberturaParser(processingMode);
            case CoverageParserType.GO_COV -> new GoCovParser(processingMode);
            case CoverageParserType.JACOCO -> new JacocoParser(processingMode);
            case CoverageParserType.JUNIT -> new JunitParser(processingMode);
            case CoverageParserType.METRICS -> new MetricsParser(processingMode);
            case CoverageParserType.NUNIT -> new NunitParser(processingMode);
            case CoverageParserType.OPENCOVER -> new OpenCoverParser(processingMode);
            case CoverageParserType.PIT -> new PitestParser(processingMode);
            case CoverageParserType.XUNIT -> new XunitParser(processingMode);
            case CoverageParserType.VECTORCAST -> new VectorCastParser(processingMode);
        };
    }

    public static enum CoverageParserType {
        COBERTURA,
        CLOVER,
        GO_COV,
        JACOCO,
        JUNIT,
        METRICS,
        NUNIT,
        OPENCOVER,
        PIT,
        VECTORCAST,
        XUNIT;

    }
}

