/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.util.Generated;
import java.io.Serializable;
import java.util.Objects;

public final class TestCase
implements Serializable {
    private static final long serialVersionUID = -2181204291759959155L;
    private final String testName;
    private final String className;
    private final TestResult result;
    private final String type;
    private final String message;
    private final String description;

    private TestCase(String testName, String className, TestResult result, String type, String message, String description) {
        this.testName = testName;
        this.className = className.intern();
        this.result = result;
        this.type = type;
        this.message = message;
        this.description = description;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getClassName() {
        return this.className;
    }

    public TestResult getResult() {
        return this.result;
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "TestCase{testName='" + this.testName + "', className='" + this.className + "', status=" + String.valueOf((Object)this.result) + ", type='" + this.type + "', message='" + this.message + "', description='" + this.description + "'}";
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCase testCase = (TestCase)o;
        return Objects.equals(this.testName, testCase.testName) && Objects.equals(this.className, testCase.className) && this.result == testCase.result && Objects.equals(this.type, testCase.type) && Objects.equals(this.message, testCase.message) && Objects.equals(this.description, testCase.description);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(new Object[]{this.testName, this.className, this.result, this.type, this.message, this.description});
    }

    public static enum TestResult {
        PASSED,
        FAILED,
        SKIPPED,
        ABORTED;

    }

    public static class TestCaseBuilder {
        private TestResult status = TestResult.PASSED;
        private String testName = "";
        private String className = "";
        private String type = "";
        private String message = "";
        private String description = "";

        @CanIgnoreReturnValue
        public TestCaseBuilder withStatus(TestResult status) {
            this.status = status;
            return this;
        }

        @CanIgnoreReturnValue
        public TestCaseBuilder withTestName(String testName) {
            this.testName = testName;
            return this;
        }

        @CanIgnoreReturnValue
        public TestCaseBuilder withClassName(String className) {
            this.className = className;
            return this;
        }

        @CanIgnoreReturnValue
        public TestCaseBuilder withType(String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public TestCaseBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        @CanIgnoreReturnValue
        public TestCaseBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public TestCaseBuilder withFailure() {
            this.status = TestResult.FAILED;
            return this;
        }

        public TestCase build() {
            return new TestCase(this.testName, this.className, this.status, this.type, this.message, this.description);
        }
    }
}

