/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.TestCase;
import edu.hm.hafner.coverage.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ClassNode
extends Node {
    private static final long serialVersionUID = 1621410859864978552L;
    private List<TestCase> testCases = new ArrayList<TestCase>();

    public ClassNode(String name) {
        super(Metric.CLASS, PackageNode.normalizePackageName(name));
    }

    public String getPackageName() {
        if (this.getName().contains(".")) {
            return StringUtils.substringBeforeLast((String)this.getName(), (String)".");
        }
        if (this.hasParent() && this.getParent().getMetric() == Metric.PACKAGE) {
            return this.getParentName();
        }
        return "-";
    }

    @Override
    public ClassNode copy() {
        ClassNode copy = new ClassNode(this.getName());
        copy.testCases.addAll(this.testCases);
        return copy;
    }

    @SuppressFBWarnings(value={"RCN"}, justification="Value might be null in old serializations")
    private Object readResolve() {
        if (this.testCases == null) {
            this.testCases = new ArrayList<TestCase>();
        }
        return this;
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    public void addTestCase(TestCase testCase) {
        this.addTestCases(List.of(testCase));
    }

    public void addTestCases(Collection<TestCase> additionalTestCases) {
        this.testCases.addAll(additionalTestCases);
        this.updateTestCount();
    }

    private void updateTestCount() {
        this.replaceValue(new Value(Metric.TESTS, this.testCases.size()));
    }

    @Override
    public List<TestCase> getTestCases() {
        return new ArrayList<TestCase>(this.testCases);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassNode classNode = (ClassNode)o;
        return this.testCases.equals(classNode.testCases);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + this.testCases.hashCode();
    }
}

