/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.commons.lang3.StringUtils;

public final class PackageNode
extends Node {
    private static final long serialVersionUID = 8236436628673022634L;

    public static String normalizePackageName(@CheckForNull String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return StringUtils.replaceEach((String)name, (String[])new String[]{"/", "\\"}, (String[])new String[]{".", "."});
        }
        return "-";
    }

    public PackageNode(@CheckForNull String name) {
        super(Metric.PACKAGE, PackageNode.normalizePackageName(name));
    }

    static PackageNode appendPackage(PackageNode localChild, PackageNode localParent) {
        localParent.addChild(localChild);
        return localParent;
    }

    @Override
    public PackageNode copy() {
        return new PackageNode(this.getName());
    }

    @Override
    public boolean isAggregation() {
        return true;
    }
}

