/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.MutationStatus;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.util.TreeStringBuilder;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class Mutation
implements Serializable {
    private static final long serialVersionUID = -7725185756332899065L;
    private final boolean detected;
    private final MutationStatus status;
    private final int line;
    private final String mutator;
    private final String killingTest;
    private final String mutatedClass;
    private final String method;
    private final String signature;
    private final String description;

    private Mutation(boolean detected, MutationStatus status, int line, String mutator, String killingTest, String mutatedClass, String method, String signature, String description) {
        this.detected = detected;
        this.status = status;
        this.line = line;
        this.mutator = mutator.intern();
        this.killingTest = killingTest.intern();
        this.mutatedClass = mutatedClass.intern();
        this.method = method.intern();
        this.signature = signature.intern();
        this.description = description.intern();
    }

    public String getMutatedClass() {
        return this.mutatedClass;
    }

    public String getMethod() {
        return this.method;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public MutationStatus getStatus() {
        return this.status;
    }

    public boolean isValid() {
        return this.isCovered() || this.isMissed();
    }

    public boolean isCovered() {
        return this.status.isCovered();
    }

    public boolean isMissed() {
        return this.status.isMissed();
    }

    public int getLine() {
        return this.line;
    }

    public String getMutator() {
        return this.mutator;
    }

    public String getKillingTest() {
        return this.killingTest;
    }

    public boolean isKilled() {
        return this.status.equals((Object)MutationStatus.KILLED);
    }

    public boolean hasSurvived() {
        return this.status.equals((Object)MutationStatus.SURVIVED);
    }

    public String toString() {
        return "[Mutation]: isDetected=" + this.detected + ", status=" + String.valueOf((Object)this.status) + ", lineNumber=" + this.line + ", mutator=" + this.mutator + ", killingTest='" + this.killingTest + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mutation mutation = (Mutation)o;
        return this.detected == mutation.detected && this.line == mutation.line && this.status == mutation.status && Objects.equals(this.mutator, mutation.mutator) && Objects.equals(this.killingTest, mutation.killingTest) && Objects.equals(this.mutatedClass, mutation.mutatedClass) && Objects.equals(this.method, mutation.method) && Objects.equals(this.signature, mutation.signature) && Objects.equals(this.description, mutation.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detected, this.status, this.line, this.mutator, this.killingTest, this.mutatedClass, this.method, this.signature, this.description});
    }

    public static class MutationBuilder {
        private boolean isDetected;
        private MutationStatus status = MutationStatus.NO_COVERAGE;
        private int line;
        private String mutator = "";
        private String killingTest = "";
        private String description = "";
        private String sourceFile = "";
        private String mutatedClass = "";
        private String mutatedMethod = "";
        private String mutatedMethodSignature = "";

        @CanIgnoreReturnValue
        public MutationBuilder withIsDetected(boolean isDetected) {
            this.isDetected = isDetected;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withStatus(MutationStatus status) {
            this.status = status;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withLine(String line) {
            this.line = CoverageParser.parseInteger(line);
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withLine(int line) {
            this.line = line;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withMutator(String mutator) {
            this.mutator = mutator;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withKillingTest(String killingTest) {
            this.killingTest = killingTest;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withSourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withMutatedClass(String mutatedClass) {
            this.mutatedClass = mutatedClass;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withMutatedMethod(String mutatedMethod) {
            this.mutatedMethod = mutatedMethod;
            return this;
        }

        @CanIgnoreReturnValue
        public MutationBuilder withMutatedMethodSignature(String mutatedMethodSignature) {
            this.mutatedMethodSignature = mutatedMethodSignature;
            return this;
        }

        public void buildAndAddToModule(ModuleNode root, TreeStringBuilder treeStringBuilder) {
            String packageName = StringUtils.substringBeforeLast((String)this.mutatedClass, (String)".");
            PackageNode packageNode = root.findOrCreatePackageNode(packageName);
            String relativePath = packageName.replace('.', '/') + "/" + this.sourceFile;
            FileNode fileNode = packageNode.findOrCreateFileNode(this.sourceFile, treeStringBuilder.intern(relativePath));
            String className = StringUtils.substringAfterLast((String)this.mutatedClass, (String)".");
            ClassNode classNode = fileNode.findOrCreateClassNode(className);
            MethodNode methodNode = classNode.findMethod(this.mutatedMethod, this.mutatedMethodSignature).orElseGet(() -> classNode.createMethodNode(this.mutatedMethod, this.mutatedMethodSignature));
            this.updateMetricForMethod(Metric.MUTATION, methodNode);
            if (this.status != MutationStatus.NO_COVERAGE) {
                this.updateMetricForMethod(Metric.TEST_STRENGTH, methodNode);
            }
            fileNode.addMutation(this.build());
        }

        private void updateMetricForMethod(Metric metric, MethodNode methodNode) {
            Coverage existingCoverage = methodNode.getValue(metric).map(Coverage.class::cast).orElse(Coverage.nullObject(metric));
            Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder(existingCoverage);
            if (this.isDetected) {
                builder.incrementCovered();
            } else {
                builder.incrementMissed();
            }
            methodNode.replaceValue(builder.build());
        }

        public Mutation build() {
            return new Mutation(this.isDetected, this.status, this.line, this.mutator, this.killingTest, this.mutatedClass, this.mutatedMethod, this.mutatedMethodSignature, this.description);
        }
    }
}

