/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.Fraction;

public enum Metric {
    CONTAINER("Container Coverage", "Container", new CoverageOfChildrenEvaluator()),
    MODULE("Module Coverage", "Module", new CoverageOfChildrenEvaluator()),
    PACKAGE("Package Coverage", "Package", new CoverageOfChildrenEvaluator()),
    FILE("File Coverage", "File", new CoverageOfChildrenEvaluator()),
    CLASS("Class Coverage", "Class", new CoverageOfChildrenEvaluator()),
    METHOD("Method Coverage", "Method", new CoverageOfChildrenEvaluator()),
    LINE("Line Coverage", "Line", new ValuesAggregator()),
    BRANCH("Branch Coverage", "Branch", new ValuesAggregator()),
    INSTRUCTION("Instruction Coverage", "Instruction", new ValuesAggregator()),
    MCDC_PAIR("Modified Condition and Decision Coverage", "MC/DC Pair", new ValuesAggregator()),
    FUNCTION_CALL("Function Call Coverage", "Function Call", new ValuesAggregator()),
    MUTATION("Mutation Coverage", "Mutation", new ValuesAggregator()),
    TEST_STRENGTH("Test Strength", "Test Strength", new ValuesAggregator()),
    TESTS("Number of Tests", "Tests", new ValuesAggregator(), MetricTendency.LARGER_IS_BETTER, MetricValueType.CLASS_METRIC, new IntegerFormatter()),
    LOC("Lines of Code", "LOC", new LocEvaluator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METRIC, new IntegerFormatter()),
    NCSS("Non Commenting Source Statements", "NCSS", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METRIC, new IntegerFormatter()),
    CYCLOMATIC_COMPLEXITY("Cyclomatic Complexity", "Complexity", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METHOD_METRIC, new IntegerFormatter()),
    COGNITIVE_COMPLEXITY("Cognitive Complexity", "Cognitive Complexity", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METHOD_METRIC, new IntegerFormatter()),
    NPATH_COMPLEXITY("N-Path Complexity", "N-Path", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METHOD_METRIC, new IntegerFormatter()),
    ACCESS_TO_FOREIGN_DATA("Access to Foreign Data", "Foreign Data", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METRIC, new IntegerFormatter()),
    COHESION("Class Cohesion", "Cohesion", new ValuesAggregator(Value::max, "maximum"), MetricTendency.LARGER_IS_BETTER, MetricValueType.CLASS_METRIC, new PercentageFormatter()),
    FAN_OUT("Fan Out", "Fan Out", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.METRIC, new IntegerFormatter()),
    NUMBER_OF_ACCESSORS("Number of Accessors", "Accessors", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.CLASS_METRIC, new IntegerFormatter()),
    WEIGHT_OF_CLASS("Weight of Class", "Weigth", new ValuesAggregator(Value::max, "maximum"), MetricTendency.LARGER_IS_BETTER, MetricValueType.CLASS_METRIC, new PercentageFormatter()),
    WEIGHED_METHOD_COUNT("Weighted Method Count", "Methods", new ValuesAggregator(), MetricTendency.SMALLER_IS_BETTER, MetricValueType.CLASS_METRIC, new IntegerFormatter());

    private final String displayName;
    private final String label;
    private final MetricEvaluator evaluator;
    private final MetricTendency tendency;
    private final MetricValueType type;
    private final MetricFormatter formatter;

    public static Metric fromTag(String tag) {
        return Metric.valueOf(tag.toUpperCase(Locale.ENGLISH).replaceAll("-", "_"));
    }

    public static Metric fromName(String name) {
        String normalizedName = Metric.normalize(name);
        String normalizedFallback = Metric.normalize("CYCLOMATIC_" + name);
        for (Metric metric : Metric.values()) {
            if (!normalizedName.equals(Metric.normalize(metric.name())) && !normalizedFallback.equals(Metric.normalize(metric.name()))) continue;
            return metric;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("No metric defined");
        }
        throw new IllegalArgumentException("No metric found for name '" + name + "'");
    }

    private static String normalize(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("[-_]", "");
    }

    private Metric(String displayName, String label, MetricEvaluator evaluator) {
        this(displayName, label, evaluator, MetricTendency.LARGER_IS_BETTER);
    }

    private Metric(String displayName, String label, MetricEvaluator evaluator, MetricTendency tendency) {
        this(displayName, label, evaluator, tendency, MetricValueType.COVERAGE);
    }

    private Metric(String displayName, String label, MetricEvaluator evaluator, MetricTendency tendency, MetricValueType type) {
        this(displayName, label, evaluator, tendency, type, new CoverageFormatter());
    }

    private Metric(String displayName, String label, MetricEvaluator evaluator, MetricTendency tendency, MetricValueType type, MetricFormatter formatter) {
        this.displayName = displayName;
        this.label = label;
        this.evaluator = evaluator;
        this.tendency = tendency;
        this.type = type;
        this.formatter = formatter;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLabel() {
        return this.label;
    }

    public MetricTendency getTendency() {
        return this.tendency;
    }

    public boolean isContainer() {
        return this.evaluator.isAggregatingChildren();
    }

    public MetricValueType getType() {
        return this.type;
    }

    public boolean isCoverage() {
        return this.type == MetricValueType.COVERAGE;
    }

    public String toTagName() {
        return this.name().toLowerCase(Locale.ENGLISH).replaceAll("_", "-");
    }

    public Optional<Value> getValueFor(Node node) {
        return this.evaluator.compute(node, this);
    }

    public List<? extends Node> getTargetNodes(Node node) {
        if (this.getType() == MetricValueType.CLASS_METRIC) {
            return node.getAllClassNodes();
        }
        return node.getAllMethodNodes();
    }

    public String format(Locale locale, double value) {
        return this.formatter.format(locale, value);
    }

    public String formatDelta(Locale locale, double value) {
        return this.formatter.formatDelta(locale, value);
    }

    public String formatMean(Locale locale, double value) {
        return this.formatter.formatMean(locale, value);
    }

    public String getAggregationType() {
        return this.evaluator.getAggregationType();
    }

    public Value parseValue(String value) {
        return new Value(this, Fraction.getFraction((String)value));
    }

    public static NavigableSet<Metric> getCoverageMetrics() {
        return Arrays.stream(Metric.values()).filter(Metric::isCoverage).collect(TreeSet::new, Set::add, Set::addAll);
    }

    public static enum MetricTendency {
        LARGER_IS_BETTER,
        SMALLER_IS_BETTER;

    }

    private static abstract class MetricEvaluator
    implements Serializable {
        private static final long serialVersionUID = -537814226149186300L;

        private MetricEvaluator() {
        }

        final Optional<Value> compute(Node node, Metric searchMetric) {
            return this.getValue(node, searchMetric).or(() -> this.computeDerivedValue(node, searchMetric));
        }

        abstract Optional<Value> computeDerivedValue(Node var1, Metric var2);

        abstract boolean isAggregatingChildren();

        String getAggregationType() {
            return "";
        }

        Optional<Value> getValue(Node node, Metric searchMetric) {
            return node.getValues().stream().filter(leaf -> leaf.getMetric().equals((Object)searchMetric)).findAny();
        }
    }

    public static enum MetricValueType {
        COVERAGE,
        METRIC,
        METHOD_METRIC,
        CLASS_METRIC;

    }

    private static class CoverageFormatter
    extends MetricFormatter {
        private static final long serialVersionUID = 4337117939462815181L;

        private CoverageFormatter() {
        }

        @Override
        String formatMean(Locale locale, double value) {
            return this.percentage(this.formatDouble(locale, value));
        }

        @Override
        String format(Locale locale, double value) {
            return this.percentage(this.formatDouble(locale, value));
        }

        @Override
        String formatDelta(Locale locale, double value) {
            return this.percentage(super.formatDelta(locale, value));
        }
    }

    private static class MetricFormatter
    implements Serializable {
        private static final long serialVersionUID = 7402798036375016965L;

        private MetricFormatter() {
        }

        String format(Locale locale, double value) {
            return this.formatDouble(locale, value);
        }

        String formatMean(Locale locale, double value) {
            return this.formatDouble(locale, value);
        }

        String formatDelta(Locale locale, double value) {
            double rounded = this.toRounded(value, 2);
            if (rounded == 0.0) {
                return "\u00b10";
            }
            return String.format(locale, "%+.2f", rounded);
        }

        final String formatDouble(Locale locale, double value) {
            return String.format(locale, "%.2f", value);
        }

        final double toRounded(double value, int scale) {
            return BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP).doubleValue();
        }

        String percentage(String value) {
            return value + "%";
        }
    }

    private static class CoverageOfChildrenEvaluator
    extends MetricEvaluator {
        private static final long serialVersionUID = 8788686429559762490L;

        private CoverageOfChildrenEvaluator() {
        }

        @Override
        public boolean isAggregatingChildren() {
            return true;
        }

        @Override
        Optional<Value> computeDerivedValue(Node node, Metric searchMetric) {
            Optional aggregatedChildrenValue = node.getChildren().stream().map(n -> n.getValue(searchMetric)).flatMap(Optional::stream).reduce(Value::add);
            Optional<Value> localMetricValue = this.getMetricOf(node, searchMetric);
            return Stream.of(localMetricValue, aggregatedChildrenValue).flatMap(Optional::stream).reduce(Value::add);
        }

        private Optional<Value> getMetricOf(Node node, Metric searchMetric) {
            if (node.getMetric().equals((Object)searchMetric)) {
                return this.getValue(node, searchMetric).or(() -> this.deriveFromCoverage(node, searchMetric));
            }
            return Optional.empty();
        }

        private Optional<? extends Value> deriveFromCoverage(Node node, Metric searchMetric) {
            boolean hasCoverage = node.getMetrics().stream().anyMatch(Metric::isCoverage);
            if (hasCoverage) {
                return Optional.ofNullable(this.deriveCoverageFromOtherMetrics(node, searchMetric));
            }
            return Optional.empty();
        }

        private Coverage deriveCoverageFromOtherMetrics(Node node, Metric searchMetric) {
            Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder().withMetric(searchMetric);
            if (this.hasCoverage(node)) {
                builder.withCovered(1).withMissed(0);
            } else {
                builder.withCovered(0).withMissed(1);
            }
            return builder.build();
        }

        private boolean hasCoverage(Node node) {
            boolean baseline = this.hasCoverage(node, INSTRUCTION) || this.hasCoverage(node, LINE) || this.hasCoverage(node, BRANCH);
            boolean additional = this.hasCoverage(node, MCDC_PAIR) || this.hasCoverage(node, FUNCTION_CALL) || this.hasCoverage(node, MUTATION);
            return baseline || additional;
        }

        private boolean hasCoverage(Node node, Metric metric) {
            return node.getValue(metric).filter(value -> ((Coverage)value).getCovered() > 0).isPresent();
        }
    }

    private static class ValuesAggregator
    extends MetricEvaluator {
        private static final long serialVersionUID = 7908490688181149667L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final BinaryOperator<Value> accumulator;
        private final String name;

        ValuesAggregator() {
            this(Value::add, "total");
        }

        ValuesAggregator(BinaryOperator<Value> accumulator, String name) {
            this.accumulator = accumulator;
            this.name = name;
        }

        @Override
        String getAggregationType() {
            return this.name;
        }

        @Override
        public boolean isAggregatingChildren() {
            return false;
        }

        @Override
        final Optional<Value> computeDerivedValue(Node node, Metric searchMetric) {
            Optional<Value> defaultValue = this.getDefaultValue(node);
            return defaultValue.or(() -> node.getChildren().stream().map(n -> this.compute((Node)n, searchMetric)).flatMap(Optional::stream).reduce(this.accumulator));
        }

        Optional<Value> getDefaultValue(Node node) {
            return Optional.empty();
        }
    }

    private static class IntegerFormatter
    extends MetricFormatter {
        private static final long serialVersionUID = 8053070560640902081L;

        private IntegerFormatter() {
        }

        @Override
        String format(Locale locale, double value) {
            return String.format(locale, "%d", Math.round(this.toRounded(value, 0)));
        }

        @Override
        String formatDelta(Locale locale, double value) {
            double rounded = this.toRounded(value, 0);
            if (rounded == 0.0) {
                return "\u00b10";
            }
            return String.format(locale, "%+d", Math.round(this.toRounded(value, 0)));
        }
    }

    private static class LocEvaluator
    extends ValuesAggregator {
        private static final long serialVersionUID = 8819577749737375989L;

        private LocEvaluator() {
        }

        @Override
        Optional<Value> getDefaultValue(Node node) {
            return LINE.getValueFor(node).map(this::getTotal);
        }

        @SuppressFBWarnings(value={"BC"}, justification="The value is a coverage value as it has the metric LINE")
        private Value getTotal(Value leaf) {
            Coverage coverage = (Coverage)leaf;
            return new Value(LOC, coverage.getTotal());
        }
    }

    private static class PercentageFormatter
    extends MetricFormatter {
        private static final long serialVersionUID = -4995914265987128828L;

        private PercentageFormatter() {
        }

        @Override
        String format(Locale locale, double value) {
            return this.percentage(this.formatDouble(locale, value * 100.0));
        }

        @Override
        String formatMean(Locale locale, double value) {
            return this.percentage(this.formatDouble(locale, value * 100.0));
        }

        @Override
        String formatDelta(Locale locale, double value) {
            return this.percentage(super.formatDelta(locale, value * 100.0));
        }
    }
}

