/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.FileReaderFactory;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.assertions.Assertions;
import edu.hm.hafner.analysis.assertions.SoftAssertions;
import edu.hm.hafner.analysis.registry.CompositeParserDescriptor;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.analysis.registry.ParserRegistry;
import edu.hm.hafner.util.ResourceTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class AbstractParserTest
extends ResourceTest {
    protected static final String DEFAULT_CATEGORY = new IssueBuilder().build().getCategory();
    private final String fileWithIssuesName;

    protected AbstractParserTest(String fileWithIssuesName) {
        this.fileWithIssuesName = fileWithIssuesName;
    }

    protected String getFileWithIssuesName() {
        return this.fileWithIssuesName;
    }

    @Test
    void shouldParseAllIssues() {
        Report report = this.parseDefaultFile();
        try (SoftAssertions softAssertions = new SoftAssertions();){
            this.assertThatIssuesArePresent(report, softAssertions);
        }
    }

    @Test
    void shouldRegisterParser() {
        Assumptions.assumeThat((String)this.createParser().getClass().getPackageName()).startsWith((CharSequence)"edu.hm.hafner.analysis");
        ParserRegistry parserRegistry = new ParserRegistry();
        Set parsers = parserRegistry.getAllDescriptors().stream().map(rec$ -> ((ParserDescriptor)rec$).create(new ParserDescriptor.Option[0])).map(Object::getClass).collect(Collectors.toSet());
        List<Class> compositeParsers = parserRegistry.getAllDescriptors().stream().filter(CompositeParserDescriptor.class::isInstance).map(CompositeParserDescriptor.class::cast).map(CompositeParserDescriptor::createParsers).flatMap(Collection::stream).map(Object::getClass).toList();
        parsers.addAll(compositeParsers);
        ((AbstractCollectionAssert)Assertions.assertThat(parsers).as("Every parser should be registered in the ParserRegistry", new Object[0])).contains((Object[])new Class[]{this.createParser().getClass()});
        parserRegistry.getAllDescriptors().stream().map(ParserDescriptor::getUrl).forEach(url -> Assertions.assertThat((String)url).matches((CharSequence)"https?://.*|^$"));
    }

    protected void assertThatReportHasSeverities(Report report, int expectedSizeError, int expectedSizeHigh, int expectedSizeNormal, int expectedSizeLow) {
        Assertions.assertThat((int)report.getSizeOf(Severity.ERROR)).isEqualTo(expectedSizeError);
        Assertions.assertThat((int)report.getSizeOf(Severity.WARNING_HIGH)).isEqualTo(expectedSizeHigh);
        Assertions.assertThat((int)report.getSizeOf(Severity.WARNING_NORMAL)).isEqualTo(expectedSizeNormal);
        Assertions.assertThat((int)report.getSizeOf(Severity.WARNING_LOW)).isEqualTo(expectedSizeLow);
    }

    protected Report parseDefaultFile() {
        IssueParser parser = this.createParser();
        ReaderFactory factory = this.getDefaultFileFactory();
        Assertions.assertThat((boolean)parser.accepts(factory)).isTrue();
        return parser.parse(factory);
    }

    @Test
    void shouldBeSerializable() throws IOException {
        IssueParser parser = this.createParser();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(out);){
            stream.writeObject(parser);
        }
        Assertions.assertThat((byte[])out.toByteArray()).isNotEmpty();
    }

    @Test
    void shouldHandleEmptyFile() {
        boolean passed;
        try {
            Report report = this.parseStringContent("");
            passed = report.isEmpty();
        }
        catch (ParsingException e) {
            passed = true;
        }
        Assertions.assertThat((boolean)passed).isTrue();
    }

    protected Report parse(String fileName) {
        return this.createParser().parse(this.createReaderFactory(fileName));
    }

    protected Report parseStringContent(String content) {
        return this.createParser().parse((ReaderFactory)new StringReaderFactory(content));
    }

    protected abstract void assertThatIssuesArePresent(Report var1, SoftAssertions var2);

    protected abstract IssueParser createParser();

    ReaderFactory getDefaultFileFactory() {
        return this.createReaderFactory(this.fileWithIssuesName);
    }

    protected ReaderFactory createReaderFactory(String fileName) {
        return new FileReaderFactory(this.getResourceAsFile(fileName), StandardCharsets.UTF_8);
    }

    public static class StringReaderFactory
    extends ReaderFactory {
        private final String content;

        public StringReaderFactory(String content) {
            super(StandardCharsets.UTF_8);
            this.content = content;
        }

        public String getFileName() {
            return "String";
        }

        public Reader create() {
            return new StringReader(this.content);
        }
    }
}

