/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification;

import com.tikal.hudson.plugins.notification.Endpoint;
import com.tikal.hudson.plugins.notification.HudsonNotificationProperty;
import com.tikal.hudson.plugins.notification.UrlInfo;
import com.tikal.hudson.plugins.notification.Utils;
import com.tikal.hudson.plugins.notification.model.BuildState;
import com.tikal.hudson.plugins.notification.model.JobState;
import com.tikal.hudson.plugins.notification.model.ScmState;
import com.tikal.hudson.plugins.notification.model.TestState;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import hudson.scm.ChangeLogSet;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public final class Phase
extends Enum<Phase> {
    public static final /* enum */ Phase QUEUED = new Phase();
    public static final /* enum */ Phase STARTED = new Phase();
    public static final /* enum */ Phase COMPLETED = new Phase();
    public static final /* enum */ Phase FINALIZED = new Phase();
    public static final /* enum */ Phase NONE = new Phase();
    private static final /* synthetic */ Phase[] $VALUES;

    public static Phase[] values() {
        return (Phase[])$VALUES.clone();
    }

    public static Phase valueOf(String name) {
        return Enum.valueOf(Phase.class, name);
    }

    private Result findLastBuildThatFinished(Run run) {
        for (Run previousRun = run.getPreviousCompletedBuild(); previousRun != null; previousRun = previousRun.getPreviousCompletedBuild()) {
            Result previousResults = previousRun.getResult();
            if (previousResults == null) {
                throw new IllegalStateException("Previous result can't be null here");
            }
            if (!previousResults.equals(Result.SUCCESS) && !previousResults.equals(Result.FAILURE) && !previousResults.equals(Result.UNSTABLE)) continue;
            return previousResults;
        }
        return null;
    }

    public void handle(Run run, TaskListener listener, long timestamp) {
        this.handle(run, listener, timestamp, false, null, 0, this);
    }

    private boolean isURLValid(String urlInputValue, String expandedUrl, PrintStream logger) {
        boolean isValid = false;
        if (expandedUrl.contains("$")) {
            logger.printf("Ignoring sending notification due to unresolved variable: %s%n", urlInputValue);
        } else if (StringUtils.isBlank((String)expandedUrl)) {
            logger.println("URL is not set, ignoring call to send notification.");
        } else {
            isValid = true;
        }
        return isValid;
    }

    private boolean isRun(Endpoint endpoint, Result result, Result previousRunResult) {
        String event = endpoint.getEvent();
        if (event == null) {
            return true;
        }
        switch (event) {
            case "all": {
                return true;
            }
            case "failed": {
                if (result == null) {
                    return false;
                }
                return this.equals((Object)FINALIZED) && result.equals(Result.FAILURE);
            }
            case "failedAndFirstSuccess": {
                if (result == null || !this.equals((Object)FINALIZED)) {
                    return false;
                }
                if (result.equals(Result.FAILURE)) {
                    return true;
                }
                return previousRunResult != null && result.equals(Result.SUCCESS) && previousRunResult.equals(Result.FAILURE);
            }
            case "manual": {
                return false;
            }
        }
        return event.equals(this.toString().toLowerCase());
    }

    private JobState buildJobState(Job job, Run run, TaskListener listener, long timestamp, Endpoint target, Phase phase) throws IOException, InterruptedException {
        BuildData build;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        assert (jenkins != null);
        String rootUrl = jenkins.getRootUrl();
        JobState jobState = new JobState();
        BuildState buildState = new BuildState();
        ScmState scmState = new ScmState();
        Result result = run.getResult();
        ParametersAction paramsAction = (ParametersAction)run.getAction(ParametersAction.class);
        EnvVars environment = run.getEnvironment(listener);
        StringBuilder log = this.getLog(run, target);
        jobState.setName(job.getName());
        jobState.setDisplayName(job.getDisplayName());
        jobState.setUrl(job.getUrl());
        jobState.setBuild(buildState);
        buildState.setNumber(run.number);
        buildState.setQueueId(run.getQueueId());
        buildState.setUrl(run.getUrl());
        buildState.setPhase(phase);
        buildState.setTimestamp(timestamp);
        buildState.setDuration(run.getDuration());
        buildState.setScm(scmState);
        buildState.setLog(log);
        buildState.setNotes(this.resolveMacros(run, listener, target.getBuildNotes()));
        buildState.setTestSummary(this.getTestResults(run));
        if (result != null) {
            buildState.setStatus(result.toString());
        }
        if (rootUrl != null) {
            buildState.setFullUrl(rootUrl + run.getUrl());
        }
        buildState.updateArtifacts(job, run);
        if (paramsAction != null) {
            EnvVars env = new EnvVars();
            for (ParameterValue parameterValue : paramsAction.getParameters()) {
                if (parameterValue.isSensitive()) continue;
                parameterValue.buildEnvironment(run, env);
            }
            buildState.setParameters((Map<String, String>)env);
        }
        if ((build = (BuildData)job.getAction(BuildData.class)) != null) {
            String url;
            if (!build.remoteUrls.isEmpty() && (url = (String)build.remoteUrls.iterator().next()) != null) {
                scmState.setUrl(url);
            }
            for (Map.Entry entry : build.buildsByBranchName.entrySet()) {
                if (((Build)entry.getValue()).hudsonBuildNumber != run.number) continue;
                scmState.setBranch((String)entry.getKey());
                scmState.setCommit(((Build)entry.getValue()).revision.getSha1String());
            }
        }
        if (environment.get((Object)"GIT_URL") != null) {
            scmState.setUrl((String)environment.get((Object)"GIT_URL"));
        }
        if (environment.get((Object)"GIT_BRANCH") != null) {
            scmState.setBranch((String)environment.get((Object)"GIT_BRANCH"));
        }
        if (environment.get((Object)"GIT_COMMIT") != null) {
            scmState.setCommit((String)environment.get((Object)"GIT_COMMIT"));
        }
        scmState.setChanges(this.getChangedFiles(run));
        scmState.setCulprits(this.getCulprits(run));
        return jobState;
    }

    private String resolveMacros(Run build, TaskListener listener, String text) {
        String result = text;
        try {
            FilePath workspace;
            Executor executor = build.getExecutor();
            if (executor != null && (workspace = executor.getCurrentWorkspace()) != null) {
                result = TokenMacro.expandAll((Run)build, (FilePath)workspace, (TaskListener)listener, (String)text);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(listener.error(String.format("Failed to evaluate macro '%s'", text)));
        }
        return result;
    }

    private TestState getTestResults(Run build) {
        TestState resultSummary = null;
        AbstractTestResultAction testAction = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        if (testAction != null) {
            int total = testAction.getTotalCount();
            int failCount = testAction.getFailCount();
            int skipCount = testAction.getSkipCount();
            resultSummary = new TestState();
            resultSummary.setTotal(total);
            resultSummary.setFailed(failCount);
            resultSummary.setSkipped(skipCount);
            resultSummary.setPassed(total - failCount - skipCount);
            resultSummary.setFailedTests(this.getFailedTestNames(testAction));
        }
        return resultSummary;
    }

    private List<String> getFailedTestNames(AbstractTestResultAction testResultAction) {
        ArrayList<String> failedTests = new ArrayList<String>();
        List results = testResultAction.getFailedTests();
        for (TestResult t : results) {
            failedTests.add(t.getFullName());
        }
        return failedTests;
    }

    private List<String> getChangedFiles(Run run) {
        AbstractBuild build;
        Object[] items;
        ArrayList<String> affectedPaths = new ArrayList<String>();
        if (run instanceof AbstractBuild && (items = (build = (AbstractBuild)run).getChangeSet().getItems()) != null && items.length > 0) {
            for (Object o : items) {
                if (!(o instanceof ChangeLogSet.Entry)) continue;
                affectedPaths.addAll(((ChangeLogSet.Entry)o).getAffectedPaths());
            }
        }
        return affectedPaths;
    }

    private List<String> getCulprits(Run run) {
        ArrayList<String> culprits = new ArrayList<String>();
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            Set buildCulprits = build.getCulprits();
            for (User user : buildCulprits) {
                culprits.add(user.getId());
            }
        }
        return culprits;
    }

    private StringBuilder getLog(Run run, Endpoint target) {
        StringBuilder log = new StringBuilder();
        Integer loglines = target.getLoglines();
        if (loglines == null || loglines == 0) {
            return log;
        }
        try {
            if (loglines == -1) {
                log.append(run.getLog());
            } else {
                List logEntries = run.getLog(loglines.intValue());
                for (String entry : logEntries) {
                    log.append(entry);
                    log.append("\n");
                }
            }
        }
        catch (IOException e) {
            log.append("Unable to retrieve log");
        }
        return log;
    }

    public void handle(Run run, TaskListener listener, long timestamp, boolean manual, String buildNotes, Integer logLines, Phase phase) {
        Job job = run.getParent();
        HudsonNotificationProperty property = (HudsonNotificationProperty)job.getProperty(HudsonNotificationProperty.class);
        if (property == null) {
            return;
        }
        Result previousCompletedRunResults = this.findLastBuildThatFinished(run);
        for (Endpoint target : property.getEndpoints()) {
            if (!manual && !this.isRun(target, run.getResult(), previousCompletedRunResults) || Utils.isEmpty(target.getUrlInfo().getUrlOrId())) continue;
            if (Objects.nonNull(buildNotes)) {
                target.setBuildNotes(buildNotes);
            }
            if (Objects.nonNull(logLines) && logLines != 0) {
                target.setLoglines(logLines);
            }
            int triesRemaining = target.getRetries();
            boolean failed = false;
            do {
                String urlIdString = "url 'unknown'";
                try {
                    String expandedUrl;
                    EnvVars environment = run.getEnvironment(listener);
                    UrlInfo urlInfo = target.getUrlInfo();
                    switch (urlInfo.getUrlType()) {
                        case PUBLIC: {
                            expandedUrl = environment.expand(urlInfo.getUrlOrId());
                            urlIdString = String.format("url '%s'", expandedUrl);
                            break;
                        }
                        case SECRET: {
                            String urlSecretId = urlInfo.getUrlOrId();
                            String actualUrl = Utils.getSecretUrl(urlSecretId, job.getParent());
                            expandedUrl = environment.expand(actualUrl);
                            urlIdString = String.format("credentials id '%s'", urlSecretId);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unknown URL type");
                        }
                    }
                    if (!this.isURLValid(urlIdString, expandedUrl, listener.getLogger())) continue;
                    String branch = target.getBranch();
                    if (!manual && environment.containsKey((Object)"BRANCH_NAME") && !((String)environment.get((Object)"BRANCH_NAME")).matches(branch)) {
                        listener.getLogger().printf("Environment variable %s with value %s does not match configured branch filter %s%n", "BRANCH_NAME", environment.get((Object)"BRANCH_NAME"), branch);
                        continue;
                    }
                    if (!(manual || environment.containsKey((Object)"BRANCH_NAME") || ".*".equals(branch))) {
                        listener.getLogger().printf("Environment does not contain %s variable%n", "BRANCH_NAME");
                        continue;
                    }
                    listener.getLogger().printf("Notifying endpoint with %s%n", urlIdString);
                    JobState jobState = this.buildJobState(job, run, listener, timestamp, target, phase);
                    target.getProtocol().send(expandedUrl, target.getFormat().serialize(jobState), target.getTimeout(), target.isJson());
                }
                catch (Throwable error) {
                    failed = true;
                    error.printStackTrace(listener.error(String.format("Failed to notify endpoint with %s", urlIdString)));
                    listener.getLogger().printf("Failed to notify endpoint with %s - %s: %s%n", urlIdString, error.getClass().getName(), error.getMessage());
                    if (triesRemaining <= 0) continue;
                    listener.getLogger().printf("Reattempting to notify endpoint with %s (%d tries remaining)%n", urlIdString, triesRemaining);
                }
            } while (failed && --triesRemaining >= 0);
        }
    }

    private static /* synthetic */ Phase[] $values() {
        return new Phase[]{QUEUED, STARTED, COMPLETED, FINALIZED, NONE};
    }

    static {
        $VALUES = Phase.$values();
    }
}

