/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.tikal.hudson.plugins.notification.model.JobState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Format {
    XML{
        private final transient XStream xstream = new XStream();

        @Override
        protected byte[] serialize(JobState jobState) throws IOException {
            this.xstream.processAnnotations(JobState.class);
            return this.xstream.toXML((Object)jobState).getBytes(StandardCharsets.UTF_8);
        }
    }
    ,
    JSON{
        private final transient Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

        @Override
        protected byte[] serialize(JobState jobState) throws IOException {
            return this.gson.toJson((Object)jobState).getBytes(StandardCharsets.UTF_8);
        }
    };


    protected abstract byte[] serialize(JobState var1) throws IOException;
}

