/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification;

import com.tikal.hudson.plugins.notification.Format;
import com.tikal.hudson.plugins.notification.Protocol;
import com.tikal.hudson.plugins.notification.UrlInfo;
import com.tikal.hudson.plugins.notification.UrlType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Endpoint {
    public static final Integer DEFAULT_TIMEOUT = 30000;
    public static final Integer DEFAULT_RETRIES = 0;
    public static final String DEFAULT_BRANCH = ".*";
    private Protocol protocol = Protocol.HTTP;
    private Format format = Format.JSON;
    private UrlInfo urlInfo;
    @Deprecated
    private transient String url;
    private String event = "all";
    private Integer timeout = DEFAULT_TIMEOUT;
    private Integer loglines = 0;
    private String buildNotes;
    private Integer retries = DEFAULT_RETRIES;
    private String branch = ".*";

    @Deprecated
    public Endpoint(Protocol protocol, String url, String event, Format format, Integer timeout, Integer loglines) {
        this.setProtocol(protocol);
        this.setUrlInfo(new UrlInfo(UrlType.PUBLIC, url));
        this.setEvent(event);
        this.setFormat(format);
        this.setTimeout(timeout);
        this.setLoglines(loglines);
    }

    @DataBoundConstructor
    public Endpoint(UrlInfo urlInfo) {
        this.setUrlInfo(urlInfo);
    }

    public UrlInfo getUrlInfo() {
        if (this.urlInfo == null) {
            this.urlInfo = new UrlInfo(UrlType.PUBLIC, "");
        }
        return this.urlInfo;
    }

    public void setUrlInfo(UrlInfo urlInfo) {
        this.urlInfo = urlInfo;
    }

    public int getTimeout() {
        return this.timeout == null ? DEFAULT_TIMEOUT : this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @DataBoundSetter
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getEvent() {
        return this.event;
    }

    @DataBoundSetter
    public void setEvent(String event) {
        this.event = event;
    }

    public Format getFormat() {
        if (this.format == null) {
            this.format = Format.JSON;
        }
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(Format format) {
        this.format = format;
    }

    public Integer getLoglines() {
        return this.loglines;
    }

    @DataBoundSetter
    public void setLoglines(Integer loglines) {
        this.loglines = loglines;
    }

    public String getBuildNotes() {
        return this.buildNotes;
    }

    @DataBoundSetter
    public void setBuildNotes(String buildNotes) {
        this.buildNotes = buildNotes;
    }

    public boolean isJson() {
        return this.getFormat() == Format.JSON;
    }

    public Integer getRetries() {
        return this.retries == null ? DEFAULT_RETRIES : this.retries;
    }

    @DataBoundSetter
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    protected Object readResolve() {
        if (this.url != null) {
            this.urlInfo = new UrlInfo(UrlType.PUBLIC, this.url);
        }
        return this;
    }

    public String getBranch() {
        return this.branch;
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String toString() {
        return String.valueOf((Object)this.protocol) + ":" + this.urlInfo.getUrlOrId();
    }
}

