/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification.model;

import com.tikal.hudson.plugins.notification.Phase;
import com.tikal.hudson.plugins.notification.Utils;
import com.tikal.hudson.plugins.notification.model.ScmState;
import com.tikal.hudson.plugins.notification.model.TestState;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.s3.Entry;
import hudson.plugins.s3.S3BucketPublisher;
import hudson.util.DescribableList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;

public class BuildState {
    private String fullUrl;
    private int number;
    private long queueId;
    private long timestamp;
    private long duration;
    private Phase phase;
    private String status;
    private String url;
    private String displayName;
    private ScmState scm;
    private Map<String, String> parameters;
    private StringBuilder log;
    private String notes;
    private TestState testSummary;
    private final Map<String, Map<String, String>> artifacts = new HashMap<String, Map<String, String>>();

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public long getQueueId() {
        return this.queueId;
    }

    public void setQueueId(long queue) {
        this.queueId = queue;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> params) {
        this.parameters = new HashMap<String, String>(params);
    }

    public Map<String, Map<String, String>> getArtifacts() {
        return this.artifacts;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ScmState getScm() {
        return this.scm;
    }

    public void setScm(ScmState scmState) {
        this.scm = scmState;
    }

    public StringBuilder getLog() {
        return this.log;
    }

    public void setLog(StringBuilder log) {
        this.log = log;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String buildNotes) {
        this.notes = buildNotes;
    }

    public TestState getTestSummary() {
        return this.testSummary;
    }

    public void setTestSummary(TestState testSummary) {
        this.testSummary = testSummary;
    }

    public void updateArtifacts(Job job, Run run) {
        this.updateArchivedArtifacts(run);
        this.updateS3Artifacts(job, run);
    }

    private void updateArchivedArtifacts(Run run) {
        List buildArtifacts = run.getArtifacts();
        for (Run.Artifact a : buildArtifacts) {
            String artifactUrl = Jenkins.get().getRootUrl() + run.getUrl() + "artifact/" + a.getHref();
            this.updateArtifact(a.relativePath, "archive", artifactUrl);
        }
    }

    private void updateS3Artifacts(Job job, Run run) {
        if (Jenkins.get().getPlugin("s3") == null) {
            return;
        }
        if (!(run instanceof AbstractBuild)) {
            return;
        }
        if (Utils.isEmpty(job.getName())) {
            return;
        }
        DescribableList publishers = ((AbstractBuild)run).getProject().getPublishersList();
        S3BucketPublisher s3Publisher = (S3BucketPublisher)publishers.get(S3BucketPublisher.class);
        if (s3Publisher == null) {
            return;
        }
        for (Entry entry : s3Publisher.getEntries()) {
            if (Utils.isEmpty(entry.sourceFile, entry.selectedRegion, entry.bucket)) continue;
            String fileName = new File(entry.sourceFile).getName();
            if (Utils.isEmpty(fileName)) continue;
            String bucketUrl = String.format("https://s3-%s.amazonaws.com/%s", entry.selectedRegion.toLowerCase().replace('_', '-'), entry.bucket);
            String fileUrl = entry.managedArtifacts ? String.format("%s/jobs/%s/%s/%s", bucketUrl, job.getName(), run.getNumber(), fileName) : String.format("%s/%s", bucketUrl, fileName);
            this.updateArtifact(fileName, "s3", fileUrl);
        }
    }

    private void updateArtifact(String fileName, String locationName, String locationUrl) {
        Utils.verifyNotEmpty(fileName, locationName, locationUrl);
        if (!this.artifacts.containsKey(fileName)) {
            this.artifacts.put(fileName, new HashMap());
        }
        if (this.artifacts.get(fileName).containsKey(locationName)) {
            throw new RuntimeException(String.format("Adding artifacts mapping '%s/%s/%s' - artifacts Map already contains mapping of location '%s': %s", fileName, locationName, locationUrl, locationName, this.artifacts));
        }
        this.artifacts.get(fileName).put(locationName, locationUrl);
    }
}

