/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification;

import com.tikal.hudson.plugins.notification.HostnamePort;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import jenkins.model.Jenkins;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Protocol {
    UDP{

        @Override
        protected void send(String url, byte[] data, int timeout, boolean isJson) throws IOException {
            HostnamePort hostnamePort = HostnamePort.parseUrl(url);
            DatagramSocket socket = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(hostnamePort.hostname), hostnamePort.port);
            socket.send(packet);
        }
    }
    ,
    TCP{

        @Override
        protected void send(String url, byte[] data, int timeout, boolean isJson) throws IOException {
            HostnamePort hostnamePort = HostnamePort.parseUrl(url);
            InetSocketAddress endpoint = new InetSocketAddress(InetAddress.getByName(hostnamePort.hostname), hostnamePort.port);
            Socket socket = new Socket();
            socket.setSoTimeout(timeout);
            socket.connect(endpoint, timeout);
            OutputStream output = socket.getOutputStream();
            output.write(data);
            output.flush();
            output.close();
        }
    }
    ,
    HTTP{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void send(String url, byte[] data, int timeout, boolean isJson) throws IOException {
            URL targetUrl = new URL(url);
            if (!targetUrl.getProtocol().startsWith("http")) {
                throw new IllegalArgumentException("Not an http(s) url: " + url);
            }
            String httpProxyUrl = System.getenv().get("http_proxy");
            URL proxyUrl = null;
            if (httpProxyUrl != null && !httpProxyUrl.isEmpty() && !(proxyUrl = new URL(httpProxyUrl)).getProtocol().startsWith("http")) {
                throw new IllegalArgumentException("Not an http(s) url: " + httpProxyUrl);
            }
            Proxy proxy = Proxy.NO_PROXY;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null && jenkins.proxy != null) {
                proxy = jenkins.proxy.createProxy(targetUrl.getHost());
            } else if (proxyUrl != null) {
                int proxyPort = proxyUrl.getPort() > 0 ? proxyUrl.getPort() : 80;
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyPort));
            }
            HttpURLConnection connection = (HttpURLConnection)targetUrl.openConnection(proxy);
            connection.setRequestProperty("Content-Type", String.format("application/%s;charset=UTF-8", isJson ? "json" : "xml"));
            String userInfo = targetUrl.getUserInfo();
            if (null != userInfo) {
                String b64UserInfo = Base64.getEncoder().encodeToString(userInfo.getBytes(Charset.defaultCharset()));
                String authorizationHeader = "Basic " + b64UserInfo;
                connection.setRequestProperty("Authorization", authorizationHeader);
            }
            connection.setFixedLengthStreamingMode(data.length);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.connect();
            try (OutputStream output = connection.getOutputStream();){
                output.write(data);
                output.flush();
            }
            finally {
                if (307 == connection.getResponseCode()) {
                    String location = connection.getHeaderField("Location");
                    connection.disconnect();
                    this.send(location, data, timeout, isJson);
                } else {
                    connection.disconnect();
                }
            }
        }

        @Override
        public void validateUrl(String url) {
            if (!url.contains("$")) {
                try {
                    new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(String.format("%sUse http://hostname:port/path for endpoint URL", Protocol.isEmpty(url) ? "" : "Invalid URL '" + url + "'. "));
                }
            }
        }
    };


    protected abstract void send(String var1, byte[] var2, int var3, boolean var4) throws IOException;

    public void validateUrl(String url) {
        try {
            HostnamePort hnp = HostnamePort.parseUrl(url);
            if (hnp == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%sUse hostname:port for endpoint URL", Protocol.isEmpty(url) ? "" : "Invalid URL '" + url + "'. "));
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

