/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.tikal.hudson.plugins.notification.Endpoint;
import com.tikal.hudson.plugins.notification.Format;
import com.tikal.hudson.plugins.notification.HudsonNotificationProperty;
import com.tikal.hudson.plugins.notification.Protocol;
import com.tikal.hudson.plugins.notification.UrlInfo;
import com.tikal.hudson.plugins.notification.UrlType;
import com.tikal.hudson.plugins.notification.Utils;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class HudsonNotificationPropertyDescriptor
extends JobPropertyDescriptor {
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public HudsonNotificationPropertyDescriptor() {
        super(HudsonNotificationProperty.class);
        this.load();
    }

    public boolean isEnabled() {
        return !this.endpoints.isEmpty();
    }

    public List<Endpoint> getTargets() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = new ArrayList<Endpoint>(endpoints);
    }

    public boolean isApplicable(Class<? extends Job> jobType) {
        return true;
    }

    @Nonnull
    public String getDisplayName() {
        return "Hudson Job Notification";
    }

    public String getDefaultBranch() {
        return ".*";
    }

    public int getDefaultTimeout() {
        return Endpoint.DEFAULT_TIMEOUT;
    }

    public int getDefaultRetries() {
        return Endpoint.DEFAULT_RETRIES;
    }

    public HudsonNotificationProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        JSON endpointsData;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (formData != null && !formData.isNullObject() && (endpointsData = (JSON)formData.get("endpoints")) != null && !endpointsData.isEmpty()) {
            if (endpointsData.isArray()) {
                JSONArray endpointsArrayData = (JSONArray)endpointsData;
                for (int i = 0; i < endpointsArrayData.size(); ++i) {
                    JSONObject endpointsObject = endpointsArrayData.getJSONObject(i);
                    endpoints.add(this.convertJson(endpointsObject));
                }
            } else {
                endpoints.add(this.convertJson((JSONObject)endpointsData));
            }
        }
        return new HudsonNotificationProperty(endpoints);
    }

    private Endpoint convertJson(JSONObject endpointObjectData) throws Descriptor.FormException {
        UrlInfo urlInfo;
        JSONObject urlInfoData = endpointObjectData.getJSONObject("urlInfo");
        if (urlInfoData.containsKey((Object)"publicUrl")) {
            urlInfo = new UrlInfo(UrlType.PUBLIC, urlInfoData.getString("publicUrl"));
        } else if (urlInfoData.containsKey((Object)"secretUrl")) {
            urlInfo = new UrlInfo(UrlType.SECRET, urlInfoData.getString("secretUrl"));
        } else {
            throw new Descriptor.FormException("Expected either a public url or secret url id", "urlInfo");
        }
        Endpoint endpoint = new Endpoint(urlInfo);
        endpoint.setEvent(endpointObjectData.getString("event"));
        endpoint.setFormat(Format.valueOf(endpointObjectData.getString("format")));
        endpoint.setProtocol(Protocol.valueOf(endpointObjectData.getString("protocol")));
        endpoint.setTimeout(endpointObjectData.getInt("timeout"));
        endpoint.setRetries(endpointObjectData.getInt("retries"));
        endpoint.setLoglines(endpointObjectData.getInt("loglines"));
        endpoint.setBuildNotes(endpointObjectData.getString("notes"));
        endpoint.setBranch(endpointObjectData.getString("branch"));
        return endpoint;
    }

    public FormValidation doCheckPublicUrl(@QueryParameter(value="publicUrl", fixEmpty=true) String publicUrl, @RelativePath(value="..") @QueryParameter(value="protocol") String protocolParameter) {
        Protocol protocol = Protocol.valueOf(protocolParameter);
        return this.checkUrl(publicUrl, UrlType.PUBLIC, protocol);
    }

    public FormValidation doCheckSecretUrl(@QueryParameter(value="secretUrl", fixEmpty=true) String publicUrl, @RelativePath(value="..") @QueryParameter(value="protocol") String protocolParameter) {
        Protocol protocol = Protocol.valueOf(protocolParameter);
        return this.checkUrl(publicUrl, UrlType.SECRET, protocol);
    }

    private FormValidation checkUrl(String urlOrId, UrlType urlType, Protocol protocol) {
        String actualUrl = urlOrId;
        if (urlType == UrlType.SECRET && !StringUtils.isEmpty((String)actualUrl) && (actualUrl = (String)Jenkins.get().getItems(ItemGroup.class).stream().map(ig -> Utils.getSecretUrl(urlOrId, ig)).filter(Objects::nonNull).findFirst().orElse(null)) == null) {
            return FormValidation.error((String)("Could not find secret text credentials with id " + urlOrId));
        }
        try {
            protocol.validateUrl(actualUrl);
            return FormValidation.ok();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (urlType == UrlType.SECRET && !StringUtils.isEmpty((String)actualUrl)) {
                message = message.replace(actualUrl, "******");
            }
            return FormValidation.error((String)message);
        }
    }

    public ListBoxModel doFillSecretUrlItems(@AncestorInPath Item owner, @QueryParameter String secretUrl) {
        if (owner == null || !owner.hasPermission(Permission.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        AbstractIdCredentialsListBoxModel model = new StandardListBoxModel().includeEmptyValue().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        if (!StringUtils.isEmpty((String)secretUrl)) {
            for (ListBoxModel.Option option : model) {
                if (!option.value.equals(secretUrl)) continue;
                option.selected = true;
                break;
            }
        }
        return model;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.save();
        return true;
    }
}

