/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.hudson.plugins.notification;

import com.tikal.hudson.plugins.notification.Messages;
import com.tikal.hudson.plugins.notification.Phase;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NotifyStep
extends Step
implements Serializable {
    private static final long serialVersionUID = -2818860651754465006L;
    @CheckForNull
    private String notes;
    @CheckForNull
    private String phase = Phase.STARTED.name();
    @CheckForNull
    private String loglines = "0";

    @CheckForNull
    public String getNotes() {
        return this.notes;
    }

    @DataBoundSetter
    public void setNotes(@CheckForNull String notes) {
        this.notes = Util.fixEmpty((String)notes);
    }

    @CheckForNull
    public String getPhase() {
        return this.phase;
    }

    @DataBoundSetter
    public void setPhase(@CheckForNull String phase) {
        this.phase = Util.fixEmpty((String)phase);
    }

    @CheckForNull
    public String getLoglines() {
        return this.loglines;
    }

    @DataBoundSetter
    public void setLoglines(@CheckForNull String loglines) {
        this.loglines = Util.fixEmpty((String)loglines);
    }

    @DataBoundConstructor
    public NotifyStep() {
    }

    public StepExecution start(StepContext context) {
        return new Execution(context, this);
    }

    static class Execution
    extends StepExecution {
        private static final long serialVersionUID = -2840020502160375407L;
        private final NotifyStep notifyStep;

        Execution(@Nonnull StepContext context, NotifyStep step) {
            super(context);
            this.notifyStep = step;
        }

        public boolean start() throws Exception {
            String logLines = this.notifyStep.getLoglines();
            Phase.NONE.handle(Objects.requireNonNull((Run)this.getContext().get(Run.class)), (TaskListener)this.getContext().get(TaskListener.class), System.currentTimeMillis(), true, this.notifyStep.getNotes(), Integer.parseInt(logLines != null ? logLines : "0"), Phase.valueOf(this.notifyStep.getPhase()));
            this.getContext().onSuccess(null);
            return true;
        }
    }

    @Extension
    public static class Descriptor
    extends StepDescriptor {
        public String getFunctionName() {
            return "notifyEndpoints";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.Notify_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(FilePath.class, FlowNode.class, Run.class, TaskListener.class);
        }
    }
}

