/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobrestrictions.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ClassSelector
implements Describable<ClassSelector>,
Serializable {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    final String selectedClass;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ClassSelector(@CheckForNull String selectedClass) {
        this.selectedClass = Util.fixEmptyAndTrim((String)selectedClass);
    }

    @CheckForNull
    public String getSelectedClass() {
        return this.selectedClass;
    }

    public Descriptor<ClassSelector> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassSelector) {
            ClassSelector cmp = (ClassSelector)obj;
            return Objects.equals(this.selectedClass, cmp.selectedClass);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.selectedClass != null ? this.selectedClass.hashCode() : 0);
        return hash;
    }

    public static class DescriptorImpl
    extends Descriptor<ClassSelector> {
        @NonNull
        public String getDisplayName() {
            return "N/A";
        }

        @RequirePOST
        public FormValidation doCheckSelectedClass(@QueryParameter String selectedClass) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String _selectedClass = Util.fixEmptyAndTrim((String)selectedClass);
            if (_selectedClass == null) {
                return FormValidation.error((String)"Field is empty");
            }
            try {
                Jenkins.get().getPluginManager().uberClassLoader.loadClass(_selectedClass);
            }
            catch (Exception ex) {
                return FormValidation.warning((String)("Class " + _selectedClass + " cannot be resolved: " + ex.toString()));
            }
            return FormValidation.ok();
        }
    }
}

