/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class UserSelector
implements Describable<UserSelector>,
Serializable {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    String selectedUserId;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public UserSelector(@CheckForNull String selectedUserId) {
        this.selectedUserId = Util.fixEmptyAndTrim((String)selectedUserId);
    }

    @CheckForNull
    public String getSelectedUserId() {
        return this.selectedUserId;
    }

    public Descriptor<UserSelector> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserSelector) {
            UserSelector cmp = (UserSelector)obj;
            return Objects.equals(this.selectedUserId, cmp.selectedUserId);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.selectedUserId != null ? this.selectedUserId.hashCode() : 0);
        return hash;
    }

    public static class DescriptorImpl
    extends Descriptor<UserSelector> {
        public String getDisplayName() {
            return "N/A";
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckSelectedUserId(@QueryParameter String selectedUserId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            selectedUserId = Util.fixEmptyAndTrim((String)selectedUserId);
            if (selectedUserId == null) {
                return FormValidation.error((String)"Field is empty");
            }
            User user = User.getById((String)selectedUserId, (boolean)false);
            if (user == null) {
                return FormValidation.warning((String)("User " + selectedUserId + " is not registered in Jenkins"));
            }
            return FormValidation.ok();
        }
    }
}

