/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.dao.DataAccessException;

public class GroupSelector
implements Describable<GroupSelector>,
Serializable {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    String selectedGroupId;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public GroupSelector(@CheckForNull String selectedGroupId) {
        this.selectedGroupId = Util.fixEmptyAndTrim((String)selectedGroupId);
    }

    @CheckForNull
    public String getSelectedGroupId() {
        return this.selectedGroupId;
    }

    public Descriptor<GroupSelector> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupSelector) {
            GroupSelector cmp = (GroupSelector)obj;
            return Objects.equals(this.selectedGroupId, cmp.selectedGroupId);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.selectedGroupId != null ? this.selectedGroupId.hashCode() : 0);
        return hash;
    }

    public static class DescriptorImpl
    extends Descriptor<GroupSelector> {
        public String getDisplayName() {
            return "N/A";
        }

        @RequirePOST
        public FormValidation doCheckSelectedGroupId(@QueryParameter String selectedGroupId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            selectedGroupId = Util.fixEmptyAndTrim((String)selectedGroupId);
            SecurityRealm sr = Jenkins.get().getSecurityRealm();
            String eSelectedGroupId = Functions.escape((String)selectedGroupId);
            if (selectedGroupId == null) {
                return FormValidation.error((String)"Field is empty");
            }
            if (selectedGroupId.equals("authenticated")) {
                return FormValidation.ok();
            }
            try {
                GroupDetails details = sr.loadGroupByGroupname(selectedGroupId);
                if (details == null) {
                    return FormValidation.warning((String)("Group " + selectedGroupId + " is not registered in Jenkins"));
                }
                return FormValidation.ok();
            }
            catch (UserMayOrMayNotExistException e) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)eSelectedGroupId);
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
            }
            catch (DataAccessException dataAccessException) {
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
            return FormValidation.warning((String)("Group " + selectedGroupId + " is not registered in Jenkins"));
        }
    }
}

