/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.logic;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.ArrayList;
import org.kohsuke.stapler.DataBoundConstructor;

public class MultipleOrJobRestriction
extends JobRestriction {
    private static final long serialVersionUID = 1L;
    private final ArrayList<JobRestriction> restrictions;

    @DataBoundConstructor
    public MultipleOrJobRestriction(ArrayList<JobRestriction> restrictions) {
        this.restrictions = restrictions != null ? restrictions : new ArrayList();
    }

    public ArrayList<JobRestriction> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public boolean canTake(Run run) {
        for (JobRestriction restriction : this.restrictions) {
            if (!restriction.canTake(run)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canTake(Queue.BuildableItem item) {
        for (JobRestriction restriction : this.restrictions) {
            if (!restriction.canTake(item)) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.restrictions_Logic_Or() + " " + Messages.restirctions_Stuff_MultipleSuffix();
        }
    }
}

