/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job.AbstractUserCauseRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util.GroupSelector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.User;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="XStream does actually need serialization, the code needs refactoring in 1.0")
public class StartedByMemberOfGroupRestriction
extends AbstractUserCauseRestriction {
    private final List<GroupSelector> groupList;
    private transient Set<String> acceptedGroups = null;

    @DataBoundConstructor
    public StartedByMemberOfGroupRestriction(List<GroupSelector> groupList, boolean checkUpstreamProjects) {
        super(checkUpstreamProjects);
        this.groupList = groupList;
    }

    public List<GroupSelector> getGroupList() {
        return this.groupList;
    }

    @NonNull
    private synchronized Set<String> getAcceptedGroups() {
        if (this.acceptedGroups == null) {
            List<GroupSelector> selectors = this.getGroupList();
            this.acceptedGroups = new HashSet<String>(selectors.size());
            for (GroupSelector selector : selectors) {
                this.acceptedGroups.add(selector.getSelectedGroupId());
            }
        }
        return this.acceptedGroups;
    }

    @Override
    protected boolean acceptsUser(@CheckForNull String userId) {
        if (userId == null) {
            return false;
        }
        List<String> authorities = StartedByMemberOfGroupRestriction.getAuthorities(userId);
        if (authorities == null) {
            return false;
        }
        Set<String> allowedGroups = this.getAcceptedGroups();
        for (String groupId : authorities) {
            if (!allowedGroups.contains(groupId)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static List<String> getAuthorities(@NonNull String userId) {
        User usr = User.getById((String)userId, (boolean)false);
        if (usr == null) {
            return StartedByMemberOfGroupRestriction.getAuthoritiesFromRealm(userId);
        }
        List authorities = usr.getAuthorities();
        if (authorities.isEmpty()) {
            return StartedByMemberOfGroupRestriction.getAuthoritiesFromRealm(userId);
        }
        return authorities;
    }

    @CheckForNull
    private static List<String> getAuthoritiesFromRealm(@NonNull String userId) {
        Jenkins instance = Jenkins.get();
        UserDetails userDetails = null;
        try {
            SecurityRealm sr = instance.getSecurityRealm();
            userDetails = sr.loadUserByUsername(userId);
        }
        catch (UsernameNotFoundException | DataAccessException sr) {
            // empty catch block
        }
        if (userDetails == null) {
            return null;
        }
        GrantedAuthority[] authorities = userDetails.getAuthorities();
        ArrayList<String> authorityList = new ArrayList<String>(authorities.length);
        for (GrantedAuthority auth : authorities) {
            authorityList.add(auth.getAuthority());
        }
        return authorityList;
    }

    @Extension
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.restrictions_Job_StartedByMemberOfGroupRestriction_displayName();
        }
    }
}

