/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.jobs;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.jobs.JobRestrictionPropertyConfig;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobRestrictionProperty
extends JobProperty {
    @CheckForNull
    JobRestrictionPropertyConfig config;

    @DataBoundConstructor
    public JobRestrictionProperty(JobRestrictionPropertyConfig config) {
        this.config = config;
    }

    @CheckForNull
    public JobRestrictionPropertyConfig getConfig() {
        return this.config;
    }

    public boolean prebuild(AbstractBuild build, BuildListener listener) {
        for (Object cause : build.getCauses()) {
            try {
                this.validateCause((Cause)cause, listener);
            }
            catch (AbortException ex) {
                String message = "[Job Restrictions] - Build will be aborted: " + ex.getMessage();
                listener.fatalError(message);
                return false;
            }
        }
        return true;
    }

    private void validateCause(Cause cause, BuildListener listener) throws AbortException {
        if (this.config != null) {
            this.config.validateCause(cause, listener);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.jobs_JobRestrictionProperty_DisplayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }
    }
}

