/*
 * Decompiled with CFR 0.152.
 */
package com.mig82.folders.wrappers;

import com.mig82.folders.Messages;
import com.mig82.folders.properties.PropertiesLoader;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParentFolderBuildWrapper
extends SimpleBuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(ParentFolderBuildWrapper.class.getName());

    @DataBoundConstructor
    public ParentFolderBuildWrapper() {
    }

    protected boolean runPreCheckout() {
        return true;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        Job job = run.getParent();
        EnvVars envVars = PropertiesLoader.loadFolderProperties(job);
        Map env = context.getEnv();
        for (Map.Entry entry : envVars.entrySet()) {
            String key = (String)entry.getKey();
            if (env.containsKey(key)) continue;
            env.put(key, (String)entry.getValue());
        }
        LOGGER.log(Level.FINE, "Context env is: {0}", context.getEnv().toString());
    }

    @Symbol(value={"withFolderProperties"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.display_build_wrapper();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            LOGGER.log(Level.FINER, "Folder build wrapper is applicable to: {0}\n", item.getDisplayName());
            return true;
        }
    }
}

