/*
 * Decompiled with CFR 0.152.
 */
package com.mig82.folders.properties;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.mig82.folders.properties.FolderProperties;
import com.mig82.folders.properties.StringProperty;
import hudson.EnvVars;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class PropertiesLoader {
    private static final Logger LOGGER = Logger.getLogger(PropertiesLoader.class.getName());

    public static EnvVars loadFolderProperties(Job job) {
        LOGGER.log(Level.FINER, "1. Searching for folder properties in ancestors of: {0}\n", job.getDisplayName());
        ItemGroup parent = job.getParent();
        EnvVars envVars = new EnvVars();
        while (parent != null) {
            if (parent instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)parent;
                LOGGER.log(Level.FINEST, "2. Searching for folder properties in: {0}\n", parent.getDisplayName());
                FolderProperties folderProperties = (FolderProperties)folder.getProperties().get(FolderProperties.class);
                if (folderProperties != null) {
                    StringProperty[] newlyFoundProperties = folderProperties.getProperties();
                    LOGGER.log(Level.FINER, "3. Found {0} folder properties in {1}\n", new Object[]{newlyFoundProperties.length, parent.getDisplayName()});
                    for (StringProperty property : newlyFoundProperties) {
                        if (envVars.get((Object)property.getKey()) == null) {
                            LOGGER.log(Level.FINEST, "4. Adding ({0}, {1}) to the context env", new Object[]{property.getKey(), property.getValue()});
                            envVars.put(property.getKey(), property.getValue());
                            continue;
                        }
                        LOGGER.log(Level.FINEST, "4. Will not add duplicate property {0} to the context env", new Object[]{property.getKey()});
                    }
                    LOGGER.log(Level.FINEST, "5. Context env: {0}", envVars.toString());
                }
            } else if (parent instanceof Jenkins) {
                LOGGER.log(Level.FINEST, "2. Reached Jenkins root. Stopping search\n");
            } else {
                LOGGER.log(Level.WARNING, "2. Unknown parent type: {0} of class {1}\n", new Object[]{parent.getDisplayName(), parent.getClass().getName()});
            }
            if (parent instanceof Item) {
                Item item = (Item)parent;
                parent = item.getParent();
                continue;
            }
            parent = null;
        }
        LOGGER.log(Level.FINE, "6. Context env is: {0}", envVars.toString());
        return envVars;
    }
}

