/*
 * Decompiled with CFR 0.152.
 */
package com.lookout.jenkins;

import com.lookout.jenkins.EnvironmentPluginAction;
import com.lookout.jenkins.Messages;
import com.lookout.jenkins.PersistedEnvironment;
import com.lookout.jenkins.commands.Commands;
import com.lookout.jenkins.commands.PowerShell;
import com.lookout.jenkins.commands.Shebangs;
import com.lookout.jenkins.commands.UnixShell;
import com.lookout.jenkins.commands.WinBatch;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ListBoxModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class EnvironmentScript
extends BuildWrapper
implements MatrixAggregatable {
    private final String script;
    private final String scriptType;
    private final boolean runOnlyOnParent;
    private final boolean hideEnvironmentVariablesValues;

    @DataBoundConstructor
    public EnvironmentScript(String script, String scriptType, boolean runOnlyOnParent, boolean hideEnvironmentVariablesValues) {
        this.script = script;
        this.scriptType = scriptType;
        this.runOnlyOnParent = runOnlyOnParent;
        this.hideEnvironmentVariablesValues = hideEnvironmentVariablesValues;
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public boolean isRunOnlyOnParent() {
        return this.runOnlyOnParent;
    }

    public boolean isHideEnvironmentVariablesValues() {
        return this.hideEnvironmentVariablesValues;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (build instanceof MatrixRun && this.isRunOnlyOnParent()) {
            MatrixBuild parent = ((MatrixRun)build).getParentBuild();
            if (parent != null) {
                PersistedEnvironment persisted = (PersistedEnvironment)parent.getAction(PersistedEnvironment.class);
                if (persisted != null) {
                    return persisted.getEnvironment();
                }
                listener.error("[environment-script] Unable to load persisted environment from matrix parent job, not injecting any variables");
                return new BuildWrapper.Environment(){};
            }
            return this.generateEnvironment(build, launcher, listener);
        }
        return this.generateEnvironment(build, launcher, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildWrapper.Environment generateEnvironment(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath ws = build.getWorkspace();
        FilePath scriptFile = null;
        if (ws == null) {
            listener.error(Messages.EnvironmentScriptWrapper_WorkspaceIsNull());
            return null;
        }
        ByteArrayOutputStream commandOutput = new ByteArrayOutputStream();
        int returnCode = -1;
        try {
            String extension = ".sh";
            if ("powerShell".equals(this.scriptType)) {
                extension = ".ps1";
            } else if ("batchScript".equals(this.scriptType)) {
                extension = ".bat";
            }
            String prefix = "env-" + build.getProject().getName().replace("=", "_");
            scriptFile = ws.createTextTempFile(prefix, extension, this.script, false);
            returnCode = launcher.launch().cmds(this.buildCommandLine(scriptFile)).envs((Map)build.getEnvironment((TaskListener)listener)).stderr((OutputStream)listener.getLogger()).stdout((OutputStream)commandOutput).pwd(ws).join();
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.EnvironmentScriptWrapper_UnableToProduceScript()));
            BuildWrapper.Environment prefix = null;
            return prefix;
        }
        finally {
            if (scriptFile != null && scriptFile.exists()) {
                scriptFile.delete();
            }
        }
        if (returnCode != 0) {
            listener.fatalError(Messages.EnvironmentScriptWrapper_UnableToExecuteScript(returnCode));
            return null;
        }
        ByteArrayInputStream propertiesInput = new ByteArrayInputStream(commandOutput.toByteArray());
        InputStreamReader propertiesInputReader = new InputStreamReader((InputStream)propertiesInput, "UTF-8");
        Properties properties = new Properties();
        try {
            properties.load(propertiesInputReader);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.EnvironmentScriptWrapper_UnableToParseScriptOutput()));
            return null;
        }
        final HashMap<String, String> envAdditions = new HashMap<String, String>();
        final HashMap<String, String> envOverrides = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            StringBuilder output = new StringBuilder();
            output.append("[environment-script] Adding variable '").append(key).append("'");
            if (!this.isHideEnvironmentVariablesValues()) {
                output.append(" with value '").append(value).append("'");
            }
            listener.getLogger().println(output.toString());
            if (key.indexOf(43) > 0) {
                envOverrides.put(key, value);
                continue;
            }
            envAdditions.put(key, value);
        }
        build.addAction((Action)new EnvironmentPluginAction(envAdditions, envOverrides));
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                EnvVars envVars = new EnvVars(env);
                envVars.putAll(envAdditions);
                envVars.overrideAll(envOverrides);
                env.putAll((Map<String, String>)envVars);
            }
        };
    }

    public String[] buildCommandLine(FilePath scriptFile) {
        if ("powerShell".equals(this.scriptType)) {
            return PowerShell.buildCommandLine(scriptFile);
        }
        if ("batchScript".equals(this.scriptType)) {
            return WinBatch.buildCommandLine(scriptFile);
        }
        if (Commands.isShebangs(this.script)) {
            return Shebangs.parseCommandLine(this.script, scriptFile);
        }
        return UnixShell.buildCommandLine(scriptFile);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        if (!this.isRunOnlyOnParent()) {
            return null;
        }
        return new MatrixAggregator(build, launcher, listener){

            public boolean startBuild() throws InterruptedException, IOException {
                BuildWrapper.Environment env = EnvironmentScript.this.generateEnvironment((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                if (env == null) {
                    return false;
                }
                this.build.addAction((Action)new PersistedEnvironment(env));
                this.build.getEnvironments().add((Object)env);
                return true;
            }
        };
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return super.getDescriptor();
    }

    @Extension
    public static final class EnvironmentScriptDescriptor
    extends BuildWrapperDescriptor {
        public EnvironmentScriptDescriptor() {
            super(EnvironmentScript.class);
            this.load();
        }

        public String getDisplayName() {
            return "Generate environment variables from script";
        }

        public boolean isApplicable(AbstractProject<?, ?> project) {
            return true;
        }

        public boolean isMatrix(StaplerRequest request) {
            return Boolean.FALSE;
        }

        public ListBoxModel doFillScriptTypeItems() {
            ListBoxModel items = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("Unix script", "unixScript"), new ListBoxModel.Option("Batch script", "batchScript"), new ListBoxModel.Option("Powershell script", "powerShell")});
            return items;
        }
    }
}

