// CHECKSTYLE:OFF

package com.lookout.jenkins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code EnvironmentScriptWrapper.UnableToParseScriptOutput}: {@code
     * Unable to parse output from script}.
     * 
     * @return
     *     {@code Unable to parse output from script}
     */
    public static String EnvironmentScriptWrapper_UnableToParseScriptOutput() {
        return holder.format("EnvironmentScriptWrapper.UnableToParseScriptOutput");
    }

    /**
     * Key {@code EnvironmentScriptWrapper.UnableToParseScriptOutput}: {@code
     * Unable to parse output from script}.
     * 
     * @return
     *     {@code Unable to parse output from script}
     */
    public static Localizable _EnvironmentScriptWrapper_UnableToParseScriptOutput() {
        return new Localizable(holder, "EnvironmentScriptWrapper.UnableToParseScriptOutput");
    }

    /**
     * Key {@code EnvironmentScriptWrapper.UnableToProduceScript}: {@code
     * Unable to produce a script file}.
     * 
     * @return
     *     {@code Unable to produce a script file}
     */
    public static String EnvironmentScriptWrapper_UnableToProduceScript() {
        return holder.format("EnvironmentScriptWrapper.UnableToProduceScript");
    }

    /**
     * Key {@code EnvironmentScriptWrapper.UnableToProduceScript}: {@code
     * Unable to produce a script file}.
     * 
     * @return
     *     {@code Unable to produce a script file}
     */
    public static Localizable _EnvironmentScriptWrapper_UnableToProduceScript() {
        return new Localizable(holder, "EnvironmentScriptWrapper.UnableToProduceScript");
    }

    /**
     * Key {@code EnvironmentScriptWrapper.WorkspaceIsNull}: {@code Workspace
     * is null. Cannot generate environment}.
     * 
     * @return
     *     {@code Workspace is null. Cannot generate environment}
     */
    public static String EnvironmentScriptWrapper_WorkspaceIsNull() {
        return holder.format("EnvironmentScriptWrapper.WorkspaceIsNull");
    }

    /**
     * Key {@code EnvironmentScriptWrapper.WorkspaceIsNull}: {@code Workspace
     * is null. Cannot generate environment}.
     * 
     * @return
     *     {@code Workspace is null. Cannot generate environment}
     */
    public static Localizable _EnvironmentScriptWrapper_WorkspaceIsNull() {
        return new Localizable(holder, "EnvironmentScriptWrapper.WorkspaceIsNull");
    }

    /**
     * Key {@code EnvironmentScriptWrapper.UnableToExecuteScript}: {@code
     * Unable to execute script, return code {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to execute script, return code {0}}
     */
    public static String EnvironmentScriptWrapper_UnableToExecuteScript(Object arg0) {
        return holder.format("EnvironmentScriptWrapper.UnableToExecuteScript", arg0);
    }

    /**
     * Key {@code EnvironmentScriptWrapper.UnableToExecuteScript}: {@code
     * Unable to execute script, return code {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to execute script, return code {0}}
     */
    public static Localizable _EnvironmentScriptWrapper_UnableToExecuteScript(Object arg0) {
        return new Localizable(holder, "EnvironmentScriptWrapper.UnableToExecuteScript", arg0);
    }

}
