/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.dubture.jenkins.digitalocean.DigitalOcean;
import com.dubture.jenkins.digitalocean.DigitalOceanCloud;
import com.dubture.jenkins.digitalocean.DigitalOceanComputerLauncher;
import com.dubture.jenkins.digitalocean.DropletName;
import com.dubture.jenkins.digitalocean.RetentionStrategy;
import com.dubture.jenkins.digitalocean.Slave;
import com.google.common.base.Strings;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Image;
import com.myjeeva.digitalocean.pojo.Key;
import com.myjeeva.digitalocean.pojo.Region;
import com.myjeeva.digitalocean.pojo.Size;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SlaveTemplate
implements Describable<SlaveTemplate> {
    private final String name;
    private final String labelString;
    private final int idleTerminationInMinutes;
    private final int numExecutors;
    private final String labels;
    private final Boolean labellessJobsAllowed;
    private final String imageId;
    private final String sizeId;
    private final String regionId;
    private final String username;
    private final String workspacePath;
    private final Integer sshPort;
    private final Boolean setupPrivateNetworking;
    private final Integer instanceCap;
    private final Boolean installMonitoringAgent;
    private final String tags;
    private final String userData;
    private final String initScript;
    private final boolean oneShot;
    private transient Set<LabelAtom> labelSet;
    private static final Logger LOGGER = Logger.getLogger(SlaveTemplate.class.getName());

    @DataBoundConstructor
    public SlaveTemplate(String name, String imageId, String sizeId, String regionId, String username, String workspacePath, Integer sshPort, Boolean setupPrivateNetworking, String idleTerminationInMinutes, String numExecutors, String labelString, Boolean labellessJobsAllowed, String instanceCap, Boolean installMonitoring, String tags, String userData, String initScript, Boolean oneShot) {
        LOGGER.log(Level.INFO, "Creating SlaveTemplate with imageId = {0}, sizeId = {1}, regionId = {2}", new Object[]{imageId, sizeId, regionId});
        this.name = name;
        this.imageId = imageId;
        this.sizeId = sizeId;
        this.regionId = regionId;
        this.username = username;
        this.workspacePath = workspacePath;
        this.sshPort = sshPort;
        if (setupPrivateNetworking == null) {
            LOGGER.log(Level.WARNING, "Private networking configuration not set for Slavetemplate with imageid = {0}", new Object[]{imageId});
            this.setupPrivateNetworking = false;
        } else {
            this.setupPrivateNetworking = setupPrivateNetworking;
        }
        this.idleTerminationInMinutes = SlaveTemplate.tryParseInteger(idleTerminationInMinutes, 10);
        this.numExecutors = SlaveTemplate.tryParseInteger(numExecutors, 1);
        this.labelString = labelString;
        this.labellessJobsAllowed = labellessJobsAllowed;
        this.labels = Util.fixNull((String)labelString);
        this.instanceCap = Integer.parseInt(instanceCap);
        this.installMonitoringAgent = installMonitoring;
        this.tags = tags;
        this.userData = userData;
        this.initScript = initScript;
        this.oneShot = oneShot != null ? oneShot : false;
        this.readResolve();
    }

    public boolean isInstanceCapReachedLocal(String cloudName) {
        if (this.instanceCap == 0) {
            return false;
        }
        LOGGER.log(Level.INFO, "agent limit check");
        int count = 0;
        List nodes = Jenkins.get().getNodes();
        for (Node n : nodes) {
            if (!DropletName.isDropletInstanceOfSlave(n.getDisplayName(), cloudName, this.name)) continue;
            ++count;
        }
        return count >= this.instanceCap;
    }

    public boolean isInstanceCapReachedRemote(List<Droplet> droplets, String cloudName) throws DigitalOceanException {
        LOGGER.log(Level.INFO, "agent limit check");
        int count = 0;
        for (Droplet droplet : droplets) {
            if (!droplet.isActive() && !droplet.isNew() || !DropletName.isDropletInstanceOfSlave(droplet.getName(), cloudName, this.name)) continue;
            ++count;
        }
        return count >= this.instanceCap;
    }

    public Slave provision(ProvisioningActivity.Id provisioningId, String dropletName, String cloudName, String authToken, String privateKey, Integer sshKeyId, List<Droplet> droplets, Boolean usePrivateNetworking) throws IOException, RequestUnsuccessfulException, Descriptor.FormException {
        LOGGER.log(Level.INFO, "Provisioning agent...");
        try {
            LOGGER.log(Level.INFO, "Starting to provision digital ocean droplet using image: {0}, sizeId = {1}, regionId = {2}", new Object[]{this.imageId, this.sizeId, this.regionId});
            if (this.isInstanceCapReachedLocal(cloudName) || this.isInstanceCapReachedRemote(droplets, cloudName)) {
                String msg = String.format("instance cap reached for %s in %s", dropletName, cloudName);
                LOGGER.log(Level.INFO, msg);
                throw new AssertionError((Object)msg);
            }
            if (usePrivateNetworking == null) {
                LOGGER.log(Level.WARNING, "Private networking usage not set for Slavetemplate with imageid = {0}", new Object[]{this.imageId});
                usePrivateNetworking = false;
            }
            Droplet droplet = new Droplet();
            droplet.setName(dropletName);
            droplet.setSize(this.sizeId);
            droplet.setRegion(new Region(this.regionId));
            droplet.setImage(DigitalOcean.newImage(this.imageId));
            droplet.setKeys(Collections.singletonList(new Key(sshKeyId)));
            droplet.setInstallMonitoring(this.installMonitoringAgent);
            droplet.setEnablePrivateNetworking(Boolean.valueOf(usePrivateNetworking != null && usePrivateNetworking != false || this.setupPrivateNetworking != null && this.setupPrivateNetworking != false));
            droplet.setTags(Arrays.asList(Util.tokenize((String)Util.fixNull((String)this.tags))));
            if (this.userData != null && !this.userData.trim().isEmpty()) {
                droplet.setUserData(this.userData);
            }
            LOGGER.log(Level.INFO, "Creating agent with new droplet " + dropletName);
            DigitalOceanClient apiClient = new DigitalOceanClient(authToken);
            Droplet createdDroplet = apiClient.createDroplet(droplet);
            return this.newSlave(provisioningId, cloudName, createdDroplet, privateKey);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = String.format("Unexpected error raised during provisioning of %s:%n%s", dropletName, e.getMessage());
            LOGGER.log(Level.WARNING, msg, e);
            throw new AssertionError((Object)msg);
        }
    }

    private Slave newSlave(ProvisioningActivity.Id provisioningId, String cloudName, Droplet droplet, String privateKey) throws IOException, Descriptor.FormException {
        LOGGER.log(Level.INFO, "Creating new agent...");
        return new Slave(provisioningId, cloudName, droplet.getName(), "DigitalOceanComputer running on DigitalOcean with name: " + droplet.getName(), droplet.getId(), privateKey, this.username, this.workspacePath, this.sshPort, this.numExecutors, this.idleTerminationInMinutes, this.labels, new DigitalOceanComputerLauncher(), (hudson.slaves.RetentionStrategy)new RetentionStrategy(this.idleTerminationInMinutes, this.oneShot), Collections.emptyList(), Util.fixNull((String)this.initScript), this.oneShot);
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public String getName() {
        return this.name;
    }

    public String getSizeId() {
        return this.sizeId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public boolean isLabellessJobsAllowed() {
        return this.labellessJobsAllowed;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public int getIdleTerminationInMinutes() {
        return this.idleTerminationInMinutes;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public boolean isInstallMonitoring() {
        return this.installMonitoringAgent;
    }

    public String getTags() {
        return this.tags;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public boolean isSetupPrivateNetworking() {
        return this.setupPrivateNetworking;
    }

    private static int tryParseInteger(String integerString, int defaultValue) {
        try {
            return Integer.parseInt(integerString);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Invalid integer {0}, defaulting to {1}", new Object[]{integerString, defaultValue});
            return defaultValue;
        }
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labels);
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SlaveTemplate> {
        @NonNull
        public String getDisplayName() {
            return "DigitalOcean Agent Template";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                return FormValidation.error((String)"Must be set");
            }
            if (!DropletName.isValidSlaveName(name)) {
                return FormValidation.error((String)"Must consist of A-Z, a-z, 0-9 and . symbols");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            if (Strings.isNullOrEmpty((String)username)) {
                return FormValidation.error((String)"Must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWorkspacePath(@QueryParameter String workspacePath) {
            if (Strings.isNullOrEmpty((String)workspacePath)) {
                return FormValidation.error((String)"Must be set");
            }
            return FormValidation.ok();
        }

        private static FormValidation doCheckNonNegativeNumber(String stringNumber) {
            int number;
            if (Strings.isNullOrEmpty((String)stringNumber)) {
                return FormValidation.error((String)"Must be set");
            }
            try {
                number = Integer.parseInt(stringNumber);
            }
            catch (Exception e) {
                return FormValidation.error((String)"Must be a number");
            }
            if (number < 0) {
                return FormValidation.error((String)"Must be a non-negative number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSshPort(@QueryParameter String sshPort) {
            return DescriptorImpl.doCheckNonNegativeNumber(sshPort);
        }

        public FormValidation doCheckNumExecutors(@QueryParameter String numExecutors) {
            int number;
            if (Strings.isNullOrEmpty((String)numExecutors)) {
                return FormValidation.error((String)"Must be set");
            }
            try {
                number = Integer.parseInt(numExecutors);
            }
            catch (Exception e) {
                return FormValidation.error((String)"Must be a number");
            }
            if (number <= 0) {
                return FormValidation.error((String)"Must be a positive number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIdleTerminationInMinutes(@QueryParameter String idleTerminationInMinutes) {
            if (Strings.isNullOrEmpty((String)idleTerminationInMinutes)) {
                return FormValidation.error((String)"Must be set");
            }
            try {
                Integer.parseInt(idleTerminationInMinutes);
            }
            catch (Exception e) {
                return FormValidation.error((String)"Must be a number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInstanceCap(@QueryParameter String instanceCap) {
            return DescriptorImpl.doCheckNonNegativeNumber(instanceCap);
        }

        public FormValidation doCheckSizeId(@RelativePath(value="..") @QueryParameter String authTokenCredentialId) {
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId);
            return DigitalOceanCloud.DescriptorImpl.doCheckAuthToken(authToken);
        }

        public FormValidation doCheckImageId(@RelativePath(value="..") @QueryParameter String authTokenCredentialId) {
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId);
            return DigitalOceanCloud.DescriptorImpl.doCheckAuthToken(authToken);
        }

        public FormValidation doCheckRegionId(@RelativePath(value="..") @QueryParameter String authTokenCredentialId) {
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId);
            return DigitalOceanCloud.DescriptorImpl.doCheckAuthToken(authToken);
        }

        public ListBoxModel doFillSizeIdItems(@RelativePath(value="..") @QueryParameter String authTokenCredentialId) throws Exception {
            ListBoxModel model = new ListBoxModel();
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId);
            if (StringUtils.isBlank((CharSequence)authToken)) {
                return model;
            }
            List<Size> availableSizes = DigitalOcean.getAvailableSizes(authToken);
            for (Size size : availableSizes) {
                model.add(DigitalOcean.buildSizeLabel(size), size.getSlug());
            }
            return model;
        }

        public ListBoxModel doFillImageIdItems(@RelativePath(value="..") @QueryParameter String authTokenCredentialId) throws Exception {
            ListBoxModel model = new ListBoxModel();
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId);
            if (StringUtils.isBlank((CharSequence)authToken)) {
                return model;
            }
            SortedMap<String, Image> availableImages = DigitalOcean.getAvailableImages(DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId));
            for (Map.Entry<String, Image> entry : availableImages.entrySet()) {
                Image image = entry.getValue();
                String value = DigitalOcean.getImageIdentifier(image);
                model.add(entry.getKey(), value);
            }
            return model;
        }

        public ListBoxModel doFillRegionIdItems(@RelativePath(value="..") @QueryParameter String authTokenCredentialId) throws Exception {
            ListBoxModel model = new ListBoxModel();
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId);
            if (StringUtils.isBlank((CharSequence)authToken)) {
                return model;
            }
            List<Region> availableSizes = DigitalOcean.getAvailableRegions(DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId));
            for (Region region : availableSizes) {
                model.add(region.getName(), region.getSlug());
            }
            return model;
        }
    }
}

