/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.dubture.jenkins.digitalocean.DigitalOceanComputer;
import com.dubture.jenkins.digitalocean.Messages;
import com.dubture.jenkins.digitalocean.Slave;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.slaves.CloudSlaveRetentionStrategy;
import hudson.slaves.OfflineCause;
import java.util.concurrent.TimeUnit;
import org.jvnet.localizer.Localizable;

public class RetentionStrategy
extends CloudSlaveRetentionStrategy<DigitalOceanComputer> {
    private final int idleTerminationTime;
    private final boolean oneShot;

    public RetentionStrategy(int idleTerminationTime, boolean oneShot) {
        this.idleTerminationTime = idleTerminationTime;
        this.oneShot = oneShot;
    }

    public void start(DigitalOceanComputer digitalOceanComputer) {
        digitalOceanComputer.connect(false);
    }

    protected long checkCycle() {
        return this.idleTerminationTime < 0 || this.oneShot ? 6L : 60L;
    }

    protected boolean isIdleForTooLong(DigitalOceanComputer digitalOceanComputer) {
        Slave node = (Slave)digitalOceanComputer.getNode();
        if (node == null) {
            return false;
        }
        int idleTerminationTime = node.getIdleTerminationTime();
        if (node.isOneShot()) {
            if (!digitalOceanComputer.isTemporarilyOffline()) {
                digitalOceanComputer.setTemporarilyOffline(true, OfflineCause.create((Localizable)Messages.__OneShot_OfflineCause()));
            }
            return digitalOceanComputer.isIdle();
        }
        if (idleTerminationTime == 0) {
            return false;
        }
        if (idleTerminationTime > 0) {
            return System.currentTimeMillis() - digitalOceanComputer.getIdleStartMilliseconds() > TimeUnit.MINUTES.toMillis(idleTerminationTime);
        }
        return digitalOceanComputer.isIdle();
    }

    private static class DescriptorImpl
    extends Descriptor<hudson.slaves.RetentionStrategy<?>> {
        private DescriptorImpl() {
        }

        @NonNull
        public String getDisplayName() {
            return "DigitalOcean";
        }
    }
}

