/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.dubture.jenkins.digitalocean.DigitalOcean;
import com.dubture.jenkins.digitalocean.DigitalOceanCloud;
import com.dubture.jenkins.digitalocean.DigitalOceanComputer;
import com.dubture.jenkins.digitalocean.Slave;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Network;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

public class DigitalOceanComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DigitalOceanCloud.class.getName());
    private static final List<String> VALID_VERSIONS = Stream.concat(Stream.of(String.valueOf(Runtime.version().feature())), Stream.of("21", "17", "11")).toList();
    private static final List<JavaInstaller> INSTALLERS = Arrays.asList(new JavaInstaller(){

        @Override
        protected String getInstallCommand(String javaVersion) {
            return "yum install -y " + this.getPackageName(javaVersion);
        }

        @Override
        protected String checkPackageManager() {
            return "which yum";
        }

        private String getPackageName(String javaVersion) {
            return "java-" + javaVersion + "-openjdk-headless";
        }
    }, new JavaInstaller(){

        @Override
        protected String getInstallCommand(String javaVersion) {
            return "apt-get update -q && apt-get install -y " + this.getPackageName(javaVersion);
        }

        @Override
        protected String checkPackageManager() {
            return "which apt-get";
        }

        private String getPackageName(String javaVersion) {
            return "openjdk-" + javaVersion + "-jre-headless";
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(SlaveComputer _computer, TaskListener listener) {
        PrintStream logger = listener.getLogger();
        if (!(_computer instanceof DigitalOceanComputer)) {
            logger.println("Cannot handle agent not instance of digital ocean digitalOceanComputer.");
            return;
        }
        DigitalOceanComputer digitalOceanComputer = (DigitalOceanComputer)_computer;
        Date startDate = new Date();
        logger.println("Start time: " + this.getUtcDate(startDate));
        Connection cleanupConn = null;
        boolean successful = false;
        Slave node = (Slave)digitalOceanComputer.getNode();
        if (node == null) {
            logger.println("No real node is available. ABORT");
            return;
        }
        try {
            Connection conn;
            cleanupConn = conn = this.connectToSsh(digitalOceanComputer, logger);
            logger.println("Authenticating as " + digitalOceanComputer.getRemoteAdmin());
            if (!conn.authenticateWithPublicKey(digitalOceanComputer.getRemoteAdmin(), node.getPrivateKey().toCharArray(), "")) {
                logger.println("Authentication failed");
                throw new Exception("Authentication failed");
            }
            SCPClient scp = conn.createSCPClient();
            if (!this.runInitScript(digitalOceanComputer, logger, conn, scp)) {
                LOGGER.severe("Failed to launch: Init script failed to run " + digitalOceanComputer.getName());
                throw new Exception("Init script failed.");
            }
            if (!this.waitForCloudInit(logger, conn)) {
                LOGGER.severe("Failed to launch: Init script waiting failed " + digitalOceanComputer.getName());
                throw new Exception("Init script waiting failed.");
            }
            if (!this.installJava(logger, conn)) {
                LOGGER.severe("Failed to launch: java installation failed to run " + digitalOceanComputer.getName());
                throw new Exception("Installing java failed.");
            }
            logger.println("Copying agent.jar");
            scp.put(Jenkins.get().getJnlpJars("agent.jar").readFully(), "agent.jar", "/tmp");
            String jvmOpts = Util.fixNull((String)node.getJvmOpts());
            String launchString = "java " + jvmOpts + " -jar /tmp/agent.jar";
            logger.println("Launching agent agent: " + launchString);
            final Session sess = conn.openSession();
            sess.execCommand(launchString);
            digitalOceanComputer.setChannel(sess.getStdout(), sess.getStdin(), logger, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    sess.close();
                    conn.close();
                }
            });
            successful = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            try {
                Jenkins.get().removeNode((Node)node);
            }
            catch (Exception ee) {
                ee.printStackTrace(logger);
            }
            e.printStackTrace(logger);
        }
        finally {
            Date endDate = new Date();
            logger.println("Done setting up at: " + this.getUtcDate(endDate));
            logger.println("Done in " + TimeUnit.MILLISECONDS.toSeconds(endDate.getTime() - startDate.getTime()) + " seconds");
            if (cleanupConn != null && !successful) {
                cleanupConn.close();
            }
        }
    }

    private boolean runInitScript(DigitalOceanComputer digitalOceanComputer, PrintStream logger, Connection conn, SCPClient scp) throws IOException, InterruptedException {
        Slave node = (Slave)digitalOceanComputer.getNode();
        if (node == null) {
            return false;
        }
        String initScript = Util.fixEmptyAndTrim((String)node.getInitScript());
        if (initScript == null) {
            return true;
        }
        if (conn.exec("test -e ~/.hudson-run-init", (OutputStream)logger) == 0) {
            return true;
        }
        logger.println("Executing init script");
        scp.put(initScript.getBytes(StandardCharsets.UTF_8), "init.sh", "/tmp", "0700");
        Session session = conn.openSession();
        session.requestDumbPTY();
        session.execCommand("/tmp/init.sh");
        session.getStdin().close();
        session.getStderr().close();
        IOUtils.copy((InputStream)session.getStdout(), (OutputStream)logger);
        int exitStatus = this.waitCompletion(session);
        if (exitStatus != 0) {
            logger.println("init script failed: exit code=" + exitStatus);
            return false;
        }
        session.close();
        session = conn.openSession();
        session.requestDumbPTY();
        session.execCommand("touch ~/.hudson-run-init");
        session.close();
        return true;
    }

    private boolean waitForCloudInit(PrintStream logger, Connection conn) throws IOException, InterruptedException {
        logger.println("waiting for cloud init to finish");
        conn.exec("while [ ! -f /var/lib/cloud/instance/boot-finished ]; do echo 'Waiting for cloud-init...'; sleep 1; done", (OutputStream)logger);
        logger.println("cloud init is done");
        return true;
    }

    private boolean installJava(PrintStream logger, Connection conn) throws IOException, InterruptedException {
        logger.println("Verifying that java exists");
        int exitCode = conn.exec("java -fullversion", (OutputStream)logger);
        if (exitCode != 0) {
            logger.println("Try to install one of these Java-versions: " + String.valueOf(VALID_VERSIONS));
            logger.println("Trying to find a working package manager");
            for (JavaInstaller installer : INSTALLERS) {
                if (!installer.isUsable(conn, logger) || installer.installJava(conn, logger) != 0) continue;
                return true;
            }
            logger.println("Java could not be installed using any of the supported package managers");
            return false;
        }
        return true;
    }

    private Connection connectToSsh(DigitalOceanComputer digitalOceanComputer, PrintStream logger) throws RequestUnsuccessfulException, DigitalOceanException {
        long waitTime;
        long timeout = TimeUnit.MINUTES.toMillis(digitalOceanComputer.getCloud().getTimeoutMinutes().intValue());
        long startTime = System.currentTimeMillis();
        int sleepTime = digitalOceanComputer.getCloud().getConnectionRetryWait();
        while ((waitTime = System.currentTimeMillis() - startTime) < timeout) {
            Droplet droplet;
            DigitalOceanCloud cloud = digitalOceanComputer.getCloud();
            Slave node = (Slave)digitalOceanComputer.getNode();
            if (cloud == null || node == null) {
                logger.println("cloud or node are not available. Waiting for them to come up");
                DigitalOceanComputerLauncher.sleep(sleepTime);
                continue;
            }
            try {
                String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(cloud.getAuthTokenCredentialId());
                droplet = DigitalOcean.getDroplet(authToken, node.getDropletId());
            }
            catch (Exception e) {
                logger.println("Failed to get droplet. Retrying");
                DigitalOceanComputerLauncher.sleep(sleepTime);
                continue;
            }
            if (DigitalOceanComputerLauncher.isDropletStarting(droplet)) {
                logger.println("Waiting for droplet to enter ACTIVE state. Sleeping " + sleepTime + " seconds.");
            } else {
                try {
                    String host = DigitalOceanComputerLauncher.getIpAddress(digitalOceanComputer);
                    if (host == null || host.trim().isEmpty() || "0.0.0.0".equals(host)) {
                        logger.println("No ip address yet, your host is most likely waiting for an ip address.");
                    } else {
                        int port = digitalOceanComputer.getSshPort();
                        Connection conn = this.getDropletConnection(host, port, logger);
                        if (conn != null) {
                            return conn;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                logger.println("Waiting for SSH to come up. Sleeping " + sleepTime + " seconds.");
            }
            DigitalOceanComputerLauncher.sleep(sleepTime);
        }
        throw new RuntimeException(String.format("Timed out after %d seconds of waiting for ssh to become available (max timeout configured is %s)", waitTime / 1000L, timeout / 1000L));
    }

    private static boolean isDropletStarting(Droplet droplet) {
        switch (droplet.getStatus()) {
            case NEW: {
                return true;
            }
            case ACTIVE: {
                return false;
            }
        }
        throw new IllegalStateException("Droplet has unexpected status: " + String.valueOf(droplet.getStatus()));
    }

    protected Connection getDropletConnection(String host, int port, PrintStream logger) throws IOException {
        logger.println("Connecting to " + host + " on port " + port + ". ");
        Connection conn = new Connection(host, port);
        try {
            conn.connect(null, 10000, 10000);
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        logger.println("Connected via SSH.");
        return conn;
    }

    private static String getIpAddress(DigitalOceanComputer digitalOceanComputer) throws RequestUnsuccessfulException, DigitalOceanException {
        Droplet instance = digitalOceanComputer.updateInstanceDescription();
        String networkType = digitalOceanComputer.getCloud().getUsePrivateNetworking() != false ? "private" : "public";
        for (Network network : instance.getNetworks().getVersion4Networks()) {
            LOGGER.log(Level.INFO, "network {0} => {1}", new Object[]{network.getIpAddress(), network.getType()});
            if (!network.getType().equals(networkType)) continue;
            return network.getIpAddress();
        }
        return null;
    }

    private int waitCompletion(Session session) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(100L);
        }
        return -1;
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String getUtcDate(Date date) {
        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return utcFormat.format(date);
    }

    private static abstract class JavaInstaller {
        private JavaInstaller() {
        }

        protected abstract String getInstallCommand(String var1);

        protected abstract String checkPackageManager();

        protected boolean isUsable(Connection conn, PrintStream logger) throws IOException, InterruptedException {
            return this.checkCommand(conn, logger, this.checkPackageManager());
        }

        private boolean checkCommand(Connection conn, PrintStream logger, String command) throws IOException, InterruptedException {
            logger.println("Checking: " + command);
            return conn.exec(command, (OutputStream)logger) == 0;
        }

        protected int installJava(Connection conn, PrintStream logger) throws IOException, InterruptedException {
            for (String version : VALID_VERSIONS) {
                int result = conn.exec(this.getInstallCommand(version), (OutputStream)logger);
                if (result != 0) continue;
                return result;
            }
            return 1;
        }
    }
}

