/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.file_leak_detector;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Failure;
import hudson.model.ManagementLink;
import hudson.remoting.Which;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.kohsuke.file_leak_detector.Main;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class FileHandleDump
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(FileHandleDump.class.getName());

    public String getIconFileName() {
        return "help.png";
    }

    public String getDisplayName() {
        return "Open File Handles";
    }

    public String getUrlName() {
        return "file-handles";
    }

    public String getDescription() {
        return "Monitor the current open file handles on the master JVM";
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.TROUBLESHOOTING;
    }

    public HttpResponse doIndex(StaplerResponse2 response) throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Class<?> listener = this.loadListener();
        if (listener == null) {
            return HttpResponses.forwardToView((Object)((Object)this), (String)"_notRunning");
        }
        response.setContentType("text/plain;charset=UTF-8");
        listener.getMethod("dump", Writer.class).invoke(null, response.getWriter());
        return null;
    }

    @RequirePOST
    public HttpResponse doActivate(@QueryParameter String opts) throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.loadListener() != null) {
            return HttpResponses.text((String)"File leak detector is already activated");
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new File(System.getProperty("java.home"), "bin/java")).add("-jar").add(Which.jarFile(Main.class)).add((Object)ProcessHandle.current().pid()).add(Util.fixEmpty((String)opts));
        Process p = new ProcessBuilder(args.toCommandArray()).redirectErrorStream(true).start();
        p.getOutputStream().close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)baos);
        IOUtils.closeQuietly((InputStream)p.getInputStream());
        IOUtils.closeQuietly((InputStream)p.getErrorStream());
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            Failure e = new Failure("Failed to activate file leak detector. Perhaps the parameters were incorrect. Look for 'Agent failed to start!' in stderr logs for more info. Additional logs:\n" + String.valueOf(baos), true);
            LOGGER.log(Level.WARNING, e.getMessage());
            throw e;
        }
        return HttpResponses.text((String)"Successfully activated file leak detector");
    }

    private Class<?> loadListener() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        try {
            Class<?> listener = ClassLoader.getSystemClassLoader().loadClass("org.kohsuke.file_leak_detector.Listener");
            boolean isAgentInstalled = (Boolean)listener.getMethod("isAgentInstalled", new Class[0]).invoke(null, new Object[0]);
            if (!isAgentInstalled) {
                return null;
            }
            return listener;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

