/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystem;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemClientBuilder;
import com.amazonaws.services.elasticfilesystem.model.AccessPointDescription;
import com.amazonaws.services.elasticfilesystem.model.DescribeAccessPointsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeAccessPointsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import com.cloudbees.jenkins.plugins.amazonecs.aws.BaseAWSService;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class EFSService
extends BaseAWSService {
    private static final Logger LOGGER = Logger.getLogger(EFSService.class.getName());
    @Nonnull
    private final Supplier<AmazonElasticFileSystem> clientSupplier;

    public EFSService(String credentialsId, String regionName) {
        this.clientSupplier = () -> {
            AmazonElasticFileSystemClientBuilder builder = (AmazonElasticFileSystemClientBuilder)((AmazonElasticFileSystemClientBuilder)AmazonElasticFileSystemClientBuilder.standard().withClientConfiguration(this.createClientConfiguration())).withRegion(regionName);
            AmazonWebServicesCredentials credentials = this.getCredentials(credentialsId);
            if (credentials != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    String awsAccessKeyId = credentials.getCredentials().getAWSAccessKeyId();
                    String obfuscatedAccessKeyId = StringUtils.left((String)awsAccessKeyId, (int)4) + StringUtils.repeat((String)"*", (int)(awsAccessKeyId.length() - 8)) + StringUtils.right((String)awsAccessKeyId, (int)4);
                    LOGGER.log(Level.FINE, "Connect to Amazon EFS with IAM Access Key {1}", new Object[]{obfuscatedAccessKeyId});
                }
                builder.withCredentials((AWSCredentialsProvider)credentials);
            }
            LOGGER.log(Level.FINE, "Selected Region: {0}", regionName);
            return (AmazonElasticFileSystem)builder.build();
        };
    }

    public EFSService(Supplier<AmazonElasticFileSystem> clientSupplier) {
        this.clientSupplier = clientSupplier;
    }

    AmazonElasticFileSystem getAmazonEFSClient() {
        return this.clientSupplier.get();
    }

    public List<FileSystemDescription> getAllFileSystems() {
        DescribeFileSystemsResult result;
        AmazonElasticFileSystem client = this.getAmazonEFSClient();
        ArrayList<FileSystemDescription> allFileSystems = new ArrayList<FileSystemDescription>();
        String lastMarker = null;
        do {
            result = client.describeFileSystems(new DescribeFileSystemsRequest().withMarker(lastMarker));
            allFileSystems.addAll(result.getFileSystems());
        } while ((lastMarker = result.getNextMarker()) != null);
        return allFileSystems;
    }

    public List<AccessPointDescription> getAccessPointsForFileSystem(String fileSystemId) {
        DescribeAccessPointsResult describeAccessPointsResult;
        ArrayList<AccessPointDescription> accessPointsList = new ArrayList<AccessPointDescription>();
        if (StringUtils.isEmpty((String)fileSystemId)) {
            return accessPointsList;
        }
        AmazonElasticFileSystem client = this.getAmazonEFSClient();
        String nextToken = null;
        do {
            describeAccessPointsResult = client.describeAccessPoints(new DescribeAccessPointsRequest().withFileSystemId(fileSystemId).withNextToken(nextToken));
            accessPointsList.addAll(describeAccessPointsResult.getAccessPoints());
        } while ((nextToken = describeAccessPointsResult.getNextToken()) != null);
        return accessPointsList;
    }
}

