/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.model.CPUArchitecture;
import com.amazonaws.services.ecs.model.CapacityProviderStrategyItem;
import com.amazonaws.services.ecs.model.Cluster;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.EFSAuthorizationConfig;
import com.amazonaws.services.ecs.model.EFSAuthorizationConfigIAM;
import com.amazonaws.services.ecs.model.EFSTransitEncryption;
import com.amazonaws.services.ecs.model.EFSVolumeConfiguration;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.services.ecs.model.HostVolumeProperties;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.LaunchType;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.amazonaws.services.ecs.model.OSFamily;
import com.amazonaws.services.ecs.model.PlacementStrategy;
import com.amazonaws.services.ecs.model.PlacementStrategyType;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.Ulimit;
import com.amazonaws.services.ecs.model.UlimitName;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.elasticfilesystem.model.AccessPointDescription;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import com.cloudbees.jenkins.plugins.amazonecs.ECSService;
import com.cloudbees.jenkins.plugins.amazonecs.Messages;
import com.cloudbees.jenkins.plugins.amazonecs.aws.EFSService;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ECSTaskTemplate
extends AbstractDescribableImpl<ECSTaskTemplate>
implements Serializable {
    private static final long serialVersionUID = -426721853953018205L;
    private final String templateName;
    @CheckForNull
    private final String label;
    @CheckForNull
    private final String agentContainerName;
    @CheckForNull
    private final String taskDefinitionOverride;
    private String dynamicTaskDefinitionOverride;
    private final String image;
    @Nullable
    private final String remoteFSRoot;
    private final int memory;
    private final int memoryReservation;
    private final int cpu;
    private Integer ephemeralStorageSizeInGiB;
    private final int sharedMemorySize;
    private String subnets;
    private String securityGroups;
    private boolean assignPublicIp;
    @CheckForNull
    private String dnsSearchDomains;
    @CheckForNull
    private String entrypoint;
    @CheckForNull
    private String taskrole;
    @CheckForNull
    private String executionRole;
    @CheckForNull
    private String repositoryCredentials;
    @CheckForNull
    private String jvmArgs;
    private List<MountPointEntry> mountPoints;
    private List<EFSMountPointEntry> efsMountPoints;
    private final String launchType;
    private final String operatingSystemFamily;
    private final String cpuArchitecture;
    private boolean defaultCapacityProvider;
    private final String networkMode;
    private final boolean privileged;
    private final boolean uniqueRemoteFSRoot;
    private final String platformVersion;
    @Nullable
    private String containerUser;
    @Nullable
    private String kernelCapabilities;
    private List<EnvironmentEntry> environments;
    private List<ExtraHostEntry> extraHosts;
    private List<PortMappingEntry> portMappings;
    private List<UlimitEntry> ulimits;
    private List<PlacementStrategyEntry> placementStrategies;
    private List<CapacityProviderStrategyEntry> capacityProviderStrategies;
    private List<Tag> tags;
    @CheckForNull
    private String logDriver;
    private List<LogDriverOption> logDriverOptions;
    private String inheritFrom;
    private boolean enableExecuteCommand;

    public int getMemoryConstraint() {
        if (this.memoryReservation > 0) {
            return this.memoryReservation;
        }
        return this.memory;
    }

    @DataBoundConstructor
    public ECSTaskTemplate(String templateName, @Nullable String label, @Nullable String agentContainerName, @Nullable String taskDefinitionOverride, @Nullable String dynamicTaskDefinitionOverride, String image, @Nullable String repositoryCredentials, @Nullable String launchType, @Nullable String operatingSystemFamily, @Nullable String cpuArchitecture, boolean defaultCapacityProvider, @Nullable List<CapacityProviderStrategyEntry> capacityProviderStrategies, String networkMode, @Nullable String remoteFSRoot, boolean uniqueRemoteFSRoot, String platformVersion, int memory, int memoryReservation, int cpu, @Nullable Integer ephemeralStorageSizeInGiB, @Nullable String subnets, @Nullable String securityGroups, boolean assignPublicIp, boolean privileged, @Nullable String containerUser, @Nullable String kernelCapabilities, @Nullable List<LogDriverOption> logDriverOptions, @Nullable List<Tag> tags, @Nullable List<EnvironmentEntry> environments, @Nullable List<ExtraHostEntry> extraHosts, @Nullable List<MountPointEntry> mountPoints, @Nullable List<EFSMountPointEntry> efsMountPoints, @Nullable List<PortMappingEntry> portMappings, @Nullable List<UlimitEntry> ulimits, @Nullable String executionRole, @Nullable List<PlacementStrategyEntry> placementStrategies, @Nullable String taskrole, @Nullable String inheritFrom, int sharedMemorySize, boolean enableExecuteCommand) {
        if (taskDefinitionOverride != null && !taskDefinitionOverride.trim().isEmpty()) {
            this.taskDefinitionOverride = taskDefinitionOverride.trim();
            this.agentContainerName = agentContainerName != null && !agentContainerName.trim().isEmpty() ? agentContainerName.trim() : null;
            this.templateName = "";
        } else {
            this.templateName = templateName.isEmpty() ? "jenkinsTask-" + UUID.randomUUID().toString() : templateName;
            this.taskDefinitionOverride = null;
            this.agentContainerName = null;
        }
        this.label = label;
        this.image = image;
        this.repositoryCredentials = StringUtils.trimToNull((String)repositoryCredentials);
        this.remoteFSRoot = remoteFSRoot;
        this.uniqueRemoteFSRoot = uniqueRemoteFSRoot;
        this.platformVersion = platformVersion;
        this.memory = memory;
        this.memoryReservation = memoryReservation;
        this.cpu = cpu;
        this.ephemeralStorageSizeInGiB = ephemeralStorageSizeInGiB;
        this.launchType = launchType;
        this.operatingSystemFamily = operatingSystemFamily;
        this.cpuArchitecture = cpuArchitecture;
        this.defaultCapacityProvider = defaultCapacityProvider;
        this.capacityProviderStrategies = capacityProviderStrategies;
        this.networkMode = networkMode;
        this.subnets = subnets;
        this.securityGroups = securityGroups;
        this.assignPublicIp = assignPublicIp;
        this.privileged = privileged;
        this.containerUser = StringUtils.trimToNull((String)containerUser);
        this.kernelCapabilities = StringUtils.trimToNull((String)kernelCapabilities);
        this.logDriverOptions = logDriverOptions;
        this.tags = tags;
        this.environments = environments;
        this.extraHosts = extraHosts;
        this.mountPoints = mountPoints;
        this.efsMountPoints = efsMountPoints;
        this.portMappings = portMappings;
        this.ulimits = ulimits;
        this.executionRole = executionRole;
        this.placementStrategies = placementStrategies;
        this.taskrole = taskrole;
        this.inheritFrom = inheritFrom;
        this.sharedMemorySize = sharedMemorySize;
        this.dynamicTaskDefinitionOverride = StringUtils.trimToNull((String)dynamicTaskDefinitionOverride);
        this.enableExecuteCommand = enableExecuteCommand;
    }

    @DataBoundSetter
    public void setDynamicTaskDefinition(String dynamicTaskDefArn) {
        this.dynamicTaskDefinitionOverride = StringUtils.trimToNull((String)dynamicTaskDefArn);
    }

    @DataBoundSetter
    public void setTaskrole(String taskRoleArn) {
        this.taskrole = StringUtils.trimToNull((String)taskRoleArn);
    }

    @DataBoundSetter
    public void setExecutionRole(String executionRole) {
        this.executionRole = StringUtils.trimToNull((String)executionRole);
    }

    @DataBoundSetter
    public void setRepositoryCredentials(String repositoryCredentials) {
        this.repositoryCredentials = StringUtils.trimToNull((String)repositoryCredentials);
    }

    @DataBoundSetter
    public void setEntrypoint(String entrypoint) {
        this.entrypoint = StringUtils.trimToNull((String)entrypoint);
    }

    @DataBoundSetter
    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = StringUtils.trimToNull((String)jvmArgs);
    }

    @DataBoundSetter
    public void setContainerUser(String containerUser) {
        this.containerUser = StringUtils.trimToNull((String)containerUser);
    }

    @DataBoundSetter
    public void setKernelCapabilities(String kernelCapabilities) {
        this.kernelCapabilities = StringUtils.trimToNull((String)kernelCapabilities);
    }

    @DataBoundSetter
    public void setLogDriver(String logDriver) {
        this.logDriver = StringUtils.trimToNull((String)logDriver);
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    @DataBoundSetter
    public void setSubnets(String subnets) {
        this.subnets = StringUtils.trimToNull((String)subnets);
    }

    @DataBoundSetter
    public void setSecurityGroups(String securityGroups) {
        this.securityGroups = StringUtils.trimToNull((String)securityGroups);
    }

    @DataBoundSetter
    public void setDnsSearchDomains(String dnsSearchDomains) {
        this.dnsSearchDomains = StringUtils.trimToNull((String)dnsSearchDomains);
    }

    public boolean isFargate() {
        if (!this.defaultCapacityProvider && this.capacityProviderStrategies != null && !this.capacityProviderStrategies.isEmpty()) {
            for (CapacityProviderStrategyEntry capacityProviderStrategy : this.capacityProviderStrategies) {
                String provider = capacityProviderStrategy.provider;
                if (!provider.contains(LaunchType.FARGATE.toString())) continue;
                return true;
            }
            return false;
        }
        return StringUtils.trimToNull((String)this.launchType) != null && this.launchType.equals(LaunchType.FARGATE.toString());
    }

    public boolean isEC2() {
        return StringUtils.trimToNull((String)this.launchType) != null && this.launchType.equals(LaunchType.EC2.toString());
    }

    public String getLabel() {
        return this.label;
    }

    public String getAgentContainerName() {
        return this.agentContainerName;
    }

    public String getTaskDefinitionOverride() {
        return this.taskDefinitionOverride;
    }

    public String getDynamicTaskDefinition() {
        return this.dynamicTaskDefinitionOverride;
    }

    public String getImage() {
        return this.image;
    }

    public String getRemoteFSRoot() {
        return this.remoteFSRoot;
    }

    public String makeRemoteFSRoot(@Nonnull String name) {
        if (!this.uniqueRemoteFSRoot || this.remoteFSRoot == null) {
            return this.remoteFSRoot;
        }
        return this.remoteFSRoot + "/" + name;
    }

    public boolean getUniqueRemoteFSRoot() {
        return this.uniqueRemoteFSRoot;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getMemoryReservation() {
        return this.memoryReservation;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getSharedMemorySize() {
        return this.sharedMemorySize;
    }

    public Integer getEphemeralStorageSizeInGiB() {
        return this.ephemeralStorageSizeInGiB;
    }

    public String getSubnets() {
        return this.subnets;
    }

    public String getSecurityGroups() {
        return this.securityGroups;
    }

    public boolean getAssignPublicIp() {
        return this.assignPublicIp;
    }

    public boolean getDefaultCapacityProvider() {
        return this.defaultCapacityProvider;
    }

    public String getDnsSearchDomains() {
        return this.dnsSearchDomains;
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public String getTaskrole() {
        return this.taskrole;
    }

    public String getExecutionRole() {
        return this.executionRole;
    }

    public String getRepositoryCredentials() {
        return this.repositoryCredentials;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    public String getContainerUser() {
        return this.containerUser;
    }

    public String getKernelCapabilities() {
        return this.kernelCapabilities;
    }

    public String getLaunchType() {
        if (StringUtils.trimToNull((String)this.launchType) == null) {
            return LaunchType.EC2.toString();
        }
        return this.launchType;
    }

    public String getOperatingSystemFamily() {
        if (StringUtils.trimToNull((String)this.operatingSystemFamily) == null) {
            return OSFamily.LINUX.toString();
        }
        return this.operatingSystemFamily;
    }

    public String getCpuArchitecture() {
        if (StringUtils.trimToNull((String)this.cpuArchitecture) == null) {
            return CPUArchitecture.X86_64.toString();
        }
        return this.cpuArchitecture;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public String getLogDriver() {
        return this.logDriver;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isEnableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public String toString() {
        return Arrays.stream(this.getClass().getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> {
            try {
                return String.format("%s: %s", f.getName(), f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException();
            }
        }).collect(Collectors.joining("\n"));
    }

    public List<LogDriverOption> getLogDriverOptions() {
        return this.logDriverOptions;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    Map<String, String> getLogDriverOptionsMap() {
        if (null == this.logDriverOptions || this.logDriverOptions.isEmpty()) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (LogDriverOption logDriverOption : this.logDriverOptions) {
            String name = logDriverOption.name;
            String value = logDriverOption.value;
            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)value)) continue;
            options.put(name, value);
        }
        return options;
    }

    Map<String, String> getTagsMap() {
        if (null == this.tags || this.tags.isEmpty()) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (Tag tag : this.tags) {
            String name = tag.name;
            String value = tag.value;
            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)value)) continue;
            options.put(name, value);
        }
        return options;
    }

    public List<EnvironmentEntry> getEnvironments() {
        return this.environments;
    }

    public List<ExtraHostEntry> getExtraHosts() {
        return this.extraHosts;
    }

    public List<PortMappingEntry> getPortMappings() {
        return this.portMappings;
    }

    public List<UlimitEntry> getUlimits() {
        return this.ulimits;
    }

    public List<PlacementStrategyEntry> getPlacementStrategies() {
        return this.placementStrategies;
    }

    public List<CapacityProviderStrategyEntry> getCapacityProviderStrategies() {
        return this.capacityProviderStrategies;
    }

    public ECSTaskTemplate merge(ECSTaskTemplate parent) {
        if (parent == null) {
            return this;
        }
        String templateName = Strings.isNullOrEmpty((String)this.templateName) ? parent.getTemplateName() : this.templateName;
        String label = Strings.isNullOrEmpty((String)this.label) ? parent.getLabel() : this.label;
        String agentContainerName = Strings.isNullOrEmpty((String)this.agentContainerName) ? parent.getAgentContainerName() : this.agentContainerName;
        String taskDefinitionOverride = Strings.isNullOrEmpty((String)this.taskDefinitionOverride) ? parent.getTaskDefinitionOverride() : this.taskDefinitionOverride;
        String image = Strings.isNullOrEmpty((String)this.image) ? parent.getImage() : this.image;
        String repositoryCredentials = Strings.isNullOrEmpty((String)this.repositoryCredentials) ? parent.getRepositoryCredentials() : this.repositoryCredentials;
        String launchType = Strings.isNullOrEmpty((String)this.launchType) ? parent.getLaunchType() : this.launchType;
        String operatingSystemFamily = Strings.isNullOrEmpty((String)this.operatingSystemFamily) ? parent.getOperatingSystemFamily() : this.operatingSystemFamily;
        String cpuArchitecture = Strings.isNullOrEmpty((String)this.cpuArchitecture) ? parent.getCpuArchitecture() : this.cpuArchitecture;
        boolean defaultCapacityProvider = this.defaultCapacityProvider ? this.defaultCapacityProvider : parent.getDefaultCapacityProvider();
        String networkMode = Strings.isNullOrEmpty((String)this.networkMode) ? parent.getNetworkMode() : this.networkMode;
        String remoteFSRoot = Strings.isNullOrEmpty((String)this.remoteFSRoot) ? parent.getRemoteFSRoot() : this.remoteFSRoot;
        boolean uniqueRemoteFSRoot = this.uniqueRemoteFSRoot || parent.getUniqueRemoteFSRoot();
        String platformVersion = Strings.isNullOrEmpty((String)this.platformVersion) ? parent.getPlatformVersion() : this.platformVersion;
        int memory = this.memory == 0 ? parent.getMemory() : this.memory;
        int memoryReservation = this.memoryReservation == 0 ? parent.getMemoryReservation() : this.memoryReservation;
        int cpu = this.cpu == 0 ? parent.getCpu() : this.cpu;
        Integer ephemeralStorageSizeInGiB = this.ephemeralStorageSizeInGiB == null ? parent.getEphemeralStorageSizeInGiB() : this.ephemeralStorageSizeInGiB;
        int sharedMemorySize = this.sharedMemorySize == 0 ? parent.getSharedMemorySize() : this.sharedMemorySize;
        String subnets = Strings.isNullOrEmpty((String)this.subnets) ? parent.getSubnets() : this.subnets;
        String securityGroups = Strings.isNullOrEmpty((String)this.securityGroups) ? parent.getSecurityGroups() : this.securityGroups;
        boolean assignPublicIp = this.assignPublicIp ? this.assignPublicIp : parent.getAssignPublicIp();
        boolean privileged = this.privileged ? this.privileged : parent.getPrivileged();
        String containerUser = Strings.isNullOrEmpty((String)this.containerUser) ? parent.getContainerUser() : this.containerUser;
        String kernelCapabilities = Strings.isNullOrEmpty((String)this.kernelCapabilities) ? parent.getKernelCapabilities() : this.kernelCapabilities;
        String logDriver = Strings.isNullOrEmpty((String)this.logDriver) ? parent.getLogDriver() : this.logDriver;
        String entrypoint = Strings.isNullOrEmpty((String)this.entrypoint) ? parent.getEntrypoint() : this.entrypoint;
        HashSet mergedTagsSet = new HashSet(CollectionUtils.isEmpty(this.tags) ? new ArrayList() : this.tags);
        Optional.ofNullable(parent.getTags()).ifPresent(mergedTagsSet::addAll);
        ArrayList<Tag> tags = new ArrayList<Tag>(mergedTagsSet);
        List<LogDriverOption> logDriverOptions = CollectionUtils.isEmpty(this.logDriverOptions) ? parent.getLogDriverOptions() : this.logDriverOptions;
        List<EnvironmentEntry> environments = CollectionUtils.isEmpty(this.environments) ? parent.getEnvironments() : this.environments;
        List<ExtraHostEntry> extraHosts = CollectionUtils.isEmpty(this.extraHosts) ? parent.getExtraHosts() : this.extraHosts;
        List<MountPointEntry> mountPoints = CollectionUtils.isEmpty(this.mountPoints) ? parent.getMountPoints() : this.mountPoints;
        List<EFSMountPointEntry> efsMountPoints = CollectionUtils.isEmpty(this.efsMountPoints) ? parent.getEfsMountPoints() : this.efsMountPoints;
        List<PortMappingEntry> portMappings = CollectionUtils.isEmpty(this.portMappings) ? parent.getPortMappings() : this.portMappings;
        List<UlimitEntry> ulimits = CollectionUtils.isEmpty(this.ulimits) ? parent.getUlimits() : this.ulimits;
        List<PlacementStrategyEntry> placementStrategies = CollectionUtils.isEmpty(this.placementStrategies) ? parent.getPlacementStrategies() : this.placementStrategies;
        List<CapacityProviderStrategyEntry> capacityProviderStrategies = CollectionUtils.isEmpty(this.capacityProviderStrategies) ? parent.getCapacityProviderStrategies() : this.capacityProviderStrategies;
        String executionRole = Strings.isNullOrEmpty((String)this.executionRole) ? parent.getExecutionRole() : this.executionRole;
        String taskrole = Strings.isNullOrEmpty((String)this.taskrole) ? parent.getTaskrole() : this.taskrole;
        boolean enableExecuteCommand = this.enableExecuteCommand ? true : parent.isEnableExecuteCommand();
        ECSTaskTemplate merged = new ECSTaskTemplate(templateName, label, agentContainerName, taskDefinitionOverride, null, image, repositoryCredentials, launchType, operatingSystemFamily, cpuArchitecture, defaultCapacityProvider, capacityProviderStrategies, networkMode, remoteFSRoot, uniqueRemoteFSRoot, platformVersion, memory, memoryReservation, cpu, ephemeralStorageSizeInGiB, subnets, securityGroups, assignPublicIp, privileged, containerUser, kernelCapabilities, logDriverOptions, tags, environments, extraHosts, mountPoints, efsMountPoints, portMappings, ulimits, executionRole, placementStrategies, taskrole, null, sharedMemorySize, enableExecuteCommand);
        merged.setLogDriver(logDriver);
        merged.setEntrypoint(entrypoint);
        return merged;
    }

    Collection<KeyValuePair> getEnvironmentKeyValuePairs() {
        if (null == this.environments || this.environments.isEmpty()) {
            return null;
        }
        ArrayList<KeyValuePair> items = new ArrayList<KeyValuePair>();
        for (EnvironmentEntry environment : this.environments) {
            String name = environment.name;
            String value = environment.value;
            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)value)) continue;
            items.add(new KeyValuePair().withName(name).withValue(value));
        }
        return items;
    }

    Collection<HostEntry> getExtraHostEntries() {
        if (null == this.extraHosts || this.extraHosts.isEmpty()) {
            return null;
        }
        ArrayList<HostEntry> items = new ArrayList<HostEntry>();
        for (ExtraHostEntry extrahost : this.extraHosts) {
            String ipAddress = extrahost.ipAddress;
            String hostname = extrahost.hostname;
            if (StringUtils.isEmpty((String)ipAddress) || StringUtils.isEmpty((String)hostname)) continue;
            items.add(new HostEntry().withIpAddress(ipAddress).withHostname(hostname));
        }
        return items;
    }

    public List<MountPointEntry> getMountPoints() {
        return this.mountPoints;
    }

    public List<EFSMountPointEntry> getEfsMountPoints() {
        return this.efsMountPoints;
    }

    Collection<Volume> getVolumeEntries() {
        LinkedList<Volume> vols = new LinkedList<Volume>();
        if (null != this.mountPoints) {
            for (MountPointEntry mountPointEntry : this.mountPoints) {
                String name = mountPointEntry.name;
                String sourcePath = mountPointEntry.sourcePath;
                HostVolumeProperties hostVolume = new HostVolumeProperties();
                if (StringUtils.isEmpty((String)name)) continue;
                if (!StringUtils.isEmpty((String)sourcePath)) {
                    hostVolume.setSourcePath(sourcePath);
                }
                vols.add(new Volume().withName(name).withHost(hostVolume));
            }
        }
        if (null != this.efsMountPoints) {
            for (EFSMountPointEntry eFSMountPointEntry : this.efsMountPoints) {
                if (StringUtils.isEmpty((String)eFSMountPointEntry.name)) continue;
                EFSAuthorizationConfig efsAuthorizationConfig = null;
                if (StringUtils.isNotEmpty((String)eFSMountPointEntry.accessPointId)) {
                    efsAuthorizationConfig = new EFSAuthorizationConfig().withAccessPointId(eFSMountPointEntry.accessPointId).withIam(BooleanUtils.isTrue((Boolean)eFSMountPointEntry.iam) ? EFSAuthorizationConfigIAM.ENABLED : EFSAuthorizationConfigIAM.DISABLED);
                }
                EFSVolumeConfiguration efsVolumeConfiguration = new EFSVolumeConfiguration().withFileSystemId(eFSMountPointEntry.fileSystemId).withRootDirectory(eFSMountPointEntry.rootDirectory).withAuthorizationConfig(efsAuthorizationConfig).withTransitEncryption(BooleanUtils.isTrue((Boolean)eFSMountPointEntry.transitEncryption) ? EFSTransitEncryption.ENABLED : EFSTransitEncryption.DISABLED);
                vols.add(new Volume().withName(eFSMountPointEntry.name).withEfsVolumeConfiguration(efsVolumeConfiguration));
            }
        }
        return vols;
    }

    Collection<MountPoint> getMountPointEntries() {
        Boolean ro;
        String path;
        String src;
        ArrayList<MountPoint> mounts = new ArrayList<MountPoint>();
        if (null != this.mountPoints) {
            for (MountPointEntry mountPointEntry : this.mountPoints) {
                src = mountPointEntry.name;
                path = mountPointEntry.containerPath;
                ro = mountPointEntry.readOnly;
                if (StringUtils.isEmpty((String)src) || StringUtils.isEmpty((String)path)) continue;
                mounts.add(new MountPoint().withSourceVolume(src).withContainerPath(path).withReadOnly(ro));
            }
        }
        if (null != this.efsMountPoints) {
            for (EFSMountPointEntry eFSMountPointEntry : this.efsMountPoints) {
                src = eFSMountPointEntry.name;
                path = eFSMountPointEntry.containerPath;
                ro = eFSMountPointEntry.readOnly;
                if (StringUtils.isEmpty((String)src) || StringUtils.isEmpty((String)path)) continue;
                mounts.add(new MountPoint().withSourceVolume(src).withContainerPath(path).withReadOnly(ro));
            }
        }
        return mounts.isEmpty() ? null : mounts;
    }

    Collection<PortMapping> getPortMappingEntries() {
        if (null == this.portMappings || this.portMappings.isEmpty()) {
            return null;
        }
        ArrayList<PortMapping> ports = new ArrayList<PortMapping>();
        for (PortMappingEntry portMapping : this.portMappings) {
            Integer container = portMapping.containerPort;
            Integer host = portMapping.hostPort;
            String protocol = portMapping.protocol;
            ports.add(new PortMapping().withContainerPort(container).withHostPort(host).withProtocol(protocol));
        }
        return ports;
    }

    Collection<Ulimit> getUlimitsEntries() {
        if (null == this.ulimits || this.ulimits.isEmpty()) {
            return null;
        }
        ArrayList<Ulimit> ulimits = new ArrayList<Ulimit>();
        for (UlimitEntry ulimitEntry : this.ulimits) {
            Integer hardLimit = ulimitEntry.hardLimit;
            Integer softLimit = ulimitEntry.softLimit;
            String ulimitName = ulimitEntry.ulimitName;
            ulimits.add(new Ulimit().withHardLimit(hardLimit).withSoftLimit(softLimit).withName(ulimitName));
        }
        return ulimits;
    }

    Collection<PlacementStrategy> getPlacementStrategyEntries() {
        if (null == this.placementStrategies || this.placementStrategies.isEmpty()) {
            return null;
        }
        ArrayList<PlacementStrategy> placements = new ArrayList<PlacementStrategy>();
        for (PlacementStrategyEntry placementStrategy : this.placementStrategies) {
            String type = placementStrategy.type;
            String field = placementStrategy.field;
            placements.add(new PlacementStrategy().withType(type).withField(field));
        }
        return placements;
    }

    Collection<CapacityProviderStrategyItem> getCapacityProviderStrategyEntries() {
        if (null == this.capacityProviderStrategies || this.capacityProviderStrategies.isEmpty()) {
            return null;
        }
        ArrayList<CapacityProviderStrategyItem> stragies = new ArrayList<CapacityProviderStrategyItem>();
        for (CapacityProviderStrategyEntry capacityProviderStrategy : this.capacityProviderStrategies) {
            String provider = capacityProviderStrategy.provider;
            int base = capacityProviderStrategy.base;
            int weight = capacityProviderStrategy.weight;
            stragies.add(new CapacityProviderStrategyItem().withCapacityProvider(provider).withWeight(Integer.valueOf(weight)).withBase(Integer.valueOf(base)));
        }
        return stragies;
    }

    public Set<LabelAtom> getLabelSet() {
        return Label.parse((String)this.label);
    }

    public String getDisplayName() {
        return "ECS Agent " + this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECSTaskTemplate that = (ECSTaskTemplate)o;
        if (this.memory != that.memory) {
            return false;
        }
        if (this.memoryReservation != that.memoryReservation) {
            return false;
        }
        if (this.cpu != that.cpu) {
            return false;
        }
        if (!Objects.equals(this.ephemeralStorageSizeInGiB, that.ephemeralStorageSizeInGiB)) {
            return false;
        }
        if (this.sharedMemorySize != that.sharedMemorySize) {
            return false;
        }
        if (this.assignPublicIp != that.assignPublicIp) {
            return false;
        }
        if (this.privileged != that.privileged) {
            return false;
        }
        if (this.uniqueRemoteFSRoot != that.uniqueRemoteFSRoot) {
            return false;
        }
        if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) {
            return false;
        }
        if (!this.templateName.equals(that.templateName)) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.agentContainerName != null ? !this.agentContainerName.equals(that.agentContainerName) : that.agentContainerName != null) {
            return false;
        }
        if (this.taskDefinitionOverride != null ? !this.taskDefinitionOverride.equals(that.taskDefinitionOverride) : that.taskDefinitionOverride != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.remoteFSRoot != null ? !this.remoteFSRoot.equals(that.remoteFSRoot) : that.remoteFSRoot != null) {
            return false;
        }
        if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) {
            return false;
        }
        if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) {
            return false;
        }
        if (this.dnsSearchDomains != null ? !this.dnsSearchDomains.equals(that.dnsSearchDomains) : that.dnsSearchDomains != null) {
            return false;
        }
        if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) {
            return false;
        }
        if (this.taskrole != null ? !this.taskrole.equals(that.taskrole) : that.taskrole != null) {
            return false;
        }
        if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) {
            return false;
        }
        if (this.repositoryCredentials != null ? !this.repositoryCredentials.equals(that.repositoryCredentials) : that.repositoryCredentials != null) {
            return false;
        }
        if (this.jvmArgs != null ? !this.jvmArgs.equals(that.jvmArgs) : that.jvmArgs != null) {
            return false;
        }
        if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) {
            return false;
        }
        if (this.efsMountPoints != null ? !this.efsMountPoints.equals(that.efsMountPoints) : that.efsMountPoints != null) {
            return false;
        }
        if (this.launchType != null ? !this.launchType.equals(that.launchType) : that.launchType != null) {
            return false;
        }
        if (this.operatingSystemFamily != null ? !this.operatingSystemFamily.equals(that.operatingSystemFamily) : that.operatingSystemFamily != null) {
            return false;
        }
        if (this.cpuArchitecture != null ? !this.cpuArchitecture.equals(that.cpuArchitecture) : that.cpuArchitecture != null) {
            return false;
        }
        if (this.defaultCapacityProvider != that.defaultCapacityProvider) {
            return false;
        }
        if (this.capacityProviderStrategies != null ? !this.capacityProviderStrategies.equals(that.capacityProviderStrategies) : that.capacityProviderStrategies != null) {
            return false;
        }
        if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) {
            return false;
        }
        if (this.containerUser != null ? !this.containerUser.equals(that.containerUser) : that.containerUser != null) {
            return false;
        }
        if (this.kernelCapabilities != null ? !this.kernelCapabilities.equals(that.kernelCapabilities) : that.kernelCapabilities != null) {
            return false;
        }
        if (this.environments != null ? !this.environments.equals(that.environments) : that.environments != null) {
            return false;
        }
        if (this.extraHosts != null ? !this.extraHosts.equals(that.extraHosts) : that.extraHosts != null) {
            return false;
        }
        if (this.portMappings != null ? !this.portMappings.equals(that.portMappings) : that.portMappings != null) {
            return false;
        }
        if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) {
            return false;
        }
        if (this.placementStrategies != null ? !this.placementStrategies.equals(that.placementStrategies) : that.placementStrategies != null) {
            return false;
        }
        if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) {
            return false;
        }
        if (this.logDriverOptions != null ? !this.logDriverOptions.equals(that.logDriverOptions) : that.logDriverOptions != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        return this.inheritFrom != null ? this.inheritFrom.equals(that.inheritFrom) : that.inheritFrom == null;
    }

    public int hashCode() {
        int result = this.templateName.hashCode();
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.agentContainerName != null ? this.agentContainerName.hashCode() : 0);
        result = 31 * result + (this.taskDefinitionOverride != null ? this.taskDefinitionOverride.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.remoteFSRoot != null ? this.remoteFSRoot.hashCode() : 0);
        result = 31 * result + this.memory;
        result = 31 * result + this.memoryReservation;
        result = 31 * result + this.cpu;
        result = 31 * result + (this.ephemeralStorageSizeInGiB != null ? this.ephemeralStorageSizeInGiB : 0);
        result = 31 * result + this.sharedMemorySize;
        result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
        result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
        result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
        result = 31 * result + (this.assignPublicIp ? 1 : 0);
        result = 31 * result + (this.dnsSearchDomains != null ? this.dnsSearchDomains.hashCode() : 0);
        result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
        result = 31 * result + (this.taskrole != null ? this.taskrole.hashCode() : 0);
        result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
        result = 31 * result + (this.repositoryCredentials != null ? this.repositoryCredentials.hashCode() : 0);
        result = 31 * result + (this.jvmArgs != null ? this.jvmArgs.hashCode() : 0);
        result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
        result = 31 * result + (this.efsMountPoints != null ? this.efsMountPoints.hashCode() : 0);
        result = 31 * result + (this.launchType != null ? this.launchType.hashCode() : 0);
        result = 31 * result + (this.operatingSystemFamily != null ? this.operatingSystemFamily.hashCode() : 0);
        result = 31 * result + (this.cpuArchitecture != null ? this.cpuArchitecture.hashCode() : 0);
        result = 31 * result + (this.defaultCapacityProvider ? 1 : 0);
        result = 31 * result + (this.capacityProviderStrategies != null ? this.capacityProviderStrategies.hashCode() : 0);
        result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
        result = 31 * result + (this.privileged ? 1 : 0);
        result = 31 * result + (this.uniqueRemoteFSRoot ? 1 : 0);
        result = 31 * result + (this.containerUser != null ? this.containerUser.hashCode() : 0);
        result = 31 * result + (this.kernelCapabilities != null ? this.kernelCapabilities.hashCode() : 0);
        result = 31 * result + (this.environments != null ? this.environments.hashCode() : 0);
        result = 31 * result + (this.extraHosts != null ? this.extraHosts.hashCode() : 0);
        result = 31 * result + (this.portMappings != null ? this.portMappings.hashCode() : 0);
        result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
        result = 31 * result + (this.placementStrategies != null ? this.placementStrategies.hashCode() : 0);
        result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
        result = 31 * result + (this.logDriverOptions != null ? this.logDriverOptions.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.inheritFrom != null ? this.inheritFrom.hashCode() : 0);
        result = 31 * result + (this.enableExecuteCommand ? 1 : 0);
        return result;
    }

    public static class CapacityProviderStrategyEntry
    extends AbstractDescribableImpl<CapacityProviderStrategyEntry>
    implements Serializable {
        public String provider;
        public int base;
        public int weight;

        @DataBoundConstructor
        public CapacityProviderStrategyEntry(String provider, int base, int weight) {
            this.base = base;
            this.weight = weight;
            this.provider = provider;
        }

        public String toString() {
            return "CapacityProviderStrategyEntry{" + this.provider + "base: " + this.base + "weight: " + this.weight + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CapacityProviderStrategyEntry> {
            public ListBoxModel doFillProviderItems(@RelativePath(value="../..") @QueryParameter String credentialsId, @RelativePath(value="../..") @QueryParameter String assumedRoleArn, @RelativePath(value="../..") @QueryParameter String regionName, @RelativePath(value="../..") @QueryParameter String cluster) {
                ECSService ecsService = new ECSService(credentialsId, assumedRoleArn, regionName);
                AmazonECS client = ecsService.getAmazonECSClient();
                ArrayList allClusters = new ArrayList();
                DescribeClustersResult result = client.describeClusters(new DescribeClustersRequest().withClusters(new String[]{cluster}));
                allClusters.addAll(result.getClusters());
                ListBoxModel options = new ListBoxModel();
                for (Cluster c : allClusters) {
                    List item = c.getCapacityProviders();
                    Collections.sort(item);
                    for (String provider : item) {
                        options.add(provider);
                    }
                }
                return options;
            }

            public String getDisplayName() {
                return "CapacityProviderStrategyEntry";
            }

            public FormValidation doCheckField(@QueryParameter(value="base") int base, @QueryParameter(value="weight") int weight, @QueryParameter(value="provider") String provider) throws IOException, ServletException {
                return FormValidation.ok();
            }
        }
    }

    public static class LogDriverOption
    extends AbstractDescribableImpl<LogDriverOption>
    implements Serializable {
        private static final long serialVersionUID = 8585792353105873086L;
        public String name;
        public String value;

        @DataBoundConstructor
        public LogDriverOption(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "LogDriverOption{" + this.name + ": " + this.value + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<LogDriverOption> {
            public String getDisplayName() {
                return "logDriverOption";
            }
        }
    }

    public static class Tag
    extends AbstractDescribableImpl<Tag>
    implements Serializable {
        private static final long serialVersionUID = 4357423231051873086L;
        public String name;
        public String value;

        @DataBoundConstructor
        public Tag(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.name, tag.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "Tag{" + this.name + ": " + this.value + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Tag> {
            public String getDisplayName() {
                return "tag";
            }
        }
    }

    public static class EnvironmentEntry
    extends AbstractDescribableImpl<EnvironmentEntry>
    implements Serializable {
        private static final long serialVersionUID = 4195862080979262875L;
        public String name;
        public String value;

        @DataBoundConstructor
        public EnvironmentEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "EnvironmentEntry{" + this.name + ": " + this.value + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<EnvironmentEntry> {
            public String getDisplayName() {
                return "EnvironmentEntry";
            }
        }
    }

    public static class ExtraHostEntry
    extends AbstractDescribableImpl<ExtraHostEntry>
    implements Serializable {
        private static final long serialVersionUID = -23978859661031633L;
        public String ipAddress;
        public String hostname;

        @DataBoundConstructor
        public ExtraHostEntry(String ipAddress, String hostname) {
            this.ipAddress = ipAddress;
            this.hostname = hostname;
        }

        public String toString() {
            return "ExtraHostEntry{" + this.ipAddress + ": " + this.hostname + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<ExtraHostEntry> {
            public String getDisplayName() {
                return "ExtraHostEntry";
            }
        }
    }

    public static class MountPointEntry
    extends AbstractDescribableImpl<MountPointEntry>
    implements Serializable {
        private static final long serialVersionUID = -5363412950753423854L;
        public String name;
        public String sourcePath;
        public String containerPath;
        public Boolean readOnly;

        @DataBoundConstructor
        public MountPointEntry(String name, String sourcePath, String containerPath, Boolean readOnly) {
            this.name = name;
            this.sourcePath = sourcePath;
            this.containerPath = containerPath;
            this.readOnly = readOnly;
        }

        public String toString() {
            return "MountPointEntry{name:" + this.name + ", sourcePath:" + this.sourcePath + ", containerPath:" + this.containerPath + ", readOnly:" + this.readOnly + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<MountPointEntry> {
            public String getDisplayName() {
                return "MountPointEntry";
            }
        }
    }

    public static class EFSMountPointEntry
    extends AbstractDescribableImpl<EFSMountPointEntry>
    implements Serializable {
        private static final long serialVersionUID = -7894407420920480113L;
        public String name;
        public String containerPath;
        public String fileSystemId;
        public String rootDirectory;
        public String accessPointId;
        public Boolean transitEncryption;
        public Boolean iam;
        public Boolean readOnly;

        @DataBoundConstructor
        public EFSMountPointEntry(String name, String containerPath, Boolean readOnly, String fileSystemId, String rootDirectory, String accessPointId, Boolean transitEncryption, Boolean iam) {
            this.name = name;
            this.containerPath = containerPath;
            this.readOnly = readOnly;
            this.fileSystemId = fileSystemId;
            this.rootDirectory = rootDirectory;
            this.accessPointId = accessPointId;
            this.transitEncryption = transitEncryption;
            this.iam = iam;
        }

        public String toString() {
            return "EFSMountPointEntry{name:" + this.name + ", containerPath:" + this.containerPath + ", readOnly:" + this.readOnly + ", fileSystemId:" + this.fileSystemId + ", rootDirectory:" + this.rootDirectory + ", accessPointId:" + this.accessPointId + ", transitEncryption:" + this.transitEncryption + ", iam:" + this.iam + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<EFSMountPointEntry> {
            private static final Logger LOGGER = Logger.getLogger(EFSMountPointEntry.class.getName());

            public String getDisplayName() {
                return "EFSMountPointEntry";
            }

            public ListBoxModel doFillFileSystemIdItems(@RelativePath(value="../..") @QueryParameter String credentialsId, @RelativePath(value="../..") @QueryParameter String regionName) {
                EFSService efsService = new EFSService(credentialsId, regionName);
                try {
                    List<FileSystemDescription> allFileSystems = efsService.getAllFileSystems();
                    allFileSystems.sort(Comparator.comparing(FileSystemDescription::getName, Comparator.nullsFirst(Comparator.naturalOrder())));
                    ListBoxModel options = new ListBoxModel();
                    for (FileSystemDescription fileSystemDescription : allFileSystems) {
                        options.add(this.optionalName(fileSystemDescription.getName(), fileSystemDescription.getFileSystemId()), fileSystemDescription.getFileSystemId());
                    }
                    return options;
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.INFO, "Exception fetching file systems for credentials=" + credentialsId + ", regionName=" + regionName, e);
                    return new ListBoxModel();
                }
            }

            public ListBoxModel doFillAccessPointIdItems(@RelativePath(value="../..") @QueryParameter String credentialsId, @RelativePath(value="../..") @QueryParameter String regionName, @QueryParameter String fileSystemId) {
                EFSService efsService = new EFSService(credentialsId, regionName);
                try {
                    List<AccessPointDescription> accessPoints = efsService.getAccessPointsForFileSystem(fileSystemId);
                    accessPoints.sort(Comparator.comparing(AccessPointDescription::getName, Comparator.nullsFirst(Comparator.naturalOrder())));
                    ListBoxModel options = new ListBoxModel();
                    options.add("None", "");
                    for (AccessPointDescription accessPointDescription : accessPoints) {
                        options.add(this.optionalName(accessPointDescription.getName(), accessPointDescription.getAccessPointId()), accessPointDescription.getAccessPointId());
                    }
                    return options;
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.INFO, "Exception fetching access points for credentials=" + credentialsId + ", regionName=" + regionName, e);
                    return new ListBoxModel();
                }
            }

            private String optionalName(String name, String id) {
                if (StringUtils.isEmpty((String)name)) {
                    return id;
                }
                return name + " (" + id + ")";
            }
        }
    }

    public static class PortMappingEntry
    extends AbstractDescribableImpl<PortMappingEntry>
    implements Serializable {
        private static final long serialVersionUID = 8223725139080497839L;
        public Integer containerPort;
        public Integer hostPort;
        public String protocol;

        @DataBoundConstructor
        public PortMappingEntry(Integer containerPort, Integer hostPort, String protocol) {
            this.containerPort = containerPort;
            this.hostPort = hostPort;
            this.protocol = protocol;
        }

        public String toString() {
            return "PortMappingEntry{containerPort=" + this.containerPort + ", hostPort=" + this.hostPort + ", protocol='" + this.protocol + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<PortMappingEntry> {
            public ListBoxModel doFillProtocolItems() {
                ListBoxModel options = new ListBoxModel();
                options.add("TCP", "tcp");
                options.add("UDP", "udp");
                return options;
            }

            public String getDisplayName() {
                return "PortMappingEntry";
            }
        }
    }

    public static class UlimitEntry
    extends AbstractDescribableImpl<UlimitEntry>
    implements Serializable {
        private static final long serialVersionUID = 8223725139080497838L;
        public Integer hardLimit;
        public Integer softLimit;
        public String ulimitName;

        @DataBoundConstructor
        public UlimitEntry(Integer softLimit, Integer hardLimit, String ulimitName) {
            this.softLimit = softLimit;
            this.hardLimit = hardLimit;
            this.ulimitName = ulimitName;
        }

        public String toString() {
            return "UlimitEntry{softLimit=" + this.softLimit + ", hardLimit=" + this.hardLimit + ", ulimitName='" + this.ulimitName + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<UlimitEntry> {
            public ListBoxModel doFillUlimitNameItems() {
                ListBoxModel options = new ListBoxModel();
                for (UlimitName ulimitName : UlimitName.values()) {
                    options.add(ulimitName.toString());
                }
                return options;
            }

            public String getDisplayName() {
                return "UlimitEntry";
            }
        }
    }

    public static class PlacementStrategyEntry
    extends AbstractDescribableImpl<PlacementStrategyEntry>
    implements Serializable {
        public String type;
        public String field;

        @DataBoundConstructor
        public PlacementStrategyEntry(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public String toString() {
            return "PlacementStrategyEntry{" + this.type + ": " + this.field + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<PlacementStrategyEntry> {
            public ListBoxModel doFillTypeItems() {
                ListBoxModel options = new ListBoxModel();
                for (PlacementStrategyType placementStrategyType : PlacementStrategyType.values()) {
                    options.add(placementStrategyType.toString());
                }
                return options;
            }

            public String getDisplayName() {
                return "PlacementStrategyEntry";
            }

            public FormValidation doCheckField(@QueryParameter(value="field") String field, @QueryParameter(value="type") String type) throws IOException, ServletException {
                if (!type.contentEquals("random") && field.isEmpty()) {
                    return FormValidation.error((String)"Field needs to be set when using Type other then random");
                }
                return FormValidation.ok();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ECSTaskTemplate> {
        private static String TEMPLATE_NAME_PATTERN = "[a-z|A-Z|0-9|_|-]{1,127}";

        public String getDisplayName() {
            return Messages.template();
        }

        public ListBoxModel doFillLaunchTypeItems() {
            ListBoxModel options = new ListBoxModel();
            for (LaunchType launchType : LaunchType.values()) {
                options.add(launchType.toString());
            }
            return options;
        }

        public ListBoxModel doFillOperatingSystemFamilyItems() {
            ListBoxModel options = new ListBoxModel();
            for (OSFamily operatingSystemFamily : OSFamily.values()) {
                options.add(operatingSystemFamily.toString());
            }
            return options;
        }

        public ListBoxModel doFillCpuArchitectureItems() {
            ListBoxModel options = new ListBoxModel();
            for (CPUArchitecture cpuArchitecture : CPUArchitecture.values()) {
                options.add(cpuArchitecture.toString());
            }
            return options;
        }

        public ListBoxModel doFillNetworkModeItems() {
            ListBoxModel options = new ListBoxModel();
            options.add("default");
            for (NetworkMode networkMode : NetworkMode.values()) {
                options.add(networkMode.toString());
            }
            return options;
        }

        public FormValidation doCheckTemplateName(@QueryParameter String value, @QueryParameter String taskDefinitionOverride) throws IOException, ServletException {
            if (!Strings.isNullOrEmpty((String)taskDefinitionOverride)) {
                return FormValidation.ok();
            }
            if (value.length() > 0 && value.length() <= 127 && value.matches(TEMPLATE_NAME_PATTERN)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Up to 127 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed");
        }

        public FormValidation doCheckSubnetsLaunchType(@QueryParameter(value="subnets") String subnets, @QueryParameter(value="launchType") String launchType) throws IOException, ServletException {
            if (launchType.contentEquals(LaunchType.FARGATE.toString())) {
                return FormValidation.error((String)"Subnets need to be set, when using FARGATE");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOperatingSystemFamilyLaunchType(@QueryParameter(value="operatingSystemFamily") String operatingSystemFamily, @QueryParameter(value="launchType") String launchType) throws IOException, ServletException {
            if (launchType.contentEquals(LaunchType.FARGATE.toString())) {
                return FormValidation.error((String)"Operating system family need to be set, when using FARGATE");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCpuArchitectureLaunchType(@QueryParameter(value="cpuArchitecture") String cpuArchitecture, @QueryParameter(value="launchType") String launchType) throws IOException, ServletException {
            if (launchType.contentEquals(LaunchType.FARGATE.toString())) {
                return FormValidation.error((String)"CPU architecture need to be set, when using FARGATE");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSubnetsNetworkMode(@QueryParameter(value="subnets") String subnets, @QueryParameter(value="networkMode") String networkMode) throws IOException, ServletException {
            if (networkMode.equals(NetworkMode.Awsvpc.toString()) && subnets.isEmpty()) {
                return FormValidation.error((String)"Subnets need to be set when using awsvpc network mode");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMemory(@QueryParameter(value="memory") int memory, @QueryParameter(value="memoryReservation") int memoryReservation, @QueryParameter String taskDefinitionOverride) throws IOException, ServletException {
            if (!Strings.isNullOrEmpty((String)taskDefinitionOverride)) {
                return FormValidation.ok();
            }
            return this.validateMemorySettings(memory, memoryReservation);
        }

        public FormValidation doCheckMemoryReservation(@QueryParameter(value="memory") int memory, @QueryParameter(value="memoryReservation") int memoryReservation, @QueryParameter String taskDefinitionOverride) throws IOException, ServletException {
            if (!Strings.isNullOrEmpty((String)taskDefinitionOverride)) {
                return FormValidation.ok();
            }
            return this.validateMemorySettings(memory, memoryReservation);
        }

        private FormValidation validateMemorySettings(int memory, int memoryReservation) {
            if (memory < 0 || memoryReservation < 0) {
                return FormValidation.error((String)"memory and/or memoryReservation must be 0 or a positive integer");
            }
            if (memory == 0 && memoryReservation == 0) {
                return FormValidation.error((String)"at least one of memory or memoryReservation are required to be > 0");
            }
            if (memory > 0 && memoryReservation > 0 && memory <= memoryReservation) {
                return FormValidation.error((String)"memory must be greater than memoryReservation if both are specified");
            }
            return FormValidation.ok();
        }
    }
}

