/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.TaskDefinition;
import com.cloudbees.jenkins.plugins.amazonecs.ECSLauncher;
import com.cloudbees.jenkins.plugins.amazonecs.ECSService;
import com.cloudbees.jenkins.plugins.amazonecs.ECSSlave;
import com.cloudbees.jenkins.plugins.amazonecs.ECSTaskTemplate;
import com.cloudbees.jenkins.plugins.amazonecs.Messages;
import com.cloudbees.jenkins.plugins.amazonecs.pipeline.TaskTemplateMap;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ECSCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(ECSCloud.class.getName());
    private List<ECSTaskTemplate> templates;
    private final String credentialsId;
    private final String cluster;
    private String regionName;
    private String assumedRoleArn;
    @CheckForNull
    private String tunnel;
    private String jenkinsUrl;
    private boolean retainAgents;
    private int retentionTimeout = 5;
    private int slaveTimeoutInSeconds = 900;
    private int taskPollingIntervalInSeconds = 1;
    private transient ECSService ecsService;
    private String allowedOverrides;
    private int maxCpu;
    private int maxMemory;
    private int maxMemoryReservation;
    private int maxAgents = 0;
    private int numExecutors = 1;

    @DataBoundConstructor
    public ECSCloud(String name, @Nonnull String credentialsId, String assumedRoleArn, String cluster) {
        super(name);
        this.credentialsId = credentialsId;
        this.assumedRoleArn = assumedRoleArn;
        this.cluster = cluster;
    }

    public ECSCloud(String name, String cluster, ECSService ecsService) {
        super(name);
        this.cluster = cluster;
        this.credentialsId = null;
        this.assumedRoleArn = null;
        this.ecsService = ecsService;
    }

    @Nonnull
    public static ECSCloud getByName(@Nonnull String name) throws IllegalArgumentException {
        Cloud cloud = Jenkins.get().clouds.getByName(name);
        if (cloud instanceof ECSCloud) {
            return (ECSCloud)cloud;
        }
        throw new IllegalArgumentException("'" + name + "' is not an ECS cloud but " + String.valueOf(cloud));
    }

    synchronized ECSService getEcsService() {
        if (this.ecsService == null) {
            this.ecsService = new ECSService(this.credentialsId, this.assumedRoleArn, this.regionName);
        }
        return this.ecsService;
    }

    @Nonnull
    public List<ECSTaskTemplate> getTemplates() {
        return this.templates != null ? this.templates : Collections.emptyList();
    }

    @Nonnull
    private List<ECSTaskTemplate> getAllTemplates() {
        List<ECSTaskTemplate> dynamicTemplates = TaskTemplateMap.get().getTemplates(this);
        CopyOnWriteArrayList<ECSTaskTemplate> allTemplates = new CopyOnWriteArrayList<ECSTaskTemplate>();
        allTemplates.addAll(dynamicTemplates);
        if (this.templates != null) {
            allTemplates.addAll(this.templates);
        }
        return allTemplates;
    }

    @DataBoundSetter
    public void setTemplates(List<ECSTaskTemplate> templates) {
        this.templates = templates;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getAssumedRoleArn() {
        return this.assumedRoleArn;
    }

    @DataBoundSetter
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @DataBoundSetter
    public void setAssumedRoleArn(String assumedRoleArn) {
        this.assumedRoleArn = assumedRoleArn;
    }

    public String getTunnel() {
        return this.tunnel;
    }

    @DataBoundSetter
    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    @DataBoundSetter
    public void setAllowedOverrides(@Nonnull String allowedOverrides) {
        this.allowedOverrides = allowedOverrides.equals("") ? null : allowedOverrides;
    }

    @Nonnull
    public String getAllowedOverrides() {
        return this.allowedOverrides == null ? "" : this.allowedOverrides;
    }

    public boolean isAllowedOverride(String override) {
        List<String> allowedOverridesList = Arrays.asList(this.getAllowedOverrides().toLowerCase().replaceAll(" ", "").split(","));
        if (allowedOverridesList.contains("all")) {
            return true;
        }
        return allowedOverridesList.contains(override.toLowerCase());
    }

    public String isCustomTaskDefinition(String label) {
        return this.getTemplate(label).getTaskDefinitionOverride();
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public boolean canProvision(String label) {
        return this.getTemplate(label) != null;
    }

    public int getProvisioningCapacity(int excessWorkload, int onlineExecutors, int connectingExecutors) {
        if (this.maxAgents == 0) {
            return excessWorkload;
        }
        try {
            int n = Math.subtractExact(Math.addExact(onlineExecutors, connectingExecutors), this.maxAgents);
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Overflow encountered when calculating agent capacity.", e);
            return 0;
        }
        int currentAgentCapacity = this.maxAgents - (onlineExecutors + connectingExecutors);
        return Math.max(0, Math.min(excessWorkload, currentAgentCapacity));
    }

    private ECSTaskTemplate getTemplate(Label label) {
        if (label == null) {
            return null;
        }
        for (ECSTaskTemplate t : this.getAllTemplates()) {
            if (!label.matches(t.getLabelSet())) continue;
            return t;
        }
        return null;
    }

    public ECSTaskTemplate getTemplate(String label) {
        return Optional.ofNullable(label).map(Label::parse).flatMap(atoms -> this.getAllTemplates().stream().filter(t -> t.getLabelSet().stream().anyMatch(l -> l.matches((Collection)atoms))).findFirst()).orElse(null);
    }

    public ECSTaskTemplate findParentTemplate(String parentLabel) {
        ECSTaskTemplate result = null;
        if (parentLabel == null) {
            LOGGER.log(Level.INFO, "No parent label supplied, looking for TaskTemplate with label 'template-default'");
            result = this.getTemplate("template-default");
            if (result == null) {
                LOGGER.log(Level.INFO, "No task template label of 'template-default' found, searching by name 'template-default'");
                result = this.getTemplateByName("template-default");
            }
        }
        return result != null ? result : this.getTemplate(parentLabel);
    }

    private ECSTaskTemplate getTemplateByName(String templateName) {
        return this.getAllTemplates().stream().filter(t -> t.getTemplateName().equals(templateName)).findFirst().orElse(null);
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        LOGGER.log(Level.INFO, "Asked to provision {0} agent(s) for: {1}", new Object[]{excessWorkload, label});
        ArrayList result = new ArrayList();
        ECSTaskTemplate template = this.getTemplate(label);
        if (template != null) {
            String parentLabel = template.getInheritFrom();
            ECSTaskTemplate merged = template.merge(this.getTemplate(parentLabel));
            for (int i = 1; i <= excessWorkload; ++i) {
                String agentName = this.name + "-" + label.getName() + "-" + RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
                LOGGER.log(Level.INFO, "Will provision {0}, for label: {1}", new Object[]{agentName, label});
                result.add(new NodeProvisioner.PlannedNode(agentName, Computer.threadPoolForRemoting.submit(new ProvisioningCallback(merged, agentName)), this.numExecutors));
            }
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public int getSlaveTimeoutInSeconds() {
        if (this.slaveTimeoutInSeconds == 0) {
            return 900;
        }
        return this.slaveTimeoutInSeconds;
    }

    @DataBoundSetter
    public void setSlaveTimeoutInSeconds(int slaveTimeoutInSeconds) {
        this.slaveTimeoutInSeconds = slaveTimeoutInSeconds;
    }

    public boolean getRetainAgents() {
        return this.retainAgents;
    }

    @DataBoundSetter
    public void setRetainAgents(boolean retainAgents) {
        this.retainAgents = retainAgents;
    }

    public int getRetentionTimeout() {
        if (this.retentionTimeout == 0) {
            return 5;
        }
        return this.retentionTimeout;
    }

    @DataBoundSetter
    public void setRetentionTimeout(int retentionTimeout) {
        this.retentionTimeout = retentionTimeout;
    }

    public int getTaskPollingIntervalInSeconds() {
        if (this.taskPollingIntervalInSeconds == 0) {
            return 1;
        }
        return this.taskPollingIntervalInSeconds;
    }

    @DataBoundSetter
    public void setTaskPollingIntervalInSeconds(int taskPollingIntervalInSeconds) {
        this.taskPollingIntervalInSeconds = taskPollingIntervalInSeconds;
    }

    public int getMaxCpu() {
        return this.maxCpu;
    }

    @DataBoundSetter
    public void setMaxCpu(int maxCpu) {
        this.maxCpu = maxCpu;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    @DataBoundSetter
    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public int getMaxMemoryReservation() {
        return this.maxMemoryReservation;
    }

    @DataBoundSetter
    public void setMaxMemoryReservation(int maxMemoryReservation) {
        this.maxMemoryReservation = maxMemoryReservation;
    }

    public int getMaxAgents() {
        return this.maxAgents;
    }

    @DataBoundSetter
    public void setMaxAgents(int maxAgents) {
        this.maxAgents = maxAgents;
    }

    public void addTemplate(ECSTaskTemplate taskTemplate) {
        List<ECSTaskTemplate> nonDynamic = this.getTemplates();
        CopyOnWriteArrayList<ECSTaskTemplate> result = new CopyOnWriteArrayList<ECSTaskTemplate>();
        result.addAll(nonDynamic);
        result.add(taskTemplate);
        this.setTemplates(result);
    }

    public static Region getRegion(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            return RegionUtils.getRegion((String)regionName);
        }
        return Region.getRegion((Regions)Regions.US_EAST_1);
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        if (StringUtils.isNotBlank((String)jenkinsUrl)) {
            this.jenkinsUrl = jenkinsUrl;
        } else {
            JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
            if (config != null) {
                this.jenkinsUrl = config.getUrl();
            }
        }
    }

    public ECSTaskTemplate addDynamicTemplate(ECSTaskTemplate template) {
        TaskDefinition taskDefinition = this.getEcsService().registerTemplate(this.getDisplayName(), template);
        if (taskDefinition != null) {
            LOGGER.log(Level.INFO, String.format("Task definition created or found: ARN: %s", taskDefinition.getTaskDefinitionArn()));
            template.setDynamicTaskDefinition(taskDefinition.getTaskDefinitionArn());
            TaskTemplateMap.get().addTemplate(this, template);
        }
        return template;
    }

    public void removeDynamicTemplate(ECSTaskTemplate template) {
        this.getEcsService().removeTemplate(template);
        TaskTemplateMap.get().removeTemplate(this, template);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public static final int DEFAULT_RETENTION_TIMEOUT = 5;
        public static final int DEFAULT_SLAVE_TIMEOUT_IN_SECONDS = 900;
        public static final int DEFAULT_TASK_POLLING_INTERVAL_IN_SECONDS = 1;
        public static final String DEFAULT_ALLOWED_OVERRIDES = "";
        private static String CLOUD_NAME_PATTERN = "[a-z|A-Z|0-9|_|-]{1,127}";
        private static final int DEFAULT_MAXIMUM_AGENTS = 0;
        private static final int DEFAULT_NUM_EXECUTORS = 1;

        public String getDisplayName() {
            return Messages.displayName();
        }

        public ListBoxModel doFillCredentialsIdItems() {
            return AWSCredentialsHelper.doFillCredentialsIdItems((ItemGroup)Jenkins.get());
        }

        public ListBoxModel doFillRegionNameItems() {
            ListBoxModel options = new ListBoxModel();
            for (Region region : RegionUtils.getRegions()) {
                options.add(region.getName());
            }
            return options;
        }

        public ListBoxModel doFillClusterItems(@QueryParameter String credentialsId, @QueryParameter String assumedRoleArn, @QueryParameter String regionName) {
            ECSService ecsService = new ECSService(credentialsId, assumedRoleArn, regionName);
            try {
                ListClustersResult result;
                AmazonECS client = ecsService.getAmazonECSClient();
                ArrayList allClusterArns = new ArrayList();
                String lastToken = null;
                do {
                    result = client.listClusters(new ListClustersRequest().withNextToken(lastToken));
                    allClusterArns.addAll(result.getClusterArns());
                } while ((lastToken = result.getNextToken()) != null);
                Collections.sort(allClusterArns);
                ListBoxModel options = new ListBoxModel();
                for (String arn : allClusterArns) {
                    options.add(arn);
                }
                return options;
            }
            catch (AmazonClientException e) {
                LOGGER.log(Level.INFO, "Exception searching clusters for credentials=" + credentialsId + ", regionName=" + regionName + ":" + String.valueOf((Object)e));
                LOGGER.log(Level.FINE, "Exception searching clusters for credentials=" + credentialsId + ", regionName=" + regionName, e);
                return new ListBoxModel();
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.INFO, "Exception searching clusters for credentials=" + credentialsId + ", regionName=" + regionName, e);
                return new ListBoxModel();
            }
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() > 0 && value.length() <= 127 && value.matches(CLOUD_NAME_PATTERN)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Up to 127 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed");
        }

        public FormValidation doCheckRetentionTimeout(@QueryParameter Integer value) throws IOException, ServletException {
            if (value > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Needs to be greater than 0");
        }
    }

    private class ProvisioningCallback
    implements Callable<Node> {
        private final ECSTaskTemplate template;
        private final String agentName;

        public ProvisioningCallback(ECSTaskTemplate template, String agentName) {
            this.template = template;
            this.agentName = agentName;
        }

        @Override
        public Node call() throws Exception {
            return new ECSSlave(ECSCloud.this, this.agentName, this.template, (ComputerLauncher)new ECSLauncher(ECSCloud.this, ECSCloud.this.tunnel, null));
        }
    }
}

