// CHECKSTYLE:OFF

package com.cloudbees.jenkins.plugins.amazonecs;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code template}: {@code ECS Task template}.
     * 
     * @return
     *     {@code ECS Task template}
     */
    public static String template() {
        return holder.format("template");
    }

    /**
     * Key {@code template}: {@code ECS Task template}.
     * 
     * @return
     *     {@code ECS Task template}
     */
    public static Localizable _template() {
        return new Localizable(holder, "template");
    }

    /**
     * Key {@code displayName}: {@code Amazon EC2 Container Service Cloud}.
     * 
     * @return
     *     {@code Amazon EC2 Container Service Cloud}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Amazon EC2 Container Service Cloud}.
     * 
     * @return
     *     {@code Amazon EC2 Container Service Cloud}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

}
