/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs.pipeline;

import com.cloudbees.jenkins.plugins.amazonecs.ECSCloud;
import com.cloudbees.jenkins.plugins.amazonecs.ECSTaskTemplate;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Extension
public class TaskTemplateMap {
    private static final Logger LOGGER = Logger.getLogger(TaskTemplateMap.class.getName());
    private Map<String, List<ECSTaskTemplate>> map = new CopyOnWriteMap.Hash();

    public static TaskTemplateMap get() {
        return (TaskTemplateMap)ExtensionList.lookup(TaskTemplateMap.class).get(TaskTemplateMap.class);
    }

    @Nonnull
    public List<ECSTaskTemplate> getTemplates(@Nonnull ECSCloud cloud) {
        return Collections.unmodifiableList(this.getOrCreateTemplateList(cloud));
    }

    private List<ECSTaskTemplate> getOrCreateTemplateList(@Nonnull ECSCloud cloud) {
        CopyOnWriteArrayList TaskTemplates = this.map.get(cloud.name);
        return TaskTemplates == null ? new CopyOnWriteArrayList() : TaskTemplates;
    }

    public void addTemplate(@Nonnull ECSCloud cloud, @Nonnull ECSTaskTemplate TaskTemplate) {
        List<ECSTaskTemplate> list = this.getOrCreateTemplateList(cloud);
        list.add(TaskTemplate);
        this.map.put(cloud.name, list);
    }

    public void removeTemplate(@Nonnull ECSCloud cloud, @Nonnull ECSTaskTemplate TaskTemplate) {
        this.getOrCreateTemplateList(cloud).remove(TaskTemplate);
    }
}

