/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.amazonaws.services.ecs.model.AccessDeniedException;
import com.amazonaws.services.ecs.model.ClientException;
import com.amazonaws.services.ecs.model.ClusterNotFoundException;
import com.amazonaws.services.ecs.model.InvalidParameterException;
import com.amazonaws.services.ecs.model.ServerException;
import com.amazonaws.services.ecs.model.Task;
import com.cloudbees.jenkins.plugins.amazonecs.ECSCloud;
import com.cloudbees.jenkins.plugins.amazonecs.ECSComputer;
import com.cloudbees.jenkins.plugins.amazonecs.ECSTaskTemplate;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;

public class ECSSlave
extends AbstractCloudSlave {
    private static final long serialVersionUID = -6324547877157811307L;
    private static final Logger LOGGER = Logger.getLogger(ECSSlave.class.getName());
    private static final HashSet<String> upTaskStatuses = new HashSet<String>(Arrays.asList("PROVISIONING", "PENDING", "ACTIVATING", "RUNNING"));
    private static final HashSet<String> downTaskStatuses = new HashSet<String>(Arrays.asList("DEACTIVATING", "STOPPING", "DEPROVISIONING", "STOPPED", "DELETED"));
    @Nonnull
    private final ECSCloud cloud;
    @Nonnull
    private final ECSTaskTemplate template;
    private String clusterArn;
    private String taskDefinitonArn;
    @CheckForNull
    private String taskArn;
    private boolean survivable = true;

    public ECSSlave(@Nonnull ECSCloud cloud, @Nonnull String name, ECSTaskTemplate template, @Nonnull ComputerLauncher launcher) throws Descriptor.FormException, IOException {
        super(name, "ECS Agent", template.makeRemoteFSRoot(name), Math.max(1, cloud.getNumExecutors()), Node.Mode.EXCLUSIVE, template.getLabel(), launcher, (RetentionStrategy)(cloud.getRetainAgents() ? new CloudRetentionStrategy(cloud.getRetentionTimeout()) : new OnceRetentionStrategy(cloud.getRetentionTimeout())), Collections.emptyList());
        this.cloud = cloud;
        this.template = template;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public String getTaskDefinitonArn() {
        return this.taskDefinitonArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public ECSTaskTemplate getTemplate() {
        return this.template;
    }

    void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public void setTaskDefinitonArn(String taskDefinitonArn) {
        this.taskDefinitonArn = taskDefinitonArn;
    }

    public boolean isSurvivable() {
        if (!this.survivable) {
            return false;
        }
        Task task = this.cloud.getEcsService().describeTask(this.taskArn, this.clusterArn);
        if (task == null) {
            this.survivable = false;
            return false;
        }
        String lastStatus = task.getLastStatus();
        String desiredStatus = task.getDesiredStatus();
        LOGGER.log(Level.FINE, "Task {0} last status={1}, desired status={2}", new Object[]{this.taskArn, lastStatus, desiredStatus});
        if (upTaskStatuses.contains(lastStatus) && !downTaskStatuses.contains(desiredStatus)) {
            return true;
        }
        this.survivable = false;
        return false;
    }

    public AbstractCloudComputer<ECSSlave> createComputer() {
        return new ECSComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        if (this.taskArn == null) {
            throw new IllegalArgumentException("taskArn is null");
        }
        if (this.clusterArn == null) {
            throw new IllegalArgumentException("clusterArn is null");
        }
        try {
            LOGGER.log(Level.INFO, "[{0}]: Stopping: TaskArn {1}, ClusterArn {2}", new Object[]{this.getNodeName(), this.taskArn, this.clusterArn});
            this.cloud.getEcsService().stopTask(this.taskArn, this.clusterArn);
        }
        catch (ServerException ex) {
            LOGGER.log(Level.WARNING, MessageFormat.format("[{0}]: Failed to stop Task {1}", this.getNodeName(), this.taskArn), ex);
        }
        catch (AccessDeniedException ex) {
            LOGGER.log(Level.WARNING, MessageFormat.format("[{0}]: No permission to stop task {1}", this.getNodeName(), this.taskArn), ex);
        }
        catch (ClientException ex) {
            LOGGER.log(Level.WARNING, MessageFormat.format("[{0}]: Failed to stop Task {1} due {2}", this.getNodeName(), this.taskArn, ex.getErrorMessage()), ex);
        }
        catch (InvalidParameterException ex) {
            LOGGER.log(Level.WARNING, MessageFormat.format("[{0}]: Failed to stop Task {1}", this.getNodeName(), this.taskArn), ex);
        }
        catch (ClusterNotFoundException ex) {
            LOGGER.log(Level.WARNING, MessageFormat.format("[{0}]: Cluster {1} not found", this.getNodeName(), this.clusterArn));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

