/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.AmazonECSClientBuilder;
import com.amazonaws.services.ecs.model.AwsVpcConfiguration;
import com.amazonaws.services.ecs.model.ClientException;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.EphemeralStorage;
import com.amazonaws.services.ecs.model.KernelCapabilities;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.LaunchType;
import com.amazonaws.services.ecs.model.LinuxParameters;
import com.amazonaws.services.ecs.model.ListTagsForResourceRequest;
import com.amazonaws.services.ecs.model.ListTagsForResourceResult;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.services.ecs.model.NetworkConfiguration;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RepositoryCredentials;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.RuntimePlatform;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.Task;
import com.amazonaws.services.ecs.model.TaskDefinition;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.services.ecs.waiters.AmazonECSWaiters;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterParameters;
import com.cloudbees.jenkins.plugins.amazonecs.ECSCloud;
import com.cloudbees.jenkins.plugins.amazonecs.ECSSlave;
import com.cloudbees.jenkins.plugins.amazonecs.ECSTaskTemplate;
import com.cloudbees.jenkins.plugins.amazonecs.aws.BaseAWSService;
import com.cloudbees.jenkins.plugins.amazonecs.aws.MaxTimeRetryStrategy;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import hudson.AbortException;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ECSService
extends BaseAWSService {
    private static final Logger LOGGER = Logger.getLogger(ECSCloud.class.getName());
    private static final String AWS_TAG_JENKINS_LABEL_KEY = "jenkins.label";
    private static final String AWS_TAG_JENKINS_TEMPLATENAME_KEY = "jenkins.templatename";
    @Nonnull
    private final Supplier<AmazonECS> clientSupplier;

    public ECSService(String credentialsId, String assumedRoleArn, String regionName) {
        this.clientSupplier = () -> {
            AmazonECSClientBuilder builder = (AmazonECSClientBuilder)((AmazonECSClientBuilder)AmazonECSClientBuilder.standard().withClientConfiguration(this.createClientConfiguration())).withRegion(regionName);
            AmazonWebServicesCredentials credentials = this.getCredentials(credentialsId);
            if (credentials != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    String awsAccessKeyId = credentials.getCredentials().getAWSAccessKeyId();
                    String obfuscatedAccessKeyId = StringUtils.left((String)awsAccessKeyId, (int)4) + StringUtils.repeat((String)"*", (int)(awsAccessKeyId.length() - 8)) + StringUtils.right((String)awsAccessKeyId, (int)4);
                    LOGGER.log(Level.FINE, "Connect to Amazon ECS with IAM Access Key {1}", new Object[]{obfuscatedAccessKeyId});
                }
                builder.withCredentials((AWSCredentialsProvider)credentials);
            } else if (StringUtils.isNotBlank((String)assumedRoleArn)) {
                builder.withCredentials((AWSCredentialsProvider)this.getCredentialsForRole(assumedRoleArn, regionName));
            }
            LOGGER.log(Level.FINE, "Selected Region: {0}", regionName);
            return (AmazonECS)builder.build();
        };
    }

    @CheckForNull
    private AWSStaticCredentialsProvider getCredentialsForRole(String roleArn, String regionName) {
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(regionName)).build();
        AssumeRoleRequest roleRequest = new AssumeRoleRequest().withRoleArn(roleArn).withRoleSessionName("jenkins-role-session");
        AssumeRoleResult roleResponse = stsClient.assumeRole(roleRequest);
        Credentials sessionCredentials = roleResponse.getCredentials();
        BasicSessionCredentials awsCredentials = new BasicSessionCredentials(sessionCredentials.getAccessKeyId(), sessionCredentials.getSecretAccessKey(), sessionCredentials.getSessionToken());
        return new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
    }

    public ECSService(Supplier<AmazonECS> clientSupplier) {
        this.clientSupplier = clientSupplier;
    }

    AmazonECS getAmazonECSClient() {
        return this.clientSupplier.get();
    }

    public Task describeTask(String taskArn, String clusterArn) {
        AmazonECS client = this.clientSupplier.get();
        DescribeTasksResult result = client.describeTasks(new DescribeTasksRequest().withCluster(clusterArn).withTasks(new String[]{taskArn}));
        if (result.getTasks().size() == 0) {
            return null;
        }
        return (Task)result.getTasks().get(0);
    }

    public void waitForTasksRunning(String tasksArn, String clusterArn, long timeoutInMillis, int DelayBetweenPollsInSeconds) {
        AmazonECS client = this.clientSupplier.get();
        Waiter describeTaskWaiter = new AmazonECSWaiters(client).tasksRunning();
        describeTaskWaiter.run(new WaiterParameters((AmazonWebServiceRequest)((DescribeTasksRequest)new DescribeTasksRequest().withTasks(new String[]{tasksArn}).withCluster(clusterArn).withSdkClientExecutionTimeout((int)timeoutInMillis))).withPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxTimeRetryStrategy(timeoutInMillis), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(DelayBetweenPollsInSeconds))));
    }

    public void stopTask(String taskArn, String clusterArn) {
        AmazonECS client = this.clientSupplier.get();
        LOGGER.log(Level.INFO, "Delete ECS agent task: {0}", taskArn);
        try {
            client.stopTask(new StopTaskRequest().withTask(taskArn).withCluster(clusterArn).withReason("Stopped by Jenkins Amazon ECS PlugIn"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Couldn't stop task arn " + taskArn + " caught exception: " + e.getMessage(), e);
        }
    }

    TaskDefinition registerTemplate(String cloudName, ECSTaskTemplate template) {
        if (template.getTaskDefinitionOverride() != null) {
            TaskDefinition overrideTaskDefinition = this.findTaskDefinition(template.getTaskDefinitionOverride());
            if (overrideTaskDefinition == null) {
                LOGGER.log(Level.SEVERE, "Could not find task definition override: {0} for template: {1}", new Object[]{template.getTaskDefinitionOverride(), template.getDisplayName()});
                throw new RuntimeException("Could not find task definition override family or ARN: " + template.getTaskDefinitionOverride());
            }
            LOGGER.log(Level.FINE, "Found task definition override: {0}", new Object[]{overrideTaskDefinition.getTaskDefinitionArn()});
            return overrideTaskDefinition;
        }
        if (template.getDynamicTaskDefinition() != null) {
            TaskDefinition overrideTaskDefinition = this.findTaskDefinition(template.getDynamicTaskDefinition());
            if (overrideTaskDefinition != null) {
                LOGGER.log(Level.FINE, "Found dynamic agent task definition: {0}", new Object[]{overrideTaskDefinition.getTaskDefinitionArn()});
                return overrideTaskDefinition;
            }
            LOGGER.log(Level.WARNING, "Could not find dynamic agent's task definition family or ARN: {0}, creating a new one.", new Object[]{template.getDynamicTaskDefinition()});
        }
        AmazonECS client = this.clientSupplier.get();
        String familyName = this.fullQualifiedTemplateName(cloudName, template);
        ContainerDefinition def = new ContainerDefinition().withName(familyName).withImage(template.getImage()).withEnvironment(template.getEnvironmentKeyValuePairs()).withExtraHosts(template.getExtraHostEntries()).withMountPoints(template.getMountPointEntries()).withPortMappings(template.getPortMappingEntries()).withCpu(Integer.valueOf(template.getCpu())).withUlimits(template.getUlimitsEntries()).withPrivileged(Boolean.valueOf(template.getPrivileged())).withEssential(Boolean.valueOf(true));
        if (template.getMemoryReservation() > 0) {
            def.withMemoryReservation(Integer.valueOf(template.getMemoryReservation()));
        }
        if (template.getMemory() > 0) {
            def.withMemory(Integer.valueOf(template.getMemory()));
        }
        if (template.getDnsSearchDomains() != null) {
            def.withDnsSearchDomains(StringUtils.split((String)template.getDnsSearchDomains()));
        }
        if (template.getEntrypoint() != null) {
            def.withEntryPoint(StringUtils.split((String)template.getEntrypoint()));
        }
        if (template.getJvmArgs() != null) {
            def.withEnvironment(new KeyValuePair[]{new KeyValuePair().withName("JAVA_OPTS").withValue(template.getJvmArgs())}).withEssential(Boolean.valueOf(true));
        }
        if (template.getContainerUser() != null) {
            def.withUser(template.getContainerUser());
        }
        if (template.getKernelCapabilities() != null) {
            def.withLinuxParameters(new LinuxParameters().withCapabilities(new KernelCapabilities().withAdd(Arrays.asList(template.getKernelCapabilities().split(",")))));
        }
        if (template.getRepositoryCredentials() != null) {
            def.withRepositoryCredentials(new RepositoryCredentials().withCredentialsParameter(template.getRepositoryCredentials()));
        }
        if (template.getLogDriver() != null) {
            LogConfiguration logConfig = new LogConfiguration();
            logConfig.setLogDriver(template.getLogDriver());
            logConfig.setOptions(template.getLogDriverOptionsMap());
            def.withLogConfiguration(logConfig);
        }
        if (template.getSharedMemorySize() > 0) {
            def.withLinuxParameters(new LinuxParameters().withSharedMemorySize(Integer.valueOf(template.getSharedMemorySize())));
        }
        TaskDefinition currentTaskDefinition = this.findTaskDefinition(familyName);
        boolean templateTagsMatchesExistingTags = false;
        boolean templateMatchesExistingContainerDefinition = false;
        boolean templateMatchesExistingVolumes = false;
        boolean templateMatchesExistingTaskRole = false;
        boolean templateMatchesExistingExecutionRole = false;
        boolean templateMatchesExistingNetworkMode = false;
        if (currentTaskDefinition != null) {
            ContainerDefinition currentContainerDefinition = (ContainerDefinition)currentTaskDefinition.getContainerDefinitions().get(0);
            List<Tag> tags = this.getTaskDefinitionTags(currentTaskDefinition.getTaskDefinitionArn());
            templateTagsMatchesExistingTags = ObjectUtils.equals(template.getTags(), tags);
            LOGGER.log(Level.INFO, "Match on tags: {0}", new Object[]{templateTagsMatchesExistingTags});
            LOGGER.log(Level.FINE, "Match on tags: {0}; template={1}; last={2}", new Object[]{templateTagsMatchesExistingTags, template.getTags(), tags});
            templateMatchesExistingContainerDefinition = def.equals((Object)currentContainerDefinition);
            LOGGER.log(Level.INFO, "Match on container definition: {0}", new Object[]{templateMatchesExistingContainerDefinition});
            LOGGER.log(Level.FINE, "Match on container definition: {0}; template={1}; last={2}", new Object[]{templateMatchesExistingContainerDefinition, def, currentContainerDefinition});
            templateMatchesExistingVolumes = ObjectUtils.equals(template.getVolumeEntries(), (Object)currentTaskDefinition.getVolumes());
            LOGGER.log(Level.INFO, "Match on volumes: {0}", new Object[]{templateMatchesExistingVolumes});
            LOGGER.log(Level.FINE, "Match on volumes: {0}; template={1}; last={2}", new Object[]{templateMatchesExistingVolumes, template.getVolumeEntries(), currentTaskDefinition.getVolumes()});
            templateMatchesExistingTaskRole = StringUtils.equals((String)StringUtils.defaultString((String)template.getTaskrole()), (String)StringUtils.defaultString((String)currentTaskDefinition.getTaskRoleArn()));
            LOGGER.log(Level.INFO, "Match on task role: {0}", new Object[]{templateMatchesExistingTaskRole});
            LOGGER.log(Level.FINE, "Match on task role: {0}; template={1}; last={2}", new Object[]{templateMatchesExistingTaskRole, template.getTaskrole(), currentTaskDefinition.getTaskRoleArn()});
            templateMatchesExistingExecutionRole = StringUtils.equals((String)StringUtils.defaultString((String)template.getExecutionRole()), (String)StringUtils.defaultString((String)currentTaskDefinition.getExecutionRoleArn()));
            LOGGER.log(Level.INFO, "Match on execution role: {0}", new Object[]{templateMatchesExistingExecutionRole});
            LOGGER.log(Level.FINE, "Match on execution role: {0}; template={1}; last={2}", new Object[]{templateMatchesExistingExecutionRole, template.getExecutionRole(), currentTaskDefinition.getExecutionRoleArn()});
            String templateNetworkMode = "";
            if (StringUtils.equals((String)StringUtils.defaultString((String)template.getNetworkMode()), (String)"default")) {
                templateMatchesExistingNetworkMode = null == currentTaskDefinition.getNetworkMode();
                templateNetworkMode = "null";
            } else {
                templateMatchesExistingNetworkMode = StringUtils.equals((String)StringUtils.defaultString((String)template.getNetworkMode()), (String)StringUtils.defaultString((String)currentTaskDefinition.getNetworkMode()));
                templateNetworkMode = template.getNetworkMode();
            }
            LOGGER.log(Level.INFO, "Match on network mode: {0}", new Object[]{templateMatchesExistingNetworkMode});
            LOGGER.log(Level.FINE, "Match on network mode: {0}; template={1}; last={2}", new Object[]{templateMatchesExistingNetworkMode, templateNetworkMode, currentTaskDefinition.getNetworkMode()});
        }
        if (templateMatchesExistingContainerDefinition && templateMatchesExistingVolumes && templateMatchesExistingTaskRole && templateMatchesExistingExecutionRole && templateMatchesExistingNetworkMode) {
            LOGGER.log(Level.FINE, "Task Definition already exists: {0}", new Object[]{currentTaskDefinition.getTaskDefinitionArn()});
            return currentTaskDefinition;
        }
        Tag jenkinsLabelTag = new Tag().withKey(AWS_TAG_JENKINS_LABEL_KEY).withValue(template.getLabel());
        Tag jenkinsTemplateNameTag = new Tag().withKey(AWS_TAG_JENKINS_TEMPLATENAME_KEY).withValue(template.getTemplateName());
        ArrayList<Tag> taskDefinitionTags = new ArrayList<Tag>();
        taskDefinitionTags.add(jenkinsLabelTag);
        taskDefinitionTags.add(jenkinsTemplateNameTag);
        if (template.getTags() != null) {
            for (ECSTaskTemplate.Tag tag : template.getTags()) {
                taskDefinitionTags.add(new Tag().withKey(tag.name).withValue(tag.value));
            }
        }
        RegisterTaskDefinitionRequest request = new RegisterTaskDefinitionRequest().withFamily(familyName).withVolumes(template.getVolumeEntries()).withTags(taskDefinitionTags).withContainerDefinitions(new ContainerDefinition[]{def});
        if (!StringUtils.equals((String)StringUtils.defaultString((String)template.getNetworkMode()), (String)"default")) {
            request.withNetworkMode(template.getNetworkMode());
        }
        if (!StringUtils.isEmpty((String)template.getExecutionRole())) {
            request.withExecutionRoleArn(template.getExecutionRole());
        }
        if (!StringUtils.isEmpty((String)template.getTaskrole())) {
            request.withTaskRoleArn(template.getTaskrole());
        }
        if (template.isFargate()) {
            request.withRuntimePlatform(new RuntimePlatform().withOperatingSystemFamily(template.getOperatingSystemFamily()).withCpuArchitecture(template.getCpuArchitecture())).withRequiresCompatibilities(new String[]{LaunchType.FARGATE.toString()}).withNetworkMode(NetworkMode.Awsvpc.toString()).withMemory(String.valueOf(template.getMemoryConstraint())).withCpu(String.valueOf(template.getCpu()));
            if (template.getEphemeralStorageSizeInGiB() != null && template.getEphemeralStorageSizeInGiB() > 0) {
                request.withEphemeralStorage(new EphemeralStorage().withSizeInGiB(template.getEphemeralStorageSizeInGiB()));
            }
        }
        RegisterTaskDefinitionResult result = client.registerTaskDefinition(request);
        LOGGER.log(Level.FINE, "Created Task Definition {0}: {1}", new Object[]{result.getTaskDefinition(), request});
        LOGGER.log(Level.INFO, "Created Task Definition: {0}", new Object[]{result.getTaskDefinition()});
        if (template.getDynamicTaskDefinition() != null) {
            template.setDynamicTaskDefinition(result.getTaskDefinition().getTaskDefinitionArn());
        }
        return result.getTaskDefinition();
    }

    void removeTemplate(ECSTaskTemplate template) {
        AmazonECS client = this.clientSupplier.get();
        if (template.getTaskDefinitionOverride() != null) {
            return;
        }
        String taskDefinitionArn = template.getDynamicTaskDefinition();
        try {
            if (taskDefinitionArn != null) {
                client.deregisterTaskDefinition(new DeregisterTaskDefinitionRequest().withTaskDefinition(taskDefinitionArn));
            }
        }
        catch (ClientException e) {
            LOGGER.log(Level.WARNING, "Error de-registering task definition: " + taskDefinitionArn, e);
        }
    }

    TaskDefinition findTaskDefinition(String familyOrArn) {
        AmazonECS client = this.clientSupplier.get();
        try {
            DescribeTaskDefinitionResult result = client.describeTaskDefinition(new DescribeTaskDefinitionRequest().withTaskDefinition(familyOrArn));
            return result.getTaskDefinition();
        }
        catch (ClientException e) {
            LOGGER.log(Level.FINE, "No existing task definition found for family or ARN: " + familyOrArn, e);
            LOGGER.log(Level.INFO, "No existing task definition found for family or ARN: " + familyOrArn);
            return null;
        }
    }

    List<Tag> getTaskDefinitionTags(String taskDefinitionArn) {
        AmazonECS client = this.clientSupplier.get();
        try {
            ListTagsForResourceResult tagsResult = client.listTagsForResource(new ListTagsForResourceRequest().withResourceArn(taskDefinitionArn));
            return tagsResult.getTags();
        }
        catch (ClientException e) {
            LOGGER.log(Level.FINE, "No existing task definition found for ARN: " + taskDefinitionArn, e);
            LOGGER.log(Level.INFO, "No existing task definition found for ARN: " + taskDefinitionArn);
            return null;
        }
    }

    private String fullQualifiedTemplateName(String cloudName, ECSTaskTemplate template) {
        return cloudName.replaceAll("\\s+", "") + "-" + template.getTemplateName();
    }

    RunTaskResult runEcsTask(ECSSlave agent, ECSTaskTemplate template, String clusterArn, Collection<String> command, TaskDefinition taskDefinition) throws IOException, AbortException {
        String agentContainerName;
        AmazonECS client = this.clientSupplier.get();
        agent.setTaskDefinitonArn(taskDefinition.getTaskDefinitionArn());
        SlaveComputer agentComputer = agent.getComputer();
        if (agentComputer == null) {
            throw new IllegalStateException("Node was deleted, computer is null");
        }
        KeyValuePair envNodeName = new KeyValuePair();
        envNodeName.setName("SLAVE_NODE_NAME");
        envNodeName.setValue(agentComputer.getName());
        KeyValuePair envNodeSecret = new KeyValuePair();
        envNodeSecret.setName("SLAVE_NODE_SECRET");
        envNodeSecret.setValue(agentComputer.getJnlpMac());
        if (template.getAgentContainerName() != null) {
            agentContainerName = template.getAgentContainerName();
            if (!taskDefinition.getContainerDefinitions().stream().anyMatch(d -> d.getName().equals(agentContainerName))) {
                LOGGER.log(Level.SEVERE, "Could not find agent container name: {0} for template: {1}", new Object[]{agentContainerName, template.getDisplayName()});
                throw new RuntimeException("Could not find agent container name: " + agentContainerName);
            }
            LOGGER.log(Level.FINE, "Using the following container name as the Jenkins agent: {0}", agentContainerName);
        } else {
            agentContainerName = ((ContainerDefinition)taskDefinition.getContainerDefinitions().get(0)).getName();
            LOGGER.log(Level.FINE, "Found container definition with {0} container(s). Assuming first container is the Jenkins agent: {1}", new Object[]{taskDefinition.getContainerDefinitions().size(), agentContainerName});
        }
        Tag jenkinsLabelTag = new Tag().withKey(AWS_TAG_JENKINS_LABEL_KEY).withValue(template.getLabel());
        Tag jenkinsTemplateNameTag = new Tag().withKey(AWS_TAG_JENKINS_TEMPLATENAME_KEY).withValue(template.getTemplateName());
        RunTaskRequest req = new RunTaskRequest().withTaskDefinition(taskDefinition.getTaskDefinitionArn()).withTags(new Tag[]{jenkinsLabelTag, jenkinsTemplateNameTag}).withOverrides(new TaskOverride().withContainerOverrides(new ContainerOverride[]{new ContainerOverride().withName(agentContainerName).withCommand(command).withEnvironment(new KeyValuePair[]{envNodeName}).withEnvironment(new KeyValuePair[]{envNodeSecret})})).withPlacementStrategy(template.getPlacementStrategyEntries()).withCluster(clusterArn).withPropagateTags("TASK_DEFINITION");
        if (!template.getDefaultCapacityProvider() && template.getCapacityProviderStrategies() == null) {
            req.withLaunchType(LaunchType.fromValue((String)template.getLaunchType()));
        }
        if (!template.getDefaultCapacityProvider() && template.getCapacityProviderStrategies() != null) {
            req.withCapacityProviderStrategy(template.getCapacityProviderStrategyEntries());
        }
        if (template.isFargate()) {
            req.withPlatformVersion(template.getPlatformVersion());
        }
        if (template.isFargate() || template.isEC2()) {
            req.setEnableExecuteCommand(Boolean.valueOf(template.isEnableExecuteCommand()));
        }
        if (taskDefinition.getNetworkMode() != null && taskDefinition.getNetworkMode().equals("awsvpc")) {
            AwsVpcConfiguration awsVpcConfiguration = new AwsVpcConfiguration();
            awsVpcConfiguration.setAssignPublicIp(template.getAssignPublicIp() ? "ENABLED" : "DISABLED");
            awsVpcConfiguration.setSecurityGroups(Arrays.asList(template.getSecurityGroups().split(",")));
            awsVpcConfiguration.setSubnets(Arrays.asList(template.getSubnets().split(",")));
            NetworkConfiguration networkConfiguration = new NetworkConfiguration();
            networkConfiguration.withAwsvpcConfiguration(awsVpcConfiguration);
            req.withNetworkConfiguration(networkConfiguration);
        }
        return client.runTask(req);
    }
}

