/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.cloudbees.jenkins.plugins.amazonecs.ECSCloud;
import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

@Extension
public class ECSProvisioningStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(ECSProvisioningStrategy.class.getName());

    @Nonnull
    public NodeProvisioner.StrategyDecision apply(@Nonnull NodeProvisioner.StrategyState state) {
        LOGGER.log(Level.FINE, "Received {0}", new Object[]{state});
        LoadStatistics.LoadStatisticsSnapshot snap = state.getSnapshot();
        Label label = state.getLabel();
        int excessWorkload = snap.getQueueLength() - snap.getAvailableExecutors() - snap.getConnectingExecutors();
        block0: for (Cloud c : Jenkins.get().clouds) {
            if (excessWorkload <= 0) break;
            if (!c.canProvision(label)) continue;
            for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                CauseOfBlockage causeOfBlockage = cl.canProvision(c, label, excessWorkload);
                if (causeOfBlockage == null) continue;
                continue block0;
            }
            int provisioningCapacity = 0;
            if (c instanceof ECSCloud && (provisioningCapacity = ((ECSCloud)c).getProvisioningCapacity(excessWorkload, snap.getOnlineExecutors(), snap.getConnectingExecutors())) == 0) {
                return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
            }
            int requestAdditionalCapacities = provisioningCapacity == 0 ? excessWorkload : provisioningCapacity;
            Collection additionalCapacities = c.provision(label, requestAdditionalCapacities);
            ECSProvisioningStrategy.fireOnStarted(c, label, additionalCapacities);
            for (NodeProvisioner.PlannedNode ac : additionalCapacities) {
                LOGGER.log(Level.FINE, "Started provisioning {0} from {1} with {2,number,integer} executors. Remaining excess workload: {3,number,#.###}", new Object[]{ac.displayName, c.name, ac.numExecutors, excessWorkload -= ac.numExecutors});
            }
            state.recordPendingLaunches(additionalCapacities);
        }
        return excessWorkload > 0 ? NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES : NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
    }

    private static void fireOnStarted(Cloud cloud, Label label, Collection<NodeProvisioner.PlannedNode> plannedNodes) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onStarted(cloud, label, plannedNodes);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onStarted() listener call in " + String.valueOf(cl) + " for label " + label.toString(), e);
            }
        }
    }
}

