/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs.pipeline;

import com.cloudbees.jenkins.plugins.amazonecs.ECSCloud;
import com.cloudbees.jenkins.plugins.amazonecs.ECSTaskTemplate;
import com.cloudbees.jenkins.plugins.amazonecs.SerializableSupplier;
import com.cloudbees.jenkins.plugins.amazonecs.pipeline.ECSTaskTemplateStep;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.slaves.Cloud;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ECSTaskTemplateStepExecution
extends AbstractStepExecutionImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ECSTaskTemplateStepExecution.class.getName());
    private static final transient String NAME_FORMAT = "%s-%s";
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient ECSTaskTemplateStep step;
    private SerializableSupplier<Jenkins.CloudList> cloudSupplier;
    @Nonnull
    private String cloudName;
    private ECSTaskTemplate newTemplate = null;

    ECSTaskTemplateStepExecution(ECSTaskTemplateStep ecsTaskTemplateStep, StepContext context, SerializableSupplier<Jenkins.CloudList> cloudSupplier) {
        super(context);
        this.step = ecsTaskTemplateStep;
        this.cloudName = ecsTaskTemplateStep.getCloud();
        this.cloudSupplier = cloudSupplier;
    }

    public boolean start() throws Exception {
        LOGGER.log(Level.FINE, "In ECSTaskTemplateExecution run()");
        LOGGER.log(Level.FINE, "cloud: {0}", this.cloudName);
        LOGGER.log(Level.FINE, "label: {0}", this.step.getLabel());
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        String name = String.format(NAME_FORMAT, this.step.getName(), randString);
        String parentLabel = this.step.getInheritFrom();
        Cloud cloud = this.validateCloud(this.findCloud(parentLabel));
        this.cloudName = cloud.getDisplayName();
        ECSCloud ecsCloud = (ECSCloud)cloud;
        this.checkAllowedOverrides(ecsCloud, this.step);
        this.checkResourceLimits(ecsCloud, this.step);
        this.newTemplate = new ECSTaskTemplate(name, this.step.getLabel(), this.step.getAgentContainerName(), this.step.getTaskDefinitionOverride(), null, this.step.getImage(), this.step.getRepositoryCredentials(), this.step.getLaunchType(), this.step.getOperatingSystemFamily(), this.step.getCpuArchitecture(), this.step.getDefaultCapacityProvider(), this.step.getCapacityProviderStrategies(), this.step.getNetworkMode(), this.step.getRemoteFSRoot(), this.step.getUniqueRemoteFSRoot(), this.step.getPlatformVersion(), this.step.getMemory(), this.step.getMemoryReservation(), this.step.getCpu(), this.step.getEphemeralStorageSizeInGiB(), this.step.getSubnets(), this.step.getSecurityGroups(), this.step.getAssignPublicIp(), this.step.getPrivileged(), this.step.getContainerUser(), this.step.getKernelCapabilities(), this.step.getLogDriverOptions(), this.step.getTags(), this.step.getEnvironments(), this.step.getExtraHosts(), this.step.getMountPoints(), this.step.getEfsMountPoints(), this.step.getPortMappings(), this.step.getUlimits(), this.step.getExecutionRole(), this.step.getPlacementStrategies(), this.step.getTaskrole(), this.step.getInheritFrom(), this.step.getSharedMemorySize(), this.step.getEnableExecuteCommand());
        this.newTemplate.setLogDriver(this.step.getLogDriver());
        ECSTaskTemplate parentTemplate = ecsCloud.findParentTemplate(parentLabel);
        if (parentLabel != null && parentTemplate == null) {
            LOGGER.log(Level.WARNING, "InheritFrom specified as '{0}' but its template was not found. Continuing without a parent.", new Object[]{parentLabel});
        }
        this.newTemplate = this.newTemplate.merge(parentTemplate);
        LOGGER.log(Level.INFO, "Registering task template with name {0}", new Object[]{this.newTemplate.getTemplateName()});
        this.newTemplate = ecsCloud.addDynamicTemplate(this.newTemplate);
        this.getContext().newBodyInvoker().withContext((Object)this.step).withCallback((BodyExecutionCallback)new ECSTaskTemplateCallback(this.newTemplate)).start();
        return false;
    }

    private Cloud validateCloud(Cloud cloud) throws AbortException {
        if (cloud == null) {
            throw new AbortException(String.format("Unable to determine cloud configuration using: Labels: [%s], inheritFrom: '%s', Cloud: '%s'", this.step.getLabel(), this.step.getInheritFrom(), this.cloudName));
        }
        if (!(cloud instanceof ECSCloud)) {
            throw new AbortException(String.format("Cloud is not an ECS cloud: %s (%s)", this.cloudName, cloud.getClass().getName()));
        }
        return cloud;
    }

    private Cloud findCloud(String parentLabel) {
        Cloud cloud = null;
        Jenkins.CloudList clouds = (Jenkins.CloudList)this.cloudSupplier.get();
        if (parentLabel != null) {
            for (Cloud c : clouds) {
                ECSCloud ecsCloud;
                if (!(c instanceof ECSCloud) || !(ecsCloud = (ECSCloud)c).canProvision(parentLabel)) continue;
                cloud = c;
                break;
            }
        } else {
            cloud = clouds.getByName(this.cloudName);
        }
        return cloud;
    }

    private void checkAllowedOverrides(ECSCloud cloud, ECSTaskTemplateStep step) throws AbortException {
        for (String override : step.getOverrides()) {
            if (cloud.isAllowedOverride(override)) continue;
            LOGGER.log(Level.FINE, "Override {0} is not allowed", new Object[]{override});
            throw new AbortException(String.format("Cloud (%s): Not allowed to override '%s'. Allowed overrides are [%s]", cloud.getDisplayName(), override, cloud.getAllowedOverrides()));
        }
    }

    private void checkResourceLimits(ECSCloud cloud, ECSTaskTemplateStep step) throws AbortException {
        LOGGER.log(Level.FINE, "Cloud maxCpu: {0}", cloud.getMaxCpu());
        LOGGER.log(Level.FINE, "Cloud maxMemory: {0}", cloud.getMaxMemory());
        LOGGER.log(Level.FINE, "Cloud maxMemoryReservation: {0}", cloud.getMaxMemoryReservation());
        LOGGER.log(Level.FINE, "Step cpu: {0}", step.getCpu());
        LOGGER.log(Level.FINE, "Step memory: {0}", step.getMemory());
        LOGGER.log(Level.FINE, "Step memoryReservation: {0}", step.getMemoryReservation());
        LOGGER.log(Level.FINE, "Step shareMemorySize: {0}", step.getSharedMemorySize());
        if (cloud.getMaxCpu() != 0 && cloud.getMaxCpu() < step.getCpu()) {
            throw new AbortException("cpu is higher than maximum configured in cloud");
        }
        if (cloud.getMaxMemory() != 0 && cloud.getMaxMemory() < step.getMemory()) {
            throw new AbortException("memory is higher than maximum configured in cloud");
        }
        if (cloud.getMaxMemoryReservation() != 0 && cloud.getMaxMemoryReservation() < step.getMemoryReservation()) {
            throw new AbortException("memoryReservation is higher than maximum configured in cloud");
        }
    }

    public void stop(Throwable cause) throws Exception {
        super.stop(cause);
    }

    public void onResume() {
        super.onResume();
        Cloud c = Jenkins.get().getCloud(this.cloudName);
        if (c == null) {
            throw new RuntimeException(String.format("Cloud does not exist: %s", this.cloudName));
        }
        if (!(c instanceof ECSCloud)) {
            throw new RuntimeException(String.format("Cloud is not an ECS cloud: %s (%s)", this.cloudName, c.getClass().getName()));
        }
        ECSCloud ecsCloud = (ECSCloud)c;
        ecsCloud.addDynamicTemplate(this.newTemplate);
    }

    private class ECSTaskTemplateCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6043919968776851324L;
        private final ECSTaskTemplate taskTemplate;

        private ECSTaskTemplateCallback(ECSTaskTemplate taskTemplate) {
            this.taskTemplate = taskTemplate;
        }

        protected void finished(StepContext context) throws Exception {
            Cloud c = Jenkins.get().getCloud(ECSTaskTemplateStepExecution.this.cloudName);
            if (c == null) {
                LOGGER.log(Level.WARNING, "Cloud {0} no longer exists, cannot delete task template {1}", new Object[]{ECSTaskTemplateStepExecution.this.cloudName, this.taskTemplate.getTemplateName()});
                return;
            }
            if (c instanceof ECSCloud) {
                ECSCloud ecsCloud = (ECSCloud)c;
                LOGGER.log(Level.INFO, "Removing task template {1} from internal map and AWS cloud {0}", new Object[]{c.name, this.taskTemplate.getTemplateName()});
                ecsCloud.removeDynamicTemplate(this.taskTemplate);
            } else {
                LOGGER.log(Level.WARNING, "Cloud is not an ECSCloud: {0} {1}", new String[]{c.name, c.getClass().getName()});
            }
        }
    }
}

