/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs.pipeline;

import com.amazonaws.services.ecs.model.LaunchType;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.cloudbees.jenkins.plugins.amazonecs.ECSTaskTemplate;
import com.cloudbees.jenkins.plugins.amazonecs.pipeline.ECSTaskTemplateStepExecution;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ECSTaskTemplateStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ECSTaskTemplateStep.class.getName());
    private static final String DEFAULT_CLOUD = "cloud-default";
    private final String label;
    private final String name;
    private String cloud = "cloud-default";
    private String agentContainerName;
    private String taskDefinitionOverride;
    private String repositoryCredentials;
    private String image;
    private String launchType;
    private String operatingSystemFamily;
    private String cpuArchitecture;
    private boolean defaultCapacityProvider;
    private String networkMode;
    private String remoteFSRoot;
    private boolean uniqueRemoteFSRoot;
    private String platformVersion;
    private int memory;
    private int memoryReservation;
    private int cpu;
    private Integer ephemeralStorageSizeInGiB;
    private int sharedMemorySize;
    private String subnets;
    private String securityGroups;
    private boolean assignPublicIp;
    private boolean privileged;
    private String containerUser;
    private String kernelCapabilities;
    private String executionRole;
    private String taskrole;
    private String inheritFrom;
    private boolean enableExecuteCommand;
    private String logDriver;
    private List<ECSTaskTemplate.LogDriverOption> logDriverOptions;
    private List<ECSTaskTemplate.Tag> tags;
    private List<ECSTaskTemplate.EnvironmentEntry> environments;
    private List<ECSTaskTemplate.ExtraHostEntry> extraHosts;
    private List<ECSTaskTemplate.MountPointEntry> mountPoints;
    private List<ECSTaskTemplate.EFSMountPointEntry> efsMountPoints;
    private List<ECSTaskTemplate.PortMappingEntry> portMappings;
    private List<ECSTaskTemplate.UlimitEntry> ulimits;
    private List<ECSTaskTemplate.PlacementStrategyEntry> placementStrategies;
    private List<ECSTaskTemplate.CapacityProviderStrategyEntry> capacityProviderStrategies;
    private List<String> overrides;

    @DataBoundConstructor
    public ECSTaskTemplateStep(String label, String name) {
        this.label = label;
        this.name = name == null ? "jenkins-agent" : name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public String getCloud() {
        return this.cloud;
    }

    @DataBoundSetter
    public void setAgentContainerName(String agentContainerName) {
        this.agentContainerName = agentContainerName;
    }

    public String getAgentContainerName() {
        return this.agentContainerName;
    }

    @DataBoundSetter
    public void setTaskDefinitionOverride(String taskDefinitionOverride) {
        this.taskDefinitionOverride = taskDefinitionOverride;
    }

    public String getTaskDefinitionOverride() {
        return this.taskDefinitionOverride;
    }

    @DataBoundSetter
    public void setRepositoryCredentials(String repositoryCredentials) {
        this.repositoryCredentials = repositoryCredentials;
    }

    public String getRepositoryCredentials() {
        return this.repositoryCredentials;
    }

    @DataBoundSetter
    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    @DataBoundSetter
    public void setOperatingSystemFamily(String operatingSystemFamily) {
        this.operatingSystemFamily = operatingSystemFamily;
    }

    public String getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    @DataBoundSetter
    public void setCpuArchitecture(String cpuArchitecture) {
        this.cpuArchitecture = cpuArchitecture;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    @DataBoundSetter
    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    @DataBoundSetter
    public void setRemoteFSRoot(String remoteFSRoot) {
        this.remoteFSRoot = remoteFSRoot;
    }

    public String getRemoteFSRoot() {
        return this.remoteFSRoot;
    }

    @DataBoundSetter
    public void setUniqueRemoteFSRoot(boolean uniqueRemoteFSRoot) {
        this.uniqueRemoteFSRoot = uniqueRemoteFSRoot;
    }

    public boolean getUniqueRemoteFSRoot() {
        return this.uniqueRemoteFSRoot;
    }

    @DataBoundSetter
    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @DataBoundSetter
    public void setMemory(int memory) {
        this.memory = memory;
    }

    public int getMemory() {
        return this.memory;
    }

    @DataBoundSetter
    public void setMemoryReservation(int memoryReservation) {
        this.memoryReservation = memoryReservation;
    }

    public int getMemoryReservation() {
        return this.memoryReservation;
    }

    @DataBoundSetter
    public void setCpu(int cpu) {
        this.cpu = cpu;
    }

    public int getCpu() {
        return this.cpu;
    }

    @DataBoundSetter
    public void setEphemeralStorageSizeInGiB(Integer ephemeralStorageSizeInGiB) {
        this.ephemeralStorageSizeInGiB = ephemeralStorageSizeInGiB;
    }

    public Integer getEphemeralStorageSizeInGiB() {
        return this.ephemeralStorageSizeInGiB;
    }

    @DataBoundSetter
    public void setSharedMemorySize(int sharedMemorySize) {
        this.sharedMemorySize = sharedMemorySize;
    }

    public int getSharedMemorySize() {
        return this.sharedMemorySize;
    }

    @DataBoundSetter
    public void setSubnets(String subnets) {
        this.subnets = subnets;
    }

    public String getSubnets() {
        return this.subnets;
    }

    @DataBoundSetter
    public void setSecurityGroups(String securityGroups) {
        this.securityGroups = securityGroups;
    }

    public String getSecurityGroups() {
        return this.securityGroups;
    }

    @DataBoundSetter
    public void setAssignPublicIp(boolean assignPublicIp) {
        this.assignPublicIp = assignPublicIp;
    }

    public boolean getAssignPublicIp() {
        return this.assignPublicIp;
    }

    @DataBoundSetter
    public void setDefaultCapacityProvider(boolean defaultCapacityProvider) {
        this.defaultCapacityProvider = defaultCapacityProvider;
    }

    public boolean getDefaultCapacityProvider() {
        return this.defaultCapacityProvider;
    }

    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    @DataBoundSetter
    public void setContainerUser(String containerUser) {
        this.containerUser = containerUser;
    }

    public String getContainerUser() {
        return this.containerUser;
    }

    @DataBoundSetter
    public void setKernelCapabilities(String kernelCapabilities) {
        this.kernelCapabilities = kernelCapabilities;
    }

    public String getKernelCapabilities() {
        return this.kernelCapabilities;
    }

    @DataBoundSetter
    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    public String getExecutionRole() {
        return this.executionRole;
    }

    @DataBoundSetter
    public void setTaskrole(String taskrole) {
        this.taskrole = taskrole;
    }

    public String getTaskrole() {
        return this.taskrole;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setEnableExecuteCommand(boolean enableExecuteCommand) {
        this.enableExecuteCommand = enableExecuteCommand;
    }

    public boolean getEnableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public String getLogDriver() {
        return this.logDriver;
    }

    @DataBoundSetter
    public void setLogDriver(String logDriver) {
        this.logDriver = logDriver;
    }

    public List<ECSTaskTemplate.LogDriverOption> getLogDriverOptions() {
        return this.logDriverOptions;
    }

    @DataBoundSetter
    public void setLogDriverOptions(List<ECSTaskTemplate.LogDriverOption> logDriverOptions) {
        this.logDriverOptions = logDriverOptions;
    }

    public List<ECSTaskTemplate.Tag> getTags() {
        return this.tags;
    }

    @DataBoundSetter
    public void setTags(List<ECSTaskTemplate.Tag> tags) {
        this.tags = tags;
    }

    public List<ECSTaskTemplate.EnvironmentEntry> getEnvironments() {
        return this.environments;
    }

    @DataBoundSetter
    public void setEnvironments(List<ECSTaskTemplate.EnvironmentEntry> environments) {
        this.environments = environments;
    }

    public List<ECSTaskTemplate.ExtraHostEntry> getExtraHosts() {
        return this.extraHosts;
    }

    @DataBoundSetter
    public void setExtraHosts(List<ECSTaskTemplate.ExtraHostEntry> extraHosts) {
        this.extraHosts = extraHosts;
    }

    public List<ECSTaskTemplate.MountPointEntry> getMountPoints() {
        return this.mountPoints;
    }

    @DataBoundSetter
    public void setMountPoints(List<ECSTaskTemplate.MountPointEntry> mountPoints) {
        this.mountPoints = mountPoints;
    }

    public List<ECSTaskTemplate.EFSMountPointEntry> getEfsMountPoints() {
        return this.efsMountPoints;
    }

    @DataBoundSetter
    public void setEfsMountPoints(List<ECSTaskTemplate.EFSMountPointEntry> efsMountPoints) {
        this.efsMountPoints = efsMountPoints;
    }

    public List<ECSTaskTemplate.PortMappingEntry> getPortMappings() {
        return this.portMappings;
    }

    public List<ECSTaskTemplate.UlimitEntry> getUlimits() {
        return this.ulimits;
    }

    @DataBoundSetter
    public void setPortMappings(List<ECSTaskTemplate.PortMappingEntry> portMappings) {
        this.portMappings = portMappings;
    }

    @DataBoundSetter
    public void setUlimits(List<ECSTaskTemplate.UlimitEntry> ulimits) {
        this.ulimits = ulimits;
    }

    public List<ECSTaskTemplate.PlacementStrategyEntry> getPlacementStrategies() {
        return this.placementStrategies;
    }

    @DataBoundSetter
    public void setPlacementStrategies(List<ECSTaskTemplate.PlacementStrategyEntry> placementStrategies) {
        this.placementStrategies = placementStrategies;
    }

    public List<ECSTaskTemplate.CapacityProviderStrategyEntry> getCapacityProviderStrategies() {
        return this.capacityProviderStrategies;
    }

    @DataBoundSetter
    public void setCapacityProviderStrategies(List<ECSTaskTemplate.CapacityProviderStrategyEntry> capacityProviderStrategies) {
        this.capacityProviderStrategies = capacityProviderStrategies;
    }

    @DataBoundSetter
    public void setOverrides(List<String> overrides) {
        this.overrides = overrides;
    }

    public List<String> getOverrides() {
        return this.overrides;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        LOGGER.log(Level.FINE, "In ECSTaskTemplateStep start. label: {0}", this.label);
        LOGGER.log(Level.FINE, "In ECSTaskTemplateStep start. cloud: {0}", this.cloud);
        return new ECSTaskTemplateStepExecution(this, stepContext, () -> Jenkins.get().clouds);
    }

    public String toString() {
        return Arrays.stream(this.getClass().getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> {
            try {
                return String.format("%s: %s", f.getName(), f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException();
            }
        }).collect(Collectors.joining("\n"));
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "ecsTaskTemplate";
        }

        public String getDisplayName() {
            return "Define a task template to use in the AWS ECS plugin";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public ListBoxModel doFillLaunchTypeItems() {
            ListBoxModel options = new ListBoxModel();
            for (LaunchType launchType : LaunchType.values()) {
                options.add(launchType.toString());
            }
            return options;
        }

        public ListBoxModel doFillNetworkModeItems() {
            ListBoxModel options = new ListBoxModel();
            for (NetworkMode networkMode : NetworkMode.values()) {
                options.add(networkMode.toString());
            }
            return options;
        }

        public ListBoxModel doFillProtocolItems() {
            ListBoxModel options = new ListBoxModel();
            options.add("TCP", "tcp");
            options.add("UDP", "udp");
            return options;
        }

        public FormValidation doCheckSubnetsLaunchType(@QueryParameter(value="subnets") String subnets, @QueryParameter(value="launchType") String launchType) throws IOException, ServletException {
            if (launchType.contentEquals(LaunchType.FARGATE.toString())) {
                return FormValidation.error((String)"Subnets need to be set, when using FARGATE");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSubnetsNetworkMode(@QueryParameter(value="subnets") String subnets, @QueryParameter(value="networkMode") String networkMode) throws IOException, ServletException {
            if (networkMode.equals(NetworkMode.Awsvpc.toString()) && subnets.isEmpty()) {
                return FormValidation.error((String)"Subnets need to be set when using awsvpc network mode");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMemory(@QueryParameter(value="memory") int memory, @QueryParameter(value="memoryReservation") int memoryReservation) throws IOException, ServletException {
            return this.validateMemorySettings(memory, memoryReservation);
        }

        public FormValidation doCheckMemoryReservation(@QueryParameter(value="memory") int memory, @QueryParameter(value="memoryReservation") int memoryReservation) throws IOException, ServletException {
            return this.validateMemorySettings(memory, memoryReservation);
        }

        private FormValidation validateMemorySettings(int memory, int memoryReservation) {
            if (memory < 0 || memoryReservation < 0) {
                return FormValidation.error((String)"memory and/or memoryReservation must be 0 or a positive integer");
            }
            if (memory == 0 && memoryReservation == 0) {
                return FormValidation.error((String)"at least one of memory or memoryReservation are required to be > 0");
            }
            if (memory > 0 && memoryReservation > 0 && memory <= memoryReservation) {
                return FormValidation.error((String)"memory must be greater than memoryReservation if both are specified");
            }
            return FormValidation.ok();
        }
    }
}

