/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.RetryPolicy;
import com.cloudbees.jenkins.plugins.amazonecs.aws.RetryCondition;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.google.common.base.Joiner;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public abstract class BaseAWSService {
    Region getRegion(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            return RegionUtils.getRegion((String)regionName);
        }
        return Region.getRegion((Regions)Regions.US_EAST_1);
    }

    @CheckForNull
    protected AmazonWebServicesCredentials getCredentials(@Nullable String credentialsId) {
        return AWSCredentialsHelper.getCredentials((String)credentialsId, (ItemGroup)Jenkins.get());
    }

    protected ClientConfiguration createClientConfiguration() {
        ProxyConfiguration proxy = Jenkins.get().proxy;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (proxy != null) {
            clientConfiguration.setProxyHost(proxy.name);
            clientConfiguration.setProxyPort(proxy.port);
            clientConfiguration.setProxyUsername(proxy.getUserName());
            clientConfiguration.setProxyPassword(proxy.getPassword());
            if (proxy.getNoProxyHost() != null) {
                Object[] noProxyParts = proxy.getNoProxyHost().split("[ \t\n,|]+");
                clientConfiguration.setNonProxyHosts(Joiner.on((char)'|').join(noProxyParts));
            }
        }
        clientConfiguration.setRetryPolicy(this.ecsRetryPolicy());
        clientConfiguration.setMaxErrorRetry(10);
        return clientConfiguration;
    }

    private RetryPolicy ecsRetryPolicy() {
        return new RetryPolicy((RetryPolicy.RetryCondition)new RetryCondition(), null, 10, true);
    }
}

