/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.cloudbees.jenkins.plugins.amazonecs.ECSComputer;
import com.cloudbees.jenkins.plugins.amazonecs.ECSSlave;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Computer;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class ECSComputerListener
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(ECSComputerListener.class.getName());

    public static ECSComputerListener getInstance() {
        return (ECSComputerListener)((Object)ExtensionList.lookupSingleton(ECSComputerListener.class));
    }

    public void onOffline(@NonNull Computer c, OfflineCause cause) {
        if (c instanceof ECSComputer) {
            LOGGER.log(Level.INFO, "{0} is offline. Cause: {1}", new Object[]{c.getName(), cause});
            ECSSlave node = (ECSSlave)((ECSComputer)c).getNode();
            this.terminateNodeIfUnsurvivable(node);
        }
    }

    private void terminateNodeIfUnsurvivable(ECSSlave node) {
        if (node != null && !node.isSurvivable()) {
            try {
                LOGGER.log(Level.INFO, "Terminating unsurvivable node {0}", new Object[]{node.getTaskArn()});
                node.terminate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Unable to terminate node {0}", new Object[]{e});
                throw new RuntimeException(e);
            }
        }
    }
}

